<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RApplicationDialRules StructType
 * @subpackage Structs
 */
class RApplicationDialRules extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The numberBeginWith
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberBeginWith;
    /**
     * The numberOfDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfDigits;
    /**
     * The digitsToBeRemoved
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digitsToBeRemoved;
    /**
     * The prefixPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixPattern;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RApplicationDialRules
     * @uses RApplicationDialRules::setName()
     * @uses RApplicationDialRules::setDescription()
     * @uses RApplicationDialRules::setNumberBeginWith()
     * @uses RApplicationDialRules::setNumberOfDigits()
     * @uses RApplicationDialRules::setDigitsToBeRemoved()
     * @uses RApplicationDialRules::setPrefixPattern()
     * @uses RApplicationDialRules::setPriority()
     * @uses RApplicationDialRules::setUuid()
     * @param string $name
     * @param string $description
     * @param string $numberBeginWith
     * @param string $numberOfDigits
     * @param string $digitsToBeRemoved
     * @param string $prefixPattern
     * @param string $priority
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $numberBeginWith = null, $numberOfDigits = null, $digitsToBeRemoved = null, $prefixPattern = null, $priority = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setNumberBeginWith($numberBeginWith)
            ->setNumberOfDigits($numberOfDigits)
            ->setDigitsToBeRemoved($digitsToBeRemoved)
            ->setPrefixPattern($prefixPattern)
            ->setPriority($priority)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RApplicationDialRules
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RApplicationDialRules
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get numberBeginWith value
     * @return string|null
     */
    public function getNumberBeginWith()
    {
        return $this->numberBeginWith;
    }
    /**
     * Set numberBeginWith value
     * @param string $numberBeginWith
     * @return \StructType\RApplicationDialRules
     */
    public function setNumberBeginWith($numberBeginWith = null)
    {
        // validation for constraint: string
        if (!is_null($numberBeginWith) && !is_string($numberBeginWith)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberBeginWith, true), gettype($numberBeginWith)), __LINE__);
        }
        $this->numberBeginWith = $numberBeginWith;
        return $this;
    }
    /**
     * Get numberOfDigits value
     * @return string|null
     */
    public function getNumberOfDigits()
    {
        return $this->numberOfDigits;
    }
    /**
     * Set numberOfDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfDigits
     * @return \StructType\RApplicationDialRules
     */
    public function setNumberOfDigits($numberOfDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($numberOfDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($numberOfDigits) ? implode(', ', $numberOfDigits) : var_export($numberOfDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfDigits = $numberOfDigits;
        return $this;
    }
    /**
     * Get digitsToBeRemoved value
     * @return string|null
     */
    public function getDigitsToBeRemoved()
    {
        return $this->digitsToBeRemoved;
    }
    /**
     * Set digitsToBeRemoved value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitsToBeRemoved
     * @return \StructType\RApplicationDialRules
     */
    public function setDigitsToBeRemoved($digitsToBeRemoved = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($digitsToBeRemoved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($digitsToBeRemoved) ? implode(', ', $digitsToBeRemoved) : var_export($digitsToBeRemoved, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->digitsToBeRemoved = $digitsToBeRemoved;
        return $this;
    }
    /**
     * Get prefixPattern value
     * @return string|null
     */
    public function getPrefixPattern()
    {
        return $this->prefixPattern;
    }
    /**
     * Set prefixPattern value
     * @param string $prefixPattern
     * @return \StructType\RApplicationDialRules
     */
    public function setPrefixPattern($prefixPattern = null)
    {
        // validation for constraint: string
        if (!is_null($prefixPattern) && !is_string($prefixPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixPattern, true), gettype($prefixPattern)), __LINE__);
        }
        $this->prefixPattern = $prefixPattern;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\RApplicationDialRules
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RApplicationDialRules
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
