<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAdvertisedPatterns StructType
 * @subpackage Structs
 */
class RAdvertisedPatterns extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The patternType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternType;
    /**
     * The hostedRoutePSTNRule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hostedRoutePSTNRule;
    /**
     * The pstnFailStrip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pstnFailStrip;
    /**
     * The pstnFailPrepend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pstnFailPrepend;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAdvertisedPatterns
     * @uses RAdvertisedPatterns::setDescription()
     * @uses RAdvertisedPatterns::setPattern()
     * @uses RAdvertisedPatterns::setPatternType()
     * @uses RAdvertisedPatterns::setHostedRoutePSTNRule()
     * @uses RAdvertisedPatterns::setPstnFailStrip()
     * @uses RAdvertisedPatterns::setPstnFailPrepend()
     * @uses RAdvertisedPatterns::setUuid()
     * @param string $description
     * @param string $pattern
     * @param string $patternType
     * @param string $hostedRoutePSTNRule
     * @param string $pstnFailStrip
     * @param string $pstnFailPrepend
     * @param string $uuid
     */
    public function __construct($description = null, $pattern = null, $patternType = null, $hostedRoutePSTNRule = null, $pstnFailStrip = null, $pstnFailPrepend = null, $uuid = null)
    {
        $this
            ->setDescription($description)
            ->setPattern($pattern)
            ->setPatternType($patternType)
            ->setHostedRoutePSTNRule($hostedRoutePSTNRule)
            ->setPstnFailStrip($pstnFailStrip)
            ->setPstnFailPrepend($pstnFailPrepend)
            ->setUuid($uuid);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RAdvertisedPatterns
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\RAdvertisedPatterns
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get patternType value
     * @return string|null
     */
    public function getPatternType()
    {
        return $this->patternType;
    }
    /**
     * Set patternType value
     * @uses \EnumType\XGlobalNumber::valueIsValid()
     * @uses \EnumType\XGlobalNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternType
     * @return \StructType\RAdvertisedPatterns
     */
    public function setPatternType($patternType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XGlobalNumber::valueIsValid($patternType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XGlobalNumber', is_array($patternType) ? implode(', ', $patternType) : var_export($patternType, true), implode(', ', \EnumType\XGlobalNumber::getValidValues())), __LINE__);
        }
        $this->patternType = $patternType;
        return $this;
    }
    /**
     * Get hostedRoutePSTNRule value
     * @return string|null
     */
    public function getHostedRoutePSTNRule()
    {
        return $this->hostedRoutePSTNRule;
    }
    /**
     * Set hostedRoutePSTNRule value
     * @uses \EnumType\XHostedRoutePatternPSTNRule::valueIsValid()
     * @uses \EnumType\XHostedRoutePatternPSTNRule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hostedRoutePSTNRule
     * @return \StructType\RAdvertisedPatterns
     */
    public function setHostedRoutePSTNRule($hostedRoutePSTNRule = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHostedRoutePatternPSTNRule::valueIsValid($hostedRoutePSTNRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XHostedRoutePatternPSTNRule', is_array($hostedRoutePSTNRule) ? implode(', ', $hostedRoutePSTNRule) : var_export($hostedRoutePSTNRule, true), implode(', ', \EnumType\XHostedRoutePatternPSTNRule::getValidValues())), __LINE__);
        }
        $this->hostedRoutePSTNRule = $hostedRoutePSTNRule;
        return $this;
    }
    /**
     * Get pstnFailStrip value
     * @return string|null
     */
    public function getPstnFailStrip()
    {
        return $this->pstnFailStrip;
    }
    /**
     * Set pstnFailStrip value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pstnFailStrip
     * @return \StructType\RAdvertisedPatterns
     */
    public function setPstnFailStrip($pstnFailStrip = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($pstnFailStrip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($pstnFailStrip) ? implode(', ', $pstnFailStrip) : var_export($pstnFailStrip, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pstnFailStrip = $pstnFailStrip;
        return $this;
    }
    /**
     * Get pstnFailPrepend value
     * @return string|null
     */
    public function getPstnFailPrepend()
    {
        return $this->pstnFailPrepend;
    }
    /**
     * Set pstnFailPrepend value
     * @param string $pstnFailPrepend
     * @return \StructType\RAdvertisedPatterns
     */
    public function setPstnFailPrepend($pstnFailPrepend = null)
    {
        // validation for constraint: string
        if (!is_null($pstnFailPrepend) && !is_string($pstnFailPrepend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnFailPrepend, true), gettype($pstnFailPrepend)), __LINE__);
        }
        $this->pstnFailPrepend = $pstnFailPrepend;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RAdvertisedPatterns
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
