<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORLine StructType
 * @subpackage Structs
 */
class ORLine extends AbstractStructBase
{
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $routePartitionName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $aarNeighborhoodName;
    /**
     * The callForwardAll
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardAll
     */
    public $callForwardAll;
    /**
     * The callForwardBusy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardBusy
     */
    public $callForwardBusy;
    /**
     * The callForwardBusyInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardBusyInt
     */
    public $callForwardBusyInt;
    /**
     * The callForwardNoAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardNoAnswer
     */
    public $callForwardNoAnswer;
    /**
     * The callForwardNoAnswerInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardNoAnswerInt
     */
    public $callForwardNoAnswerInt;
    /**
     * The callForwardNoCoverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardNoCoverage
     */
    public $callForwardNoCoverage;
    /**
     * The callForwardNoCoverageInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardNoCoverageInt
     */
    public $callForwardNoCoverageInt;
    /**
     * The callForwardOnFailure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardOnFailure
     */
    public $callForwardOnFailure;
    /**
     * The callForwardAlternateParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardAlternateParty
     */
    public $callForwardAlternateParty;
    /**
     * The callForwardNotRegistered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardNotRegistered
     */
    public $callForwardNotRegistered;
    /**
     * The callForwardNotRegisteredInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORCallForwardNotRegisteredInt
     */
    public $callForwardNotRegisteredInt;
    /**
     * The callPickupGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callPickupGroupName;
    /**
     * The autoAnswer
     * Meta information extracted from the WSDL
     * - documentation: For an intercom line this tag should be treated as a mandatory tag and the valid values are Auto Answer with Headset and Auto Answer with Speakerphone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $autoAnswer;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $presenceGroupName;
    /**
     * The shareLineAppearanceCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $shareLineAppearanceCssName;
    /**
     * The voiceMailProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $voiceMailProfileName;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $releaseClause;
    /**
     * The cfaCssPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $cfaCssPolicy;
    /**
     * The defaultActivatedDeviceName
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable for only intercom lines and if not set, intercom lines will not be active.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $defaultActivatedDeviceName;
    /**
     * The parkMonForwardNoRetrieveCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $parkMonForwardNoRetrieveCssName;
    /**
     * The parkMonForwardNoRetrieveIntCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $parkMonForwardNoRetrieveIntCssName;
    /**
     * The partyEntranceTone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $partyEntranceTone;
    /**
     * The directoryURIs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DirectoryURIs
     */
    public $directoryURIs;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The externalCallControlProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $externalCallControlProfile;
    /**
     * The enterpriseAltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\E164AltNum
     */
    public $e164AltNum;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORLine
     * @uses ORLine::setUsage()
     * @uses ORLine::setRoutePartitionName()
     * @uses ORLine::setAarNeighborhoodName()
     * @uses ORLine::setCallForwardAll()
     * @uses ORLine::setCallForwardBusy()
     * @uses ORLine::setCallForwardBusyInt()
     * @uses ORLine::setCallForwardNoAnswer()
     * @uses ORLine::setCallForwardNoAnswerInt()
     * @uses ORLine::setCallForwardNoCoverage()
     * @uses ORLine::setCallForwardNoCoverageInt()
     * @uses ORLine::setCallForwardOnFailure()
     * @uses ORLine::setCallForwardAlternateParty()
     * @uses ORLine::setCallForwardNotRegistered()
     * @uses ORLine::setCallForwardNotRegisteredInt()
     * @uses ORLine::setCallPickupGroupName()
     * @uses ORLine::setAutoAnswer()
     * @uses ORLine::setNetworkHoldMohAudioSourceId()
     * @uses ORLine::setUserHoldMohAudioSourceId()
     * @uses ORLine::setPresenceGroupName()
     * @uses ORLine::setShareLineAppearanceCssName()
     * @uses ORLine::setVoiceMailProfileName()
     * @uses ORLine::setPatternPrecedence()
     * @uses ORLine::setReleaseClause()
     * @uses ORLine::setCfaCssPolicy()
     * @uses ORLine::setDefaultActivatedDeviceName()
     * @uses ORLine::setParkMonForwardNoRetrieveCssName()
     * @uses ORLine::setParkMonForwardNoRetrieveIntCssName()
     * @uses ORLine::setPartyEntranceTone()
     * @uses ORLine::setDirectoryURIs()
     * @uses ORLine::setConfidentialAccess()
     * @uses ORLine::setExternalCallControlProfile()
     * @uses ORLine::setEnterpriseAltNum()
     * @uses ORLine::setE164AltNum()
     * @uses ORLine::setUuid()
     * @param \StructType\ORFkType $usage
     * @param \StructType\ORFkType $routePartitionName
     * @param \StructType\ORFkType $aarNeighborhoodName
     * @param \StructType\ORCallForwardAll $callForwardAll
     * @param \StructType\ORCallForwardBusy $callForwardBusy
     * @param \StructType\ORCallForwardBusyInt $callForwardBusyInt
     * @param \StructType\ORCallForwardNoAnswer $callForwardNoAnswer
     * @param \StructType\ORCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @param \StructType\ORCallForwardNoCoverage $callForwardNoCoverage
     * @param \StructType\ORCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @param \StructType\ORCallForwardOnFailure $callForwardOnFailure
     * @param \StructType\ORCallForwardAlternateParty $callForwardAlternateParty
     * @param \StructType\ORCallForwardNotRegistered $callForwardNotRegistered
     * @param \StructType\ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @param \StructType\ORFkType $callPickupGroupName
     * @param \StructType\ORFkType $autoAnswer
     * @param \StructType\ORFkType $networkHoldMohAudioSourceId
     * @param \StructType\ORFkType $userHoldMohAudioSourceId
     * @param \StructType\ORFkType $presenceGroupName
     * @param \StructType\ORFkType $shareLineAppearanceCssName
     * @param \StructType\ORFkType $voiceMailProfileName
     * @param \StructType\ORFkType $patternPrecedence
     * @param \StructType\ORFkType $releaseClause
     * @param \StructType\ORFkType $cfaCssPolicy
     * @param \StructType\ORFkType $defaultActivatedDeviceName
     * @param \StructType\ORFkType $parkMonForwardNoRetrieveCssName
     * @param \StructType\ORFkType $parkMonForwardNoRetrieveIntCssName
     * @param \StructType\ORFkType $partyEntranceTone
     * @param \StructType\DirectoryURIs $directoryURIs
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param \StructType\ORFkType $externalCallControlProfile
     * @param \StructType\EnterpriseAltNum $enterpriseAltNum
     * @param \StructType\E164AltNum $e164AltNum
     * @param string $uuid
     */
    public function __construct(\StructType\ORFkType $usage = null, \StructType\ORFkType $routePartitionName = null, \StructType\ORFkType $aarNeighborhoodName = null, \StructType\ORCallForwardAll $callForwardAll = null, \StructType\ORCallForwardBusy $callForwardBusy = null, \StructType\ORCallForwardBusyInt $callForwardBusyInt = null, \StructType\ORCallForwardNoAnswer $callForwardNoAnswer = null, \StructType\ORCallForwardNoAnswerInt $callForwardNoAnswerInt = null, \StructType\ORCallForwardNoCoverage $callForwardNoCoverage = null, \StructType\ORCallForwardNoCoverageInt $callForwardNoCoverageInt = null, \StructType\ORCallForwardOnFailure $callForwardOnFailure = null, \StructType\ORCallForwardAlternateParty $callForwardAlternateParty = null, \StructType\ORCallForwardNotRegistered $callForwardNotRegistered = null, \StructType\ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null, \StructType\ORFkType $callPickupGroupName = null, \StructType\ORFkType $autoAnswer = null, \StructType\ORFkType $networkHoldMohAudioSourceId = null, \StructType\ORFkType $userHoldMohAudioSourceId = null, \StructType\ORFkType $presenceGroupName = null, \StructType\ORFkType $shareLineAppearanceCssName = null, \StructType\ORFkType $voiceMailProfileName = null, \StructType\ORFkType $patternPrecedence = null, \StructType\ORFkType $releaseClause = null, \StructType\ORFkType $cfaCssPolicy = null, \StructType\ORFkType $defaultActivatedDeviceName = null, \StructType\ORFkType $parkMonForwardNoRetrieveCssName = null, \StructType\ORFkType $parkMonForwardNoRetrieveIntCssName = null, \StructType\ORFkType $partyEntranceTone = null, \StructType\DirectoryURIs $directoryURIs = null, \StructType\ConfidentialAccess $confidentialAccess = null, \StructType\ORFkType $externalCallControlProfile = null, \StructType\EnterpriseAltNum $enterpriseAltNum = null, \StructType\E164AltNum $e164AltNum = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setCallForwardAll($callForwardAll)
            ->setCallForwardBusy($callForwardBusy)
            ->setCallForwardBusyInt($callForwardBusyInt)
            ->setCallForwardNoAnswer($callForwardNoAnswer)
            ->setCallForwardNoAnswerInt($callForwardNoAnswerInt)
            ->setCallForwardNoCoverage($callForwardNoCoverage)
            ->setCallForwardNoCoverageInt($callForwardNoCoverageInt)
            ->setCallForwardOnFailure($callForwardOnFailure)
            ->setCallForwardAlternateParty($callForwardAlternateParty)
            ->setCallForwardNotRegistered($callForwardNotRegistered)
            ->setCallForwardNotRegisteredInt($callForwardNotRegisteredInt)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setAutoAnswer($autoAnswer)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setPresenceGroupName($presenceGroupName)
            ->setShareLineAppearanceCssName($shareLineAppearanceCssName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setCfaCssPolicy($cfaCssPolicy)
            ->setDefaultActivatedDeviceName($defaultActivatedDeviceName)
            ->setParkMonForwardNoRetrieveCssName($parkMonForwardNoRetrieveCssName)
            ->setParkMonForwardNoRetrieveIntCssName($parkMonForwardNoRetrieveIntCssName)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setDirectoryURIs($directoryURIs)
            ->setConfidentialAccess($confidentialAccess)
            ->setExternalCallControlProfile($externalCallControlProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return \StructType\ORFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param \StructType\ORFkType $usage
     * @return \StructType\ORLine
     */
    public function setUsage(\StructType\ORFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\ORFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\ORFkType $routePartitionName
     * @return \StructType\ORLine
     */
    public function setRoutePartitionName(\StructType\ORFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\ORFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\ORFkType $aarNeighborhoodName
     * @return \StructType\ORLine
     */
    public function setAarNeighborhoodName(\StructType\ORFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get callForwardAll value
     * @return \StructType\ORCallForwardAll|null
     */
    public function getCallForwardAll()
    {
        return $this->callForwardAll;
    }
    /**
     * Set callForwardAll value
     * @param \StructType\ORCallForwardAll $callForwardAll
     * @return \StructType\ORLine
     */
    public function setCallForwardAll(\StructType\ORCallForwardAll $callForwardAll = null)
    {
        $this->callForwardAll = $callForwardAll;
        return $this;
    }
    /**
     * Get callForwardBusy value
     * @return \StructType\ORCallForwardBusy|null
     */
    public function getCallForwardBusy()
    {
        return $this->callForwardBusy;
    }
    /**
     * Set callForwardBusy value
     * @param \StructType\ORCallForwardBusy $callForwardBusy
     * @return \StructType\ORLine
     */
    public function setCallForwardBusy(\StructType\ORCallForwardBusy $callForwardBusy = null)
    {
        $this->callForwardBusy = $callForwardBusy;
        return $this;
    }
    /**
     * Get callForwardBusyInt value
     * @return \StructType\ORCallForwardBusyInt|null
     */
    public function getCallForwardBusyInt()
    {
        return $this->callForwardBusyInt;
    }
    /**
     * Set callForwardBusyInt value
     * @param \StructType\ORCallForwardBusyInt $callForwardBusyInt
     * @return \StructType\ORLine
     */
    public function setCallForwardBusyInt(\StructType\ORCallForwardBusyInt $callForwardBusyInt = null)
    {
        $this->callForwardBusyInt = $callForwardBusyInt;
        return $this;
    }
    /**
     * Get callForwardNoAnswer value
     * @return \StructType\ORCallForwardNoAnswer|null
     */
    public function getCallForwardNoAnswer()
    {
        return $this->callForwardNoAnswer;
    }
    /**
     * Set callForwardNoAnswer value
     * @param \StructType\ORCallForwardNoAnswer $callForwardNoAnswer
     * @return \StructType\ORLine
     */
    public function setCallForwardNoAnswer(\StructType\ORCallForwardNoAnswer $callForwardNoAnswer = null)
    {
        $this->callForwardNoAnswer = $callForwardNoAnswer;
        return $this;
    }
    /**
     * Get callForwardNoAnswerInt value
     * @return \StructType\ORCallForwardNoAnswerInt|null
     */
    public function getCallForwardNoAnswerInt()
    {
        return $this->callForwardNoAnswerInt;
    }
    /**
     * Set callForwardNoAnswerInt value
     * @param \StructType\ORCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @return \StructType\ORLine
     */
    public function setCallForwardNoAnswerInt(\StructType\ORCallForwardNoAnswerInt $callForwardNoAnswerInt = null)
    {
        $this->callForwardNoAnswerInt = $callForwardNoAnswerInt;
        return $this;
    }
    /**
     * Get callForwardNoCoverage value
     * @return \StructType\ORCallForwardNoCoverage|null
     */
    public function getCallForwardNoCoverage()
    {
        return $this->callForwardNoCoverage;
    }
    /**
     * Set callForwardNoCoverage value
     * @param \StructType\ORCallForwardNoCoverage $callForwardNoCoverage
     * @return \StructType\ORLine
     */
    public function setCallForwardNoCoverage(\StructType\ORCallForwardNoCoverage $callForwardNoCoverage = null)
    {
        $this->callForwardNoCoverage = $callForwardNoCoverage;
        return $this;
    }
    /**
     * Get callForwardNoCoverageInt value
     * @return \StructType\ORCallForwardNoCoverageInt|null
     */
    public function getCallForwardNoCoverageInt()
    {
        return $this->callForwardNoCoverageInt;
    }
    /**
     * Set callForwardNoCoverageInt value
     * @param \StructType\ORCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @return \StructType\ORLine
     */
    public function setCallForwardNoCoverageInt(\StructType\ORCallForwardNoCoverageInt $callForwardNoCoverageInt = null)
    {
        $this->callForwardNoCoverageInt = $callForwardNoCoverageInt;
        return $this;
    }
    /**
     * Get callForwardOnFailure value
     * @return \StructType\ORCallForwardOnFailure|null
     */
    public function getCallForwardOnFailure()
    {
        return $this->callForwardOnFailure;
    }
    /**
     * Set callForwardOnFailure value
     * @param \StructType\ORCallForwardOnFailure $callForwardOnFailure
     * @return \StructType\ORLine
     */
    public function setCallForwardOnFailure(\StructType\ORCallForwardOnFailure $callForwardOnFailure = null)
    {
        $this->callForwardOnFailure = $callForwardOnFailure;
        return $this;
    }
    /**
     * Get callForwardAlternateParty value
     * @return \StructType\ORCallForwardAlternateParty|null
     */
    public function getCallForwardAlternateParty()
    {
        return $this->callForwardAlternateParty;
    }
    /**
     * Set callForwardAlternateParty value
     * @param \StructType\ORCallForwardAlternateParty $callForwardAlternateParty
     * @return \StructType\ORLine
     */
    public function setCallForwardAlternateParty(\StructType\ORCallForwardAlternateParty $callForwardAlternateParty = null)
    {
        $this->callForwardAlternateParty = $callForwardAlternateParty;
        return $this;
    }
    /**
     * Get callForwardNotRegistered value
     * @return \StructType\ORCallForwardNotRegistered|null
     */
    public function getCallForwardNotRegistered()
    {
        return $this->callForwardNotRegistered;
    }
    /**
     * Set callForwardNotRegistered value
     * @param \StructType\ORCallForwardNotRegistered $callForwardNotRegistered
     * @return \StructType\ORLine
     */
    public function setCallForwardNotRegistered(\StructType\ORCallForwardNotRegistered $callForwardNotRegistered = null)
    {
        $this->callForwardNotRegistered = $callForwardNotRegistered;
        return $this;
    }
    /**
     * Get callForwardNotRegisteredInt value
     * @return \StructType\ORCallForwardNotRegisteredInt|null
     */
    public function getCallForwardNotRegisteredInt()
    {
        return $this->callForwardNotRegisteredInt;
    }
    /**
     * Set callForwardNotRegisteredInt value
     * @param \StructType\ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @return \StructType\ORLine
     */
    public function setCallForwardNotRegisteredInt(\StructType\ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null)
    {
        $this->callForwardNotRegisteredInt = $callForwardNotRegisteredInt;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \StructType\ORFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \StructType\ORFkType $callPickupGroupName
     * @return \StructType\ORLine
     */
    public function setCallPickupGroupName(\StructType\ORFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return \StructType\ORFkType|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @param \StructType\ORFkType $autoAnswer
     * @return \StructType\ORLine
     */
    public function setAutoAnswer(\StructType\ORFkType $autoAnswer = null)
    {
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return \StructType\ORFkType|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param \StructType\ORFkType $networkHoldMohAudioSourceId
     * @return \StructType\ORLine
     */
    public function setNetworkHoldMohAudioSourceId(\StructType\ORFkType $networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return \StructType\ORFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param \StructType\ORFkType $userHoldMohAudioSourceId
     * @return \StructType\ORLine
     */
    public function setUserHoldMohAudioSourceId(\StructType\ORFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\ORFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\ORFkType $presenceGroupName
     * @return \StructType\ORLine
     */
    public function setPresenceGroupName(\StructType\ORFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get shareLineAppearanceCssName value
     * @return \StructType\ORFkType|null
     */
    public function getShareLineAppearanceCssName()
    {
        return $this->shareLineAppearanceCssName;
    }
    /**
     * Set shareLineAppearanceCssName value
     * @param \StructType\ORFkType $shareLineAppearanceCssName
     * @return \StructType\ORLine
     */
    public function setShareLineAppearanceCssName(\StructType\ORFkType $shareLineAppearanceCssName = null)
    {
        $this->shareLineAppearanceCssName = $shareLineAppearanceCssName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return \StructType\ORFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param \StructType\ORFkType $voiceMailProfileName
     * @return \StructType\ORLine
     */
    public function setVoiceMailProfileName(\StructType\ORFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return \StructType\ORFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param \StructType\ORFkType $patternPrecedence
     * @return \StructType\ORLine
     */
    public function setPatternPrecedence(\StructType\ORFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return \StructType\ORFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param \StructType\ORFkType $releaseClause
     * @return \StructType\ORLine
     */
    public function setReleaseClause(\StructType\ORFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get cfaCssPolicy value
     * @return \StructType\ORFkType|null
     */
    public function getCfaCssPolicy()
    {
        return $this->cfaCssPolicy;
    }
    /**
     * Set cfaCssPolicy value
     * @param \StructType\ORFkType $cfaCssPolicy
     * @return \StructType\ORLine
     */
    public function setCfaCssPolicy(\StructType\ORFkType $cfaCssPolicy = null)
    {
        $this->cfaCssPolicy = $cfaCssPolicy;
        return $this;
    }
    /**
     * Get defaultActivatedDeviceName value
     * @return \StructType\ORFkType|null
     */
    public function getDefaultActivatedDeviceName()
    {
        return $this->defaultActivatedDeviceName;
    }
    /**
     * Set defaultActivatedDeviceName value
     * @param \StructType\ORFkType $defaultActivatedDeviceName
     * @return \StructType\ORLine
     */
    public function setDefaultActivatedDeviceName(\StructType\ORFkType $defaultActivatedDeviceName = null)
    {
        $this->defaultActivatedDeviceName = $defaultActivatedDeviceName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveCssName value
     * @return \StructType\ORFkType|null
     */
    public function getParkMonForwardNoRetrieveCssName()
    {
        return $this->parkMonForwardNoRetrieveCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveCssName value
     * @param \StructType\ORFkType $parkMonForwardNoRetrieveCssName
     * @return \StructType\ORLine
     */
    public function setParkMonForwardNoRetrieveCssName(\StructType\ORFkType $parkMonForwardNoRetrieveCssName = null)
    {
        $this->parkMonForwardNoRetrieveCssName = $parkMonForwardNoRetrieveCssName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntCssName value
     * @return \StructType\ORFkType|null
     */
    public function getParkMonForwardNoRetrieveIntCssName()
    {
        return $this->parkMonForwardNoRetrieveIntCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveIntCssName value
     * @param \StructType\ORFkType $parkMonForwardNoRetrieveIntCssName
     * @return \StructType\ORLine
     */
    public function setParkMonForwardNoRetrieveIntCssName(\StructType\ORFkType $parkMonForwardNoRetrieveIntCssName = null)
    {
        $this->parkMonForwardNoRetrieveIntCssName = $parkMonForwardNoRetrieveIntCssName;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return \StructType\ORFkType|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @param \StructType\ORFkType $partyEntranceTone
     * @return \StructType\ORLine
     */
    public function setPartyEntranceTone(\StructType\ORFkType $partyEntranceTone = null)
    {
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get directoryURIs value
     * @return \StructType\DirectoryURIs|null
     */
    public function getDirectoryURIs()
    {
        return $this->directoryURIs;
    }
    /**
     * Set directoryURIs value
     * @param \StructType\DirectoryURIs $directoryURIs
     * @return \StructType\ORLine
     */
    public function setDirectoryURIs(\StructType\DirectoryURIs $directoryURIs = null)
    {
        $this->directoryURIs = $directoryURIs;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\ORLine
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get externalCallControlProfile value
     * @return \StructType\ORFkType|null
     */
    public function getExternalCallControlProfile()
    {
        return $this->externalCallControlProfile;
    }
    /**
     * Set externalCallControlProfile value
     * @param \StructType\ORFkType $externalCallControlProfile
     * @return \StructType\ORLine
     */
    public function setExternalCallControlProfile(\StructType\ORFkType $externalCallControlProfile = null)
    {
        $this->externalCallControlProfile = $externalCallControlProfile;
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return \StructType\EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param \StructType\EnterpriseAltNum $enterpriseAltNum
     * @return \StructType\ORLine
     */
    public function setEnterpriseAltNum(\StructType\EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return \StructType\E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param \StructType\E164AltNum $e164AltNum
     * @return \StructType\ORLine
     */
    public function setE164AltNum(\StructType\E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\ORLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
