<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for locales StructType
 * @subpackage Structs
 */
class Locales extends XCommonMembersExtension
{
    /**
     * The locale
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XMobileVoiceMember[]
     */
    public $locale;
    /**
     * Constructor method for locales
     * @uses Locales::setLocale()
     * @param \StructType\XMobileVoiceMember[] $locale
     */
    public function __construct(array $locale = array())
    {
        $this
            ->setLocale($locale);
    }
    /**
     * Get locale value
     * @return \StructType\XMobileVoiceMember[]|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * This method is responsible for validating the values passed to the setLocale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocale method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocaleForArrayConstraintsFromSetLocale(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $localesLocaleItem) {
            // validation for constraint: itemType
            if (!$localesLocaleItem instanceof \StructType\XMobileVoiceMember) {
                $invalidValues[] = is_object($localesLocaleItem) ? get_class($localesLocaleItem) : sprintf('%s(%s)', gettype($localesLocaleItem), var_export($localesLocaleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The locale property can only contain items of type \StructType\XMobileVoiceMember, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set locale value
     * @throws \InvalidArgumentException
     * @param \StructType\XMobileVoiceMember[] $locale
     * @return \StructType\Locales
     */
    public function setLocale(array $locale = array())
    {
        // validation for constraint: array
        if ('' !== ($localeArrayErrorMessage = self::validateLocaleForArrayConstraintsFromSetLocale($locale))) {
            throw new \InvalidArgumentException($localeArrayErrorMessage, __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Add item to locale value
     * @throws \InvalidArgumentException
     * @param \StructType\XMobileVoiceMember $item
     * @return \StructType\Locales
     */
    public function addToLocale(\StructType\XMobileVoiceMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XMobileVoiceMember) {
            throw new \InvalidArgumentException(sprintf('The locale property can only contain items of type \StructType\XMobileVoiceMember, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->locale[] = $item;
        return $this;
    }
}
