<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for lineAssociations StructType
 * Meta information extracted from the WSDL
 * - documentation: The line association for this remote destination. The line to be associated must already be added to the remote destination profile. All directory numbers specified must already exist in the database.
 * @subpackage Structs
 */
class LineAssociations extends AbstractStructBase
{
    /**
     * The lineAssociation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XLineAssociation[]
     */
    public $lineAssociation;
    /**
     * Constructor method for lineAssociations
     * @uses LineAssociations::setLineAssociation()
     * @param \StructType\XLineAssociation[] $lineAssociation
     */
    public function __construct(array $lineAssociation = array())
    {
        $this
            ->setLineAssociation($lineAssociation);
    }
    /**
     * Get lineAssociation value
     * @return \StructType\XLineAssociation[]|null
     */
    public function getLineAssociation()
    {
        return $this->lineAssociation;
    }
    /**
     * This method is responsible for validating the values passed to the setLineAssociation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineAssociation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineAssociationForArrayConstraintsFromSetLineAssociation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineAssociationsLineAssociationItem) {
            // validation for constraint: itemType
            if (!$lineAssociationsLineAssociationItem instanceof \StructType\XLineAssociation) {
                $invalidValues[] = is_object($lineAssociationsLineAssociationItem) ? get_class($lineAssociationsLineAssociationItem) : sprintf('%s(%s)', gettype($lineAssociationsLineAssociationItem), var_export($lineAssociationsLineAssociationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lineAssociation property can only contain items of type \StructType\XLineAssociation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lineAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\XLineAssociation[] $lineAssociation
     * @return \StructType\LineAssociations
     */
    public function setLineAssociation(array $lineAssociation = array())
    {
        // validation for constraint: array
        if ('' !== ($lineAssociationArrayErrorMessage = self::validateLineAssociationForArrayConstraintsFromSetLineAssociation($lineAssociation))) {
            throw new \InvalidArgumentException($lineAssociationArrayErrorMessage, __LINE__);
        }
        $this->lineAssociation = $lineAssociation;
        return $this;
    }
    /**
     * Add item to lineAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\XLineAssociation $item
     * @return \StructType\LineAssociations
     */
    public function addToLineAssociation(\StructType\XLineAssociation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XLineAssociation) {
            throw new \InvalidArgumentException(sprintf('The lineAssociation property can only contain items of type \StructType\XLineAssociation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lineAssociation[] = $item;
        return $this;
    }
}
