<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSyslogConfiguration StructType
 * @subpackage Structs
 */
class LSyslogConfiguration extends AbstractStructBase
{
    /**
     * The alarmConfigs
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var \StructType\LSyslogConfig[]
     */
    public $alarmConfigs;
    /**
     * The serverName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serverName;
    /**
     * The serviceGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceGroup;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The EndPointAlarm
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $EndPointAlarm;
    /**
     * Constructor method for LSyslogConfiguration
     * @uses LSyslogConfiguration::setAlarmConfigs()
     * @uses LSyslogConfiguration::setServerName()
     * @uses LSyslogConfiguration::setServiceGroup()
     * @uses LSyslogConfiguration::setService()
     * @uses LSyslogConfiguration::setEndPointAlarm()
     * @param \StructType\LSyslogConfig[] $alarmConfigs
     * @param string $serverName
     * @param string $serviceGroup
     * @param string $service
     * @param string $endPointAlarm
     */
    public function __construct(array $alarmConfigs = array(), $serverName = null, $serviceGroup = null, $service = null, $endPointAlarm = null)
    {
        $this
            ->setAlarmConfigs($alarmConfigs)
            ->setServerName($serverName)
            ->setServiceGroup($serviceGroup)
            ->setService($service)
            ->setEndPointAlarm($endPointAlarm);
    }
    /**
     * Get alarmConfigs value
     * @return \StructType\LSyslogConfig[]
     */
    public function getAlarmConfigs()
    {
        return $this->alarmConfigs;
    }
    /**
     * This method is responsible for validating the values passed to the setAlarmConfigs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlarmConfigs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlarmConfigsForArrayConstraintsFromSetAlarmConfigs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lSyslogConfigurationAlarmConfigsItem) {
            // validation for constraint: itemType
            if (!$lSyslogConfigurationAlarmConfigsItem instanceof \StructType\LSyslogConfig) {
                $invalidValues[] = is_object($lSyslogConfigurationAlarmConfigsItem) ? get_class($lSyslogConfigurationAlarmConfigsItem) : sprintf('%s(%s)', gettype($lSyslogConfigurationAlarmConfigsItem), var_export($lSyslogConfigurationAlarmConfigsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The alarmConfigs property can only contain items of type \StructType\LSyslogConfig, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set alarmConfigs value
     * @throws \InvalidArgumentException
     * @param \StructType\LSyslogConfig[] $alarmConfigs
     * @return \StructType\LSyslogConfiguration
     */
    public function setAlarmConfigs(array $alarmConfigs = array())
    {
        // validation for constraint: array
        if ('' !== ($alarmConfigsArrayErrorMessage = self::validateAlarmConfigsForArrayConstraintsFromSetAlarmConfigs($alarmConfigs))) {
            throw new \InvalidArgumentException($alarmConfigsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($alarmConfigs) && count($alarmConfigs) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($alarmConfigs)), __LINE__);
        }
        $this->alarmConfigs = $alarmConfigs;
        return $this;
    }
    /**
     * Add item to alarmConfigs value
     * @throws \InvalidArgumentException
     * @param \StructType\LSyslogConfig $item
     * @return \StructType\LSyslogConfiguration
     */
    public function addToAlarmConfigs(\StructType\LSyslogConfig $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LSyslogConfig) {
            throw new \InvalidArgumentException(sprintf('The alarmConfigs property can only contain items of type \StructType\LSyslogConfig, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->alarmConfigs) && count($this->alarmConfigs) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->alarmConfigs)), __LINE__);
        }
        $this->alarmConfigs[] = $item;
        return $this;
    }
    /**
     * Get serverName value
     * @return string|null
     */
    public function getServerName()
    {
        return $this->serverName;
    }
    /**
     * Set serverName value
     * @param string $serverName
     * @return \StructType\LSyslogConfiguration
     */
    public function setServerName($serverName = null)
    {
        // validation for constraint: string
        if (!is_null($serverName) && !is_string($serverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverName, true), gettype($serverName)), __LINE__);
        }
        $this->serverName = $serverName;
        return $this;
    }
    /**
     * Get serviceGroup value
     * @return string|null
     */
    public function getServiceGroup()
    {
        return $this->serviceGroup;
    }
    /**
     * Set serviceGroup value
     * @uses \EnumType\XServiceGrouping::valueIsValid()
     * @uses \EnumType\XServiceGrouping::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceGroup
     * @return \StructType\LSyslogConfiguration
     */
    public function setServiceGroup($serviceGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XServiceGrouping::valueIsValid($serviceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XServiceGrouping', is_array($serviceGroup) ? implode(', ', $serviceGroup) : var_export($serviceGroup, true), implode(', ', \EnumType\XServiceGrouping::getValidValues())), __LINE__);
        }
        $this->serviceGroup = $serviceGroup;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\LSyslogConfiguration
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get EndPointAlarm value
     * @return string|null
     */
    public function getEndPointAlarm()
    {
        return $this->EndPointAlarm;
    }
    /**
     * Set EndPointAlarm value
     * @param string $endPointAlarm
     * @return \StructType\LSyslogConfiguration
     */
    public function setEndPointAlarm($endPointAlarm = null)
    {
        // validation for constraint: string
        if (!is_null($endPointAlarm) && !is_string($endPointAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endPointAlarm, true), gettype($endPointAlarm)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($endPointAlarm) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $endPointAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($endPointAlarm, true)), __LINE__);
        }
        $this->EndPointAlarm = $endPointAlarm;
        return $this;
    }
}
