<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSipProfile StructType
 * @subpackage Structs
 */
class LSipProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The defaultTelephonyEventPayloadType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $defaultTelephonyEventPayloadType;
    /**
     * The redirectByApplication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectByApplication;
    /**
     * The ringing180
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ringing180;
    /**
     * The timerInvite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerInvite;
    /**
     * The timerRegisterDelta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerRegisterDelta;
    /**
     * The timerRegister
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerRegister;
    /**
     * The timerT1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerT1;
    /**
     * The timerT2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerT2;
    /**
     * The retryInvite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryInvite;
    /**
     * The retryNotInvite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryNotInvite;
    /**
     * The startMediaPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startMediaPort;
    /**
     * The stopMediaPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $stopMediaPort;
    /**
     * The callpickupListUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callpickupListUri;
    /**
     * The callpickupGroupUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callpickupGroupUri;
    /**
     * The meetmeServiceUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $meetmeServiceUrl;
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telnetLevel;
    /**
     * The timerKeepAlive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerKeepAlive;
    /**
     * The timerSubscribe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerSubscribe;
    /**
     * The timerSubscribeDelta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerSubscribeDelta;
    /**
     * The maxRedirects
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxRedirects;
    /**
     * The timerOffHookToFirstDigit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerOffHookToFirstDigit;
    /**
     * The callForwardUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callForwardUri;
    /**
     * The abbreviatedDialUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $abbreviatedDialUri;
    /**
     * The confJointEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $confJointEnable;
    /**
     * The rfc2543Hold
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2543Hold;
    /**
     * The semiAttendedTransfer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $semiAttendedTransfer;
    /**
     * The enableVad
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableVad;
    /**
     * The stutterMsgWaiting
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $stutterMsgWaiting;
    /**
     * The callStats
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callStats;
    /**
     * The t38Invite
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $t38Invite;
    /**
     * The rerouteIncomingRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The enableAnatForEarlyOfferCalls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableAnatForEarlyOfferCalls;
    /**
     * The rsvpOverSip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rsvpOverSip;
    /**
     * The fallbackToLocalRsvp
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $fallbackToLocalRsvp;
    /**
     * The sipRe11XxEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gClear;
    /**
     * The sendRecvSDPInMidCallInvite
     * Meta information extracted from the WSDL
     * - documentation: This field is editable only if earlyOfferSupportForVoiceCall is set to true.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRecvSDPInMidCallInvite;
    /**
     * The enableOutboundOptionsPing
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableOutboundOptionsPing;
    /**
     * The optionsPingIntervalWhenStatusOK
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $optionsPingIntervalWhenStatusOK;
    /**
     * The optionsPingIntervalWhenStatusNotOK
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $optionsPingIntervalWhenStatusNotOK;
    /**
     * The deliverConferenceBridgeIdentifier
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $deliverConferenceBridgeIdentifier;
    /**
     * The sipOptionsRetryCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipOptionsRetryCount;
    /**
     * The sipOptionsRetryTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipOptionsRetryTimer;
    /**
     * The sipBandwidthModifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipBandwidthModifier;
    /**
     * The enableUriOutdialSupport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enableUriOutdialSupport;
    /**
     * The userAgentServerHeaderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userAgentServerHeaderInfo;
    /**
     * The allowPresentationSharingUsingBfcp
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowPresentationSharingUsingBfcp;
    /**
     * The scriptParameters
     * Meta information extracted from the WSDL
     * - documentation: This field will be enabled only when SIP Normalization Script is present.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scriptParameters;
    /**
     * The isScriptTraceEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field will be enabled only when SIP Normalization Script is present.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isScriptTraceEnabled;
    /**
     * The sipNormalizationScript
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sipNormalizationScript;
    /**
     * The allowiXApplicationMedia
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowiXApplicationMedia;
    /**
     * The dialStringInterpretation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialStringInterpretation;
    /**
     * The acceptAudioCodecPreferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $acceptAudioCodecPreferences;
    /**
     * The mlppUserAuthorization
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mlppUserAuthorization;
    /**
     * The isAssuredSipServiceEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isAssuredSipServiceEnabled;
    /**
     * The resourcePriorityNamespace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $resourcePriorityNamespace;
    /**
     * The useCallerIdCallerNameinUriOutgoingRequest
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerIdCallerNameinUriOutgoingRequest;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDn;
    /**
     * The callerName
     * Meta information extracted from the WSDL
     * - documentation: Characters which are not valid for caller name are ampersand, braces, less than or greater than, percentage sign, double quotes, square brackets and pipe.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerName;
    /**
     * The callingLineIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLineIdentification;
    /**
     * The rejectAnonymousIncomingCall
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousIncomingCall;
    /**
     * The callpickupUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callpickupUri;
    /**
     * The rejectAnonymousOutgoingCall
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousOutgoingCall;
    /**
     * The videoCallTrafficClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $videoCallTrafficClass;
    /**
     * The sdpTransparency
     * Meta information extracted from the WSDL
     * - documentation: SDP Transparency Profile for SIP Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sdpTransparency;
    /**
     * The allowMultipleCodecs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowMultipleCodecs;
    /**
     * The sipSessionRefreshMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipSessionRefreshMethod;
    /**
     * The earlyOfferSuppVoiceCall
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $earlyOfferSuppVoiceCall;
    /**
     * The cucmVersionInSipHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cucmVersionInSipHeader;
    /**
     * The confidentialAccessLevelHeaders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $confidentialAccessLevelHeaders;
    /**
     * The destRouteString
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $destRouteString;
    /**
     * The inactiveSDPRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $inactiveSDPRequired;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSipProfile
     * @uses LSipProfile::setName()
     * @uses LSipProfile::setDescription()
     * @uses LSipProfile::setDefaultTelephonyEventPayloadType()
     * @uses LSipProfile::setRedirectByApplication()
     * @uses LSipProfile::setRinging180()
     * @uses LSipProfile::setTimerInvite()
     * @uses LSipProfile::setTimerRegisterDelta()
     * @uses LSipProfile::setTimerRegister()
     * @uses LSipProfile::setTimerT1()
     * @uses LSipProfile::setTimerT2()
     * @uses LSipProfile::setRetryInvite()
     * @uses LSipProfile::setRetryNotInvite()
     * @uses LSipProfile::setStartMediaPort()
     * @uses LSipProfile::setStopMediaPort()
     * @uses LSipProfile::setCallpickupListUri()
     * @uses LSipProfile::setCallpickupGroupUri()
     * @uses LSipProfile::setMeetmeServiceUrl()
     * @uses LSipProfile::setUserInfo()
     * @uses LSipProfile::setDtmfDbLevel()
     * @uses LSipProfile::setCallHoldRingback()
     * @uses LSipProfile::setAnonymousCallBlock()
     * @uses LSipProfile::setCallerIdBlock()
     * @uses LSipProfile::setDndControl()
     * @uses LSipProfile::setTelnetLevel()
     * @uses LSipProfile::setTimerKeepAlive()
     * @uses LSipProfile::setTimerSubscribe()
     * @uses LSipProfile::setTimerSubscribeDelta()
     * @uses LSipProfile::setMaxRedirects()
     * @uses LSipProfile::setTimerOffHookToFirstDigit()
     * @uses LSipProfile::setCallForwardUri()
     * @uses LSipProfile::setAbbreviatedDialUri()
     * @uses LSipProfile::setConfJointEnable()
     * @uses LSipProfile::setRfc2543Hold()
     * @uses LSipProfile::setSemiAttendedTransfer()
     * @uses LSipProfile::setEnableVad()
     * @uses LSipProfile::setStutterMsgWaiting()
     * @uses LSipProfile::setCallStats()
     * @uses LSipProfile::setT38Invite()
     * @uses LSipProfile::setRerouteIncomingRequest()
     * @uses LSipProfile::setResourcePriorityNamespaceListName()
     * @uses LSipProfile::setEnableAnatForEarlyOfferCalls()
     * @uses LSipProfile::setRsvpOverSip()
     * @uses LSipProfile::setFallbackToLocalRsvp()
     * @uses LSipProfile::setSipRe11XxEnabled()
     * @uses LSipProfile::setGClear()
     * @uses LSipProfile::setSendRecvSDPInMidCallInvite()
     * @uses LSipProfile::setEnableOutboundOptionsPing()
     * @uses LSipProfile::setOptionsPingIntervalWhenStatusOK()
     * @uses LSipProfile::setOptionsPingIntervalWhenStatusNotOK()
     * @uses LSipProfile::setDeliverConferenceBridgeIdentifier()
     * @uses LSipProfile::setSipOptionsRetryCount()
     * @uses LSipProfile::setSipOptionsRetryTimer()
     * @uses LSipProfile::setSipBandwidthModifier()
     * @uses LSipProfile::setEnableUriOutdialSupport()
     * @uses LSipProfile::setUserAgentServerHeaderInfo()
     * @uses LSipProfile::setAllowPresentationSharingUsingBfcp()
     * @uses LSipProfile::setScriptParameters()
     * @uses LSipProfile::setIsScriptTraceEnabled()
     * @uses LSipProfile::setSipNormalizationScript()
     * @uses LSipProfile::setAllowiXApplicationMedia()
     * @uses LSipProfile::setDialStringInterpretation()
     * @uses LSipProfile::setAcceptAudioCodecPreferences()
     * @uses LSipProfile::setMlppUserAuthorization()
     * @uses LSipProfile::setIsAssuredSipServiceEnabled()
     * @uses LSipProfile::setResourcePriorityNamespace()
     * @uses LSipProfile::setUseCallerIdCallerNameinUriOutgoingRequest()
     * @uses LSipProfile::setCallerIdDn()
     * @uses LSipProfile::setCallerName()
     * @uses LSipProfile::setCallingLineIdentification()
     * @uses LSipProfile::setRejectAnonymousIncomingCall()
     * @uses LSipProfile::setCallpickupUri()
     * @uses LSipProfile::setRejectAnonymousOutgoingCall()
     * @uses LSipProfile::setVideoCallTrafficClass()
     * @uses LSipProfile::setSdpTransparency()
     * @uses LSipProfile::setAllowMultipleCodecs()
     * @uses LSipProfile::setSipSessionRefreshMethod()
     * @uses LSipProfile::setEarlyOfferSuppVoiceCall()
     * @uses LSipProfile::setCucmVersionInSipHeader()
     * @uses LSipProfile::setConfidentialAccessLevelHeaders()
     * @uses LSipProfile::setDestRouteString()
     * @uses LSipProfile::setInactiveSDPRequired()
     * @uses LSipProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $defaultTelephonyEventPayloadType
     * @param string $redirectByApplication
     * @param string $ringing180
     * @param string $timerInvite
     * @param string $timerRegisterDelta
     * @param string $timerRegister
     * @param string $timerT1
     * @param string $timerT2
     * @param string $retryInvite
     * @param string $retryNotInvite
     * @param string $startMediaPort
     * @param string $stopMediaPort
     * @param string $callpickupListUri
     * @param string $callpickupGroupUri
     * @param string $meetmeServiceUrl
     * @param string $userInfo
     * @param string $dtmfDbLevel
     * @param string $callHoldRingback
     * @param string $anonymousCallBlock
     * @param string $callerIdBlock
     * @param string $dndControl
     * @param string $telnetLevel
     * @param string $timerKeepAlive
     * @param string $timerSubscribe
     * @param string $timerSubscribeDelta
     * @param string $maxRedirects
     * @param string $timerOffHookToFirstDigit
     * @param string $callForwardUri
     * @param string $abbreviatedDialUri
     * @param string $confJointEnable
     * @param string $rfc2543Hold
     * @param string $semiAttendedTransfer
     * @param string $enableVad
     * @param string $stutterMsgWaiting
     * @param string $callStats
     * @param string $t38Invite
     * @param string $rerouteIncomingRequest
     * @param \StructType\XFkType $resourcePriorityNamespaceListName
     * @param string $enableAnatForEarlyOfferCalls
     * @param string $rsvpOverSip
     * @param string $fallbackToLocalRsvp
     * @param string $sipRe11XxEnabled
     * @param string $gClear
     * @param string $sendRecvSDPInMidCallInvite
     * @param string $enableOutboundOptionsPing
     * @param string $optionsPingIntervalWhenStatusOK
     * @param string $optionsPingIntervalWhenStatusNotOK
     * @param string $deliverConferenceBridgeIdentifier
     * @param string $sipOptionsRetryCount
     * @param string $sipOptionsRetryTimer
     * @param string $sipBandwidthModifier
     * @param string $enableUriOutdialSupport
     * @param string $userAgentServerHeaderInfo
     * @param string $allowPresentationSharingUsingBfcp
     * @param string $scriptParameters
     * @param string $isScriptTraceEnabled
     * @param \StructType\XFkType $sipNormalizationScript
     * @param string $allowiXApplicationMedia
     * @param string $dialStringInterpretation
     * @param string $acceptAudioCodecPreferences
     * @param string $mlppUserAuthorization
     * @param string $isAssuredSipServiceEnabled
     * @param \StructType\XFkType $resourcePriorityNamespace
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @param string $callerIdDn
     * @param string $callerName
     * @param string $callingLineIdentification
     * @param string $rejectAnonymousIncomingCall
     * @param string $callpickupUri
     * @param string $rejectAnonymousOutgoingCall
     * @param string $videoCallTrafficClass
     * @param \StructType\XFkType $sdpTransparency
     * @param string $allowMultipleCodecs
     * @param string $sipSessionRefreshMethod
     * @param string $earlyOfferSuppVoiceCall
     * @param string $cucmVersionInSipHeader
     * @param string $confidentialAccessLevelHeaders
     * @param string $destRouteString
     * @param string $inactiveSDPRequired
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $defaultTelephonyEventPayloadType = null, $redirectByApplication = null, $ringing180 = null, $timerInvite = null, $timerRegisterDelta = null, $timerRegister = null, $timerT1 = null, $timerT2 = null, $retryInvite = null, $retryNotInvite = null, $startMediaPort = null, $stopMediaPort = null, $callpickupListUri = null, $callpickupGroupUri = null, $meetmeServiceUrl = null, $userInfo = null, $dtmfDbLevel = null, $callHoldRingback = null, $anonymousCallBlock = null, $callerIdBlock = null, $dndControl = null, $telnetLevel = null, $timerKeepAlive = null, $timerSubscribe = null, $timerSubscribeDelta = null, $maxRedirects = null, $timerOffHookToFirstDigit = null, $callForwardUri = null, $abbreviatedDialUri = null, $confJointEnable = null, $rfc2543Hold = null, $semiAttendedTransfer = null, $enableVad = null, $stutterMsgWaiting = null, $callStats = null, $t38Invite = null, $rerouteIncomingRequest = null, \StructType\XFkType $resourcePriorityNamespaceListName = null, $enableAnatForEarlyOfferCalls = null, $rsvpOverSip = null, $fallbackToLocalRsvp = null, $sipRe11XxEnabled = null, $gClear = null, $sendRecvSDPInMidCallInvite = null, $enableOutboundOptionsPing = null, $optionsPingIntervalWhenStatusOK = null, $optionsPingIntervalWhenStatusNotOK = null, $deliverConferenceBridgeIdentifier = null, $sipOptionsRetryCount = null, $sipOptionsRetryTimer = null, $sipBandwidthModifier = null, $enableUriOutdialSupport = null, $userAgentServerHeaderInfo = null, $allowPresentationSharingUsingBfcp = null, $scriptParameters = null, $isScriptTraceEnabled = null, \StructType\XFkType $sipNormalizationScript = null, $allowiXApplicationMedia = null, $dialStringInterpretation = null, $acceptAudioCodecPreferences = null, $mlppUserAuthorization = null, $isAssuredSipServiceEnabled = null, \StructType\XFkType $resourcePriorityNamespace = null, $useCallerIdCallerNameinUriOutgoingRequest = null, $callerIdDn = null, $callerName = null, $callingLineIdentification = null, $rejectAnonymousIncomingCall = null, $callpickupUri = null, $rejectAnonymousOutgoingCall = null, $videoCallTrafficClass = null, \StructType\XFkType $sdpTransparency = null, $allowMultipleCodecs = null, $sipSessionRefreshMethod = null, $earlyOfferSuppVoiceCall = null, $cucmVersionInSipHeader = null, $confidentialAccessLevelHeaders = null, $destRouteString = null, $inactiveSDPRequired = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDefaultTelephonyEventPayloadType($defaultTelephonyEventPayloadType)
            ->setRedirectByApplication($redirectByApplication)
            ->setRinging180($ringing180)
            ->setTimerInvite($timerInvite)
            ->setTimerRegisterDelta($timerRegisterDelta)
            ->setTimerRegister($timerRegister)
            ->setTimerT1($timerT1)
            ->setTimerT2($timerT2)
            ->setRetryInvite($retryInvite)
            ->setRetryNotInvite($retryNotInvite)
            ->setStartMediaPort($startMediaPort)
            ->setStopMediaPort($stopMediaPort)
            ->setCallpickupListUri($callpickupListUri)
            ->setCallpickupGroupUri($callpickupGroupUri)
            ->setMeetmeServiceUrl($meetmeServiceUrl)
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setTimerKeepAlive($timerKeepAlive)
            ->setTimerSubscribe($timerSubscribe)
            ->setTimerSubscribeDelta($timerSubscribeDelta)
            ->setMaxRedirects($maxRedirects)
            ->setTimerOffHookToFirstDigit($timerOffHookToFirstDigit)
            ->setCallForwardUri($callForwardUri)
            ->setAbbreviatedDialUri($abbreviatedDialUri)
            ->setConfJointEnable($confJointEnable)
            ->setRfc2543Hold($rfc2543Hold)
            ->setSemiAttendedTransfer($semiAttendedTransfer)
            ->setEnableVad($enableVad)
            ->setStutterMsgWaiting($stutterMsgWaiting)
            ->setCallStats($callStats)
            ->setT38Invite($t38Invite)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setEnableAnatForEarlyOfferCalls($enableAnatForEarlyOfferCalls)
            ->setRsvpOverSip($rsvpOverSip)
            ->setFallbackToLocalRsvp($fallbackToLocalRsvp)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setSendRecvSDPInMidCallInvite($sendRecvSDPInMidCallInvite)
            ->setEnableOutboundOptionsPing($enableOutboundOptionsPing)
            ->setOptionsPingIntervalWhenStatusOK($optionsPingIntervalWhenStatusOK)
            ->setOptionsPingIntervalWhenStatusNotOK($optionsPingIntervalWhenStatusNotOK)
            ->setDeliverConferenceBridgeIdentifier($deliverConferenceBridgeIdentifier)
            ->setSipOptionsRetryCount($sipOptionsRetryCount)
            ->setSipOptionsRetryTimer($sipOptionsRetryTimer)
            ->setSipBandwidthModifier($sipBandwidthModifier)
            ->setEnableUriOutdialSupport($enableUriOutdialSupport)
            ->setUserAgentServerHeaderInfo($userAgentServerHeaderInfo)
            ->setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp)
            ->setScriptParameters($scriptParameters)
            ->setIsScriptTraceEnabled($isScriptTraceEnabled)
            ->setSipNormalizationScript($sipNormalizationScript)
            ->setAllowiXApplicationMedia($allowiXApplicationMedia)
            ->setDialStringInterpretation($dialStringInterpretation)
            ->setAcceptAudioCodecPreferences($acceptAudioCodecPreferences)
            ->setMlppUserAuthorization($mlppUserAuthorization)
            ->setIsAssuredSipServiceEnabled($isAssuredSipServiceEnabled)
            ->setResourcePriorityNamespace($resourcePriorityNamespace)
            ->setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest)
            ->setCallerIdDn($callerIdDn)
            ->setCallerName($callerName)
            ->setCallingLineIdentification($callingLineIdentification)
            ->setRejectAnonymousIncomingCall($rejectAnonymousIncomingCall)
            ->setCallpickupUri($callpickupUri)
            ->setRejectAnonymousOutgoingCall($rejectAnonymousOutgoingCall)
            ->setVideoCallTrafficClass($videoCallTrafficClass)
            ->setSdpTransparency($sdpTransparency)
            ->setAllowMultipleCodecs($allowMultipleCodecs)
            ->setSipSessionRefreshMethod($sipSessionRefreshMethod)
            ->setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall)
            ->setCucmVersionInSipHeader($cucmVersionInSipHeader)
            ->setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders)
            ->setDestRouteString($destRouteString)
            ->setInactiveSDPRequired($inactiveSDPRequired)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LSipProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LSipProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($description) && mb_strlen($description) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get defaultTelephonyEventPayloadType value
     * @return string|null
     */
    public function getDefaultTelephonyEventPayloadType()
    {
        return $this->defaultTelephonyEventPayloadType;
    }
    /**
     * Set defaultTelephonyEventPayloadType value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultTelephonyEventPayloadType
     * @return \StructType\LSipProfile
     */
    public function setDefaultTelephonyEventPayloadType($defaultTelephonyEventPayloadType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($defaultTelephonyEventPayloadType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($defaultTelephonyEventPayloadType) ? implode(', ', $defaultTelephonyEventPayloadType) : var_export($defaultTelephonyEventPayloadType, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->defaultTelephonyEventPayloadType = $defaultTelephonyEventPayloadType;
        return $this;
    }
    /**
     * Get redirectByApplication value
     * @return string|null
     */
    public function getRedirectByApplication()
    {
        return $this->redirectByApplication;
    }
    /**
     * Set redirectByApplication value
     * @param string $redirectByApplication
     * @return \StructType\LSipProfile
     */
    public function setRedirectByApplication($redirectByApplication = null)
    {
        // validation for constraint: string
        if (!is_null($redirectByApplication) && !is_string($redirectByApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectByApplication, true), gettype($redirectByApplication)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($redirectByApplication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectByApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($redirectByApplication, true)), __LINE__);
        }
        $this->redirectByApplication = $redirectByApplication;
        return $this;
    }
    /**
     * Get ringing180 value
     * @return string|null
     */
    public function getRinging180()
    {
        return $this->ringing180;
    }
    /**
     * Set ringing180 value
     * @param string $ringing180
     * @return \StructType\LSipProfile
     */
    public function setRinging180($ringing180 = null)
    {
        // validation for constraint: string
        if (!is_null($ringing180) && !is_string($ringing180)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ringing180, true), gettype($ringing180)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($ringing180) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ringing180)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($ringing180, true)), __LINE__);
        }
        $this->ringing180 = $ringing180;
        return $this;
    }
    /**
     * Get timerInvite value
     * @return string|null
     */
    public function getTimerInvite()
    {
        return $this->timerInvite;
    }
    /**
     * Set timerInvite value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerInvite
     * @return \StructType\LSipProfile
     */
    public function setTimerInvite($timerInvite = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timerInvite) ? implode(', ', $timerInvite) : var_export($timerInvite, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerInvite = $timerInvite;
        return $this;
    }
    /**
     * Get timerRegisterDelta value
     * @return string|null
     */
    public function getTimerRegisterDelta()
    {
        return $this->timerRegisterDelta;
    }
    /**
     * Set timerRegisterDelta value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerRegisterDelta
     * @return \StructType\LSipProfile
     */
    public function setTimerRegisterDelta($timerRegisterDelta = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerRegisterDelta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timerRegisterDelta) ? implode(', ', $timerRegisterDelta) : var_export($timerRegisterDelta, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerRegisterDelta = $timerRegisterDelta;
        return $this;
    }
    /**
     * Get timerRegister value
     * @return string|null
     */
    public function getTimerRegister()
    {
        return $this->timerRegister;
    }
    /**
     * Set timerRegister value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerRegister
     * @return \StructType\LSipProfile
     */
    public function setTimerRegister($timerRegister = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerRegister)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timerRegister) ? implode(', ', $timerRegister) : var_export($timerRegister, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerRegister = $timerRegister;
        return $this;
    }
    /**
     * Get timerT1 value
     * @return string|null
     */
    public function getTimerT1()
    {
        return $this->timerT1;
    }
    /**
     * Set timerT1 value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerT1
     * @return \StructType\LSipProfile
     */
    public function setTimerT1($timerT1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerT1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timerT1) ? implode(', ', $timerT1) : var_export($timerT1, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerT1 = $timerT1;
        return $this;
    }
    /**
     * Get timerT2 value
     * @return string|null
     */
    public function getTimerT2()
    {
        return $this->timerT2;
    }
    /**
     * Set timerT2 value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerT2
     * @return \StructType\LSipProfile
     */
    public function setTimerT2($timerT2 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerT2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timerT2) ? implode(', ', $timerT2) : var_export($timerT2, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerT2 = $timerT2;
        return $this;
    }
    /**
     * Get retryInvite value
     * @return string|null
     */
    public function getRetryInvite()
    {
        return $this->retryInvite;
    }
    /**
     * Set retryInvite value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryInvite
     * @return \StructType\LSipProfile
     */
    public function setRetryInvite($retryInvite = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($retryInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($retryInvite) ? implode(', ', $retryInvite) : var_export($retryInvite, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->retryInvite = $retryInvite;
        return $this;
    }
    /**
     * Get retryNotInvite value
     * @return string|null
     */
    public function getRetryNotInvite()
    {
        return $this->retryNotInvite;
    }
    /**
     * Set retryNotInvite value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryNotInvite
     * @return \StructType\LSipProfile
     */
    public function setRetryNotInvite($retryNotInvite = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($retryNotInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($retryNotInvite) ? implode(', ', $retryNotInvite) : var_export($retryNotInvite, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->retryNotInvite = $retryNotInvite;
        return $this;
    }
    /**
     * Get startMediaPort value
     * @return string|null
     */
    public function getStartMediaPort()
    {
        return $this->startMediaPort;
    }
    /**
     * Set startMediaPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startMediaPort
     * @return \StructType\LSipProfile
     */
    public function setStartMediaPort($startMediaPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($startMediaPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($startMediaPort) ? implode(', ', $startMediaPort) : var_export($startMediaPort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->startMediaPort = $startMediaPort;
        return $this;
    }
    /**
     * Get stopMediaPort value
     * @return string|null
     */
    public function getStopMediaPort()
    {
        return $this->stopMediaPort;
    }
    /**
     * Set stopMediaPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopMediaPort
     * @return \StructType\LSipProfile
     */
    public function setStopMediaPort($stopMediaPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($stopMediaPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($stopMediaPort) ? implode(', ', $stopMediaPort) : var_export($stopMediaPort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->stopMediaPort = $stopMediaPort;
        return $this;
    }
    /**
     * Get callpickupListUri value
     * @return string|null
     */
    public function getCallpickupListUri()
    {
        return $this->callpickupListUri;
    }
    /**
     * Set callpickupListUri value
     * @param string $callpickupListUri
     * @return \StructType\LSipProfile
     */
    public function setCallpickupListUri($callpickupListUri = null)
    {
        // validation for constraint: string
        if (!is_null($callpickupListUri) && !is_string($callpickupListUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callpickupListUri, true), gettype($callpickupListUri)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($callpickupListUri) && mb_strlen($callpickupListUri) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($callpickupListUri)), __LINE__);
        }
        $this->callpickupListUri = $callpickupListUri;
        return $this;
    }
    /**
     * Get callpickupGroupUri value
     * @return string|null
     */
    public function getCallpickupGroupUri()
    {
        return $this->callpickupGroupUri;
    }
    /**
     * Set callpickupGroupUri value
     * @param string $callpickupGroupUri
     * @return \StructType\LSipProfile
     */
    public function setCallpickupGroupUri($callpickupGroupUri = null)
    {
        // validation for constraint: string
        if (!is_null($callpickupGroupUri) && !is_string($callpickupGroupUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callpickupGroupUri, true), gettype($callpickupGroupUri)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($callpickupGroupUri) && mb_strlen($callpickupGroupUri) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($callpickupGroupUri)), __LINE__);
        }
        $this->callpickupGroupUri = $callpickupGroupUri;
        return $this;
    }
    /**
     * Get meetmeServiceUrl value
     * @return string|null
     */
    public function getMeetmeServiceUrl()
    {
        return $this->meetmeServiceUrl;
    }
    /**
     * Set meetmeServiceUrl value
     * @param string $meetmeServiceUrl
     * @return \StructType\LSipProfile
     */
    public function setMeetmeServiceUrl($meetmeServiceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($meetmeServiceUrl) && !is_string($meetmeServiceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetmeServiceUrl, true), gettype($meetmeServiceUrl)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($meetmeServiceUrl) && mb_strlen($meetmeServiceUrl) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($meetmeServiceUrl)), __LINE__);
        }
        $this->meetmeServiceUrl = $meetmeServiceUrl;
        return $this;
    }
    /**
     * Get userInfo value
     * @return string|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @uses \EnumType\XZzuserInfo::valueIsValid()
     * @uses \EnumType\XZzuserInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userInfo
     * @return \StructType\LSipProfile
     */
    public function setUserInfo($userInfo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzuserInfo::valueIsValid($userInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XZzuserInfo', is_array($userInfo) ? implode(', ', $userInfo) : var_export($userInfo, true), implode(', ', \EnumType\XZzuserInfo::getValidValues())), __LINE__);
        }
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return string|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @uses \EnumType\XZzdtmfDbLevel::valueIsValid()
     * @uses \EnumType\XZzdtmfDbLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfDbLevel
     * @return \StructType\LSipProfile
     */
    public function setDtmfDbLevel($dtmfDbLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzdtmfDbLevel::valueIsValid($dtmfDbLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XZzdtmfDbLevel', is_array($dtmfDbLevel) ? implode(', ', $dtmfDbLevel) : var_export($dtmfDbLevel, true), implode(', ', \EnumType\XZzdtmfDbLevel::getValidValues())), __LINE__);
        }
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return string|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @uses \EnumType\XZzpreff::valueIsValid()
     * @uses \EnumType\XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callHoldRingback
     * @return \StructType\LSipProfile
     */
    public function setCallHoldRingback($callHoldRingback = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzpreff::valueIsValid($callHoldRingback)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XZzpreff', is_array($callHoldRingback) ? implode(', ', $callHoldRingback) : var_export($callHoldRingback, true), implode(', ', \EnumType\XZzpreff::getValidValues())), __LINE__);
        }
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return string|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @uses \EnumType\XZzpreff::valueIsValid()
     * @uses \EnumType\XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anonymousCallBlock
     * @return \StructType\LSipProfile
     */
    public function setAnonymousCallBlock($anonymousCallBlock = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzpreff::valueIsValid($anonymousCallBlock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XZzpreff', is_array($anonymousCallBlock) ? implode(', ', $anonymousCallBlock) : var_export($anonymousCallBlock, true), implode(', ', \EnumType\XZzpreff::getValidValues())), __LINE__);
        }
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return string|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @uses \EnumType\XZzpreff::valueIsValid()
     * @uses \EnumType\XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callerIdBlock
     * @return \StructType\LSipProfile
     */
    public function setCallerIdBlock($callerIdBlock = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzpreff::valueIsValid($callerIdBlock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XZzpreff', is_array($callerIdBlock) ? implode(', ', $callerIdBlock) : var_export($callerIdBlock, true), implode(', ', \EnumType\XZzpreff::getValidValues())), __LINE__);
        }
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return string|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @uses \EnumType\XZzdndcontrol::valueIsValid()
     * @uses \EnumType\XZzdndcontrol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndControl
     * @return \StructType\LSipProfile
     */
    public function setDndControl($dndControl = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzdndcontrol::valueIsValid($dndControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XZzdndcontrol', is_array($dndControl) ? implode(', ', $dndControl) : var_export($dndControl, true), implode(', ', \EnumType\XZzdndcontrol::getValidValues())), __LINE__);
        }
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return string|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @uses \EnumType\XTelnetLevel::valueIsValid()
     * @uses \EnumType\XTelnetLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $telnetLevel
     * @return \StructType\LSipProfile
     */
    public function setTelnetLevel($telnetLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTelnetLevel::valueIsValid($telnetLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTelnetLevel', is_array($telnetLevel) ? implode(', ', $telnetLevel) : var_export($telnetLevel, true), implode(', ', \EnumType\XTelnetLevel::getValidValues())), __LINE__);
        }
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get timerKeepAlive value
     * @return string|null
     */
    public function getTimerKeepAlive()
    {
        return $this->timerKeepAlive;
    }
    /**
     * Set timerKeepAlive value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerKeepAlive
     * @return \StructType\LSipProfile
     */
    public function setTimerKeepAlive($timerKeepAlive = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timerKeepAlive) ? implode(', ', $timerKeepAlive) : var_export($timerKeepAlive, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerKeepAlive = $timerKeepAlive;
        return $this;
    }
    /**
     * Get timerSubscribe value
     * @return string|null
     */
    public function getTimerSubscribe()
    {
        return $this->timerSubscribe;
    }
    /**
     * Set timerSubscribe value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerSubscribe
     * @return \StructType\LSipProfile
     */
    public function setTimerSubscribe($timerSubscribe = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerSubscribe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timerSubscribe) ? implode(', ', $timerSubscribe) : var_export($timerSubscribe, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerSubscribe = $timerSubscribe;
        return $this;
    }
    /**
     * Get timerSubscribeDelta value
     * @return string|null
     */
    public function getTimerSubscribeDelta()
    {
        return $this->timerSubscribeDelta;
    }
    /**
     * Set timerSubscribeDelta value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerSubscribeDelta
     * @return \StructType\LSipProfile
     */
    public function setTimerSubscribeDelta($timerSubscribeDelta = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerSubscribeDelta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timerSubscribeDelta) ? implode(', ', $timerSubscribeDelta) : var_export($timerSubscribeDelta, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerSubscribeDelta = $timerSubscribeDelta;
        return $this;
    }
    /**
     * Get maxRedirects value
     * @return string|null
     */
    public function getMaxRedirects()
    {
        return $this->maxRedirects;
    }
    /**
     * Set maxRedirects value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxRedirects
     * @return \StructType\LSipProfile
     */
    public function setMaxRedirects($maxRedirects = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxRedirects)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($maxRedirects) ? implode(', ', $maxRedirects) : var_export($maxRedirects, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxRedirects = $maxRedirects;
        return $this;
    }
    /**
     * Get timerOffHookToFirstDigit value
     * @return string|null
     */
    public function getTimerOffHookToFirstDigit()
    {
        return $this->timerOffHookToFirstDigit;
    }
    /**
     * Set timerOffHookToFirstDigit value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerOffHookToFirstDigit
     * @return \StructType\LSipProfile
     */
    public function setTimerOffHookToFirstDigit($timerOffHookToFirstDigit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerOffHookToFirstDigit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timerOffHookToFirstDigit) ? implode(', ', $timerOffHookToFirstDigit) : var_export($timerOffHookToFirstDigit, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerOffHookToFirstDigit = $timerOffHookToFirstDigit;
        return $this;
    }
    /**
     * Get callForwardUri value
     * @return string|null
     */
    public function getCallForwardUri()
    {
        return $this->callForwardUri;
    }
    /**
     * Set callForwardUri value
     * @param string $callForwardUri
     * @return \StructType\LSipProfile
     */
    public function setCallForwardUri($callForwardUri = null)
    {
        // validation for constraint: string
        if (!is_null($callForwardUri) && !is_string($callForwardUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callForwardUri, true), gettype($callForwardUri)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($callForwardUri) && mb_strlen($callForwardUri) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($callForwardUri)), __LINE__);
        }
        $this->callForwardUri = $callForwardUri;
        return $this;
    }
    /**
     * Get abbreviatedDialUri value
     * @return string|null
     */
    public function getAbbreviatedDialUri()
    {
        return $this->abbreviatedDialUri;
    }
    /**
     * Set abbreviatedDialUri value
     * @param string $abbreviatedDialUri
     * @return \StructType\LSipProfile
     */
    public function setAbbreviatedDialUri($abbreviatedDialUri = null)
    {
        // validation for constraint: string
        if (!is_null($abbreviatedDialUri) && !is_string($abbreviatedDialUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abbreviatedDialUri, true), gettype($abbreviatedDialUri)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($abbreviatedDialUri) && mb_strlen($abbreviatedDialUri) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($abbreviatedDialUri)), __LINE__);
        }
        $this->abbreviatedDialUri = $abbreviatedDialUri;
        return $this;
    }
    /**
     * Get confJointEnable value
     * @return string|null
     */
    public function getConfJointEnable()
    {
        return $this->confJointEnable;
    }
    /**
     * Set confJointEnable value
     * @param string $confJointEnable
     * @return \StructType\LSipProfile
     */
    public function setConfJointEnable($confJointEnable = null)
    {
        // validation for constraint: string
        if (!is_null($confJointEnable) && !is_string($confJointEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confJointEnable, true), gettype($confJointEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($confJointEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $confJointEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($confJointEnable, true)), __LINE__);
        }
        $this->confJointEnable = $confJointEnable;
        return $this;
    }
    /**
     * Get rfc2543Hold value
     * @return string|null
     */
    public function getRfc2543Hold()
    {
        return $this->rfc2543Hold;
    }
    /**
     * Set rfc2543Hold value
     * @param string $rfc2543Hold
     * @return \StructType\LSipProfile
     */
    public function setRfc2543Hold($rfc2543Hold = null)
    {
        // validation for constraint: string
        if (!is_null($rfc2543Hold) && !is_string($rfc2543Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfc2543Hold, true), gettype($rfc2543Hold)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($rfc2543Hold) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2543Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($rfc2543Hold, true)), __LINE__);
        }
        $this->rfc2543Hold = $rfc2543Hold;
        return $this;
    }
    /**
     * Get semiAttendedTransfer value
     * @return string|null
     */
    public function getSemiAttendedTransfer()
    {
        return $this->semiAttendedTransfer;
    }
    /**
     * Set semiAttendedTransfer value
     * @param string $semiAttendedTransfer
     * @return \StructType\LSipProfile
     */
    public function setSemiAttendedTransfer($semiAttendedTransfer = null)
    {
        // validation for constraint: string
        if (!is_null($semiAttendedTransfer) && !is_string($semiAttendedTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($semiAttendedTransfer, true), gettype($semiAttendedTransfer)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($semiAttendedTransfer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $semiAttendedTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($semiAttendedTransfer, true)), __LINE__);
        }
        $this->semiAttendedTransfer = $semiAttendedTransfer;
        return $this;
    }
    /**
     * Get enableVad value
     * @return string|null
     */
    public function getEnableVad()
    {
        return $this->enableVad;
    }
    /**
     * Set enableVad value
     * @param string $enableVad
     * @return \StructType\LSipProfile
     */
    public function setEnableVad($enableVad = null)
    {
        // validation for constraint: string
        if (!is_null($enableVad) && !is_string($enableVad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableVad, true), gettype($enableVad)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableVad) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableVad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableVad, true)), __LINE__);
        }
        $this->enableVad = $enableVad;
        return $this;
    }
    /**
     * Get stutterMsgWaiting value
     * @return string|null
     */
    public function getStutterMsgWaiting()
    {
        return $this->stutterMsgWaiting;
    }
    /**
     * Set stutterMsgWaiting value
     * @param string $stutterMsgWaiting
     * @return \StructType\LSipProfile
     */
    public function setStutterMsgWaiting($stutterMsgWaiting = null)
    {
        // validation for constraint: string
        if (!is_null($stutterMsgWaiting) && !is_string($stutterMsgWaiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stutterMsgWaiting, true), gettype($stutterMsgWaiting)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($stutterMsgWaiting) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $stutterMsgWaiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($stutterMsgWaiting, true)), __LINE__);
        }
        $this->stutterMsgWaiting = $stutterMsgWaiting;
        return $this;
    }
    /**
     * Get callStats value
     * @return string|null
     */
    public function getCallStats()
    {
        return $this->callStats;
    }
    /**
     * Set callStats value
     * @param string $callStats
     * @return \StructType\LSipProfile
     */
    public function setCallStats($callStats = null)
    {
        // validation for constraint: string
        if (!is_null($callStats) && !is_string($callStats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callStats, true), gettype($callStats)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($callStats) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callStats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($callStats, true)), __LINE__);
        }
        $this->callStats = $callStats;
        return $this;
    }
    /**
     * Get t38Invite value
     * @return string|null
     */
    public function getT38Invite()
    {
        return $this->t38Invite;
    }
    /**
     * Set t38Invite value
     * @param string $t38Invite
     * @return \StructType\LSipProfile
     */
    public function setT38Invite($t38Invite = null)
    {
        // validation for constraint: string
        if (!is_null($t38Invite) && !is_string($t38Invite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($t38Invite, true), gettype($t38Invite)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($t38Invite) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $t38Invite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($t38Invite, true)), __LINE__);
        }
        $this->t38Invite = $t38Invite;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return string|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @uses \EnumType\XSIPReroute::valueIsValid()
     * @uses \EnumType\XSIPReroute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rerouteIncomingRequest
     * @return \StructType\LSipProfile
     */
    public function setRerouteIncomingRequest($rerouteIncomingRequest = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPReroute::valueIsValid($rerouteIncomingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XSIPReroute', is_array($rerouteIncomingRequest) ? implode(', ', $rerouteIncomingRequest) : var_export($rerouteIncomingRequest, true), implode(', ', \EnumType\XSIPReroute::getValidValues())), __LINE__);
        }
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * @return \StructType\XFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return $this->resourcePriorityNamespaceListName;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * @param \StructType\XFkType $resourcePriorityNamespaceListName
     * @return \StructType\LSipProfile
     */
    public function setResourcePriorityNamespaceListName(\StructType\XFkType $resourcePriorityNamespaceListName = null)
    {
        $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        return $this;
    }
    /**
     * Get enableAnatForEarlyOfferCalls value
     * @return string|null
     */
    public function getEnableAnatForEarlyOfferCalls()
    {
        return $this->enableAnatForEarlyOfferCalls;
    }
    /**
     * Set enableAnatForEarlyOfferCalls value
     * @param string $enableAnatForEarlyOfferCalls
     * @return \StructType\LSipProfile
     */
    public function setEnableAnatForEarlyOfferCalls($enableAnatForEarlyOfferCalls = null)
    {
        // validation for constraint: string
        if (!is_null($enableAnatForEarlyOfferCalls) && !is_string($enableAnatForEarlyOfferCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableAnatForEarlyOfferCalls, true), gettype($enableAnatForEarlyOfferCalls)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableAnatForEarlyOfferCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableAnatForEarlyOfferCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableAnatForEarlyOfferCalls, true)), __LINE__);
        }
        $this->enableAnatForEarlyOfferCalls = $enableAnatForEarlyOfferCalls;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return string|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @uses \EnumType\XRSVPOverSIP::valueIsValid()
     * @uses \EnumType\XRSVPOverSIP::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rsvpOverSip
     * @return \StructType\LSipProfile
     */
    public function setRsvpOverSip($rsvpOverSip = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRSVPOverSIP::valueIsValid($rsvpOverSip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRSVPOverSIP', is_array($rsvpOverSip) ? implode(', ', $rsvpOverSip) : var_export($rsvpOverSip, true), implode(', ', \EnumType\XRSVPOverSIP::getValidValues())), __LINE__);
        }
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get fallbackToLocalRsvp value
     * @return string|null
     */
    public function getFallbackToLocalRsvp()
    {
        return $this->fallbackToLocalRsvp;
    }
    /**
     * Set fallbackToLocalRsvp value
     * @param string $fallbackToLocalRsvp
     * @return \StructType\LSipProfile
     */
    public function setFallbackToLocalRsvp($fallbackToLocalRsvp = null)
    {
        // validation for constraint: string
        if (!is_null($fallbackToLocalRsvp) && !is_string($fallbackToLocalRsvp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fallbackToLocalRsvp, true), gettype($fallbackToLocalRsvp)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($fallbackToLocalRsvp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $fallbackToLocalRsvp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($fallbackToLocalRsvp, true)), __LINE__);
        }
        $this->fallbackToLocalRsvp = $fallbackToLocalRsvp;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return string|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @uses \EnumType\XSIPRel1XXOptions::valueIsValid()
     * @uses \EnumType\XSIPRel1XXOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipRe11XxEnabled
     * @return \StructType\LSipProfile
     */
    public function setSipRe11XxEnabled($sipRe11XxEnabled = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPRel1XXOptions::valueIsValid($sipRe11XxEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XSIPRel1XXOptions', is_array($sipRe11XxEnabled) ? implode(', ', $sipRe11XxEnabled) : var_export($sipRe11XxEnabled, true), implode(', ', \EnumType\XSIPRel1XXOptions::getValidValues())), __LINE__);
        }
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return string|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @uses \EnumType\XGClear::valueIsValid()
     * @uses \EnumType\XGClear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gClear
     * @return \StructType\LSipProfile
     */
    public function setGClear($gClear = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XGClear::valueIsValid($gClear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XGClear', is_array($gClear) ? implode(', ', $gClear) : var_export($gClear, true), implode(', ', \EnumType\XGClear::getValidValues())), __LINE__);
        }
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get sendRecvSDPInMidCallInvite value
     * @return string|null
     */
    public function getSendRecvSDPInMidCallInvite()
    {
        return $this->sendRecvSDPInMidCallInvite;
    }
    /**
     * Set sendRecvSDPInMidCallInvite value
     * @param string $sendRecvSDPInMidCallInvite
     * @return \StructType\LSipProfile
     */
    public function setSendRecvSDPInMidCallInvite($sendRecvSDPInMidCallInvite = null)
    {
        // validation for constraint: string
        if (!is_null($sendRecvSDPInMidCallInvite) && !is_string($sendRecvSDPInMidCallInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendRecvSDPInMidCallInvite, true), gettype($sendRecvSDPInMidCallInvite)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($sendRecvSDPInMidCallInvite) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendRecvSDPInMidCallInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($sendRecvSDPInMidCallInvite, true)), __LINE__);
        }
        $this->sendRecvSDPInMidCallInvite = $sendRecvSDPInMidCallInvite;
        return $this;
    }
    /**
     * Get enableOutboundOptionsPing value
     * @return string|null
     */
    public function getEnableOutboundOptionsPing()
    {
        return $this->enableOutboundOptionsPing;
    }
    /**
     * Set enableOutboundOptionsPing value
     * @param string $enableOutboundOptionsPing
     * @return \StructType\LSipProfile
     */
    public function setEnableOutboundOptionsPing($enableOutboundOptionsPing = null)
    {
        // validation for constraint: string
        if (!is_null($enableOutboundOptionsPing) && !is_string($enableOutboundOptionsPing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableOutboundOptionsPing, true), gettype($enableOutboundOptionsPing)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableOutboundOptionsPing) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableOutboundOptionsPing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableOutboundOptionsPing, true)), __LINE__);
        }
        $this->enableOutboundOptionsPing = $enableOutboundOptionsPing;
        return $this;
    }
    /**
     * Get optionsPingIntervalWhenStatusOK value
     * @return string|null
     */
    public function getOptionsPingIntervalWhenStatusOK()
    {
        return $this->optionsPingIntervalWhenStatusOK;
    }
    /**
     * Set optionsPingIntervalWhenStatusOK value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optionsPingIntervalWhenStatusOK
     * @return \StructType\LSipProfile
     */
    public function setOptionsPingIntervalWhenStatusOK($optionsPingIntervalWhenStatusOK = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($optionsPingIntervalWhenStatusOK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($optionsPingIntervalWhenStatusOK) ? implode(', ', $optionsPingIntervalWhenStatusOK) : var_export($optionsPingIntervalWhenStatusOK, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->optionsPingIntervalWhenStatusOK = $optionsPingIntervalWhenStatusOK;
        return $this;
    }
    /**
     * Get optionsPingIntervalWhenStatusNotOK value
     * @return string|null
     */
    public function getOptionsPingIntervalWhenStatusNotOK()
    {
        return $this->optionsPingIntervalWhenStatusNotOK;
    }
    /**
     * Set optionsPingIntervalWhenStatusNotOK value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optionsPingIntervalWhenStatusNotOK
     * @return \StructType\LSipProfile
     */
    public function setOptionsPingIntervalWhenStatusNotOK($optionsPingIntervalWhenStatusNotOK = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($optionsPingIntervalWhenStatusNotOK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($optionsPingIntervalWhenStatusNotOK) ? implode(', ', $optionsPingIntervalWhenStatusNotOK) : var_export($optionsPingIntervalWhenStatusNotOK, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->optionsPingIntervalWhenStatusNotOK = $optionsPingIntervalWhenStatusNotOK;
        return $this;
    }
    /**
     * Get deliverConferenceBridgeIdentifier value
     * @return string|null
     */
    public function getDeliverConferenceBridgeIdentifier()
    {
        return $this->deliverConferenceBridgeIdentifier;
    }
    /**
     * Set deliverConferenceBridgeIdentifier value
     * @param string $deliverConferenceBridgeIdentifier
     * @return \StructType\LSipProfile
     */
    public function setDeliverConferenceBridgeIdentifier($deliverConferenceBridgeIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($deliverConferenceBridgeIdentifier) && !is_string($deliverConferenceBridgeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverConferenceBridgeIdentifier, true), gettype($deliverConferenceBridgeIdentifier)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($deliverConferenceBridgeIdentifier) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $deliverConferenceBridgeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($deliverConferenceBridgeIdentifier, true)), __LINE__);
        }
        $this->deliverConferenceBridgeIdentifier = $deliverConferenceBridgeIdentifier;
        return $this;
    }
    /**
     * Get sipOptionsRetryCount value
     * @return string|null
     */
    public function getSipOptionsRetryCount()
    {
        return $this->sipOptionsRetryCount;
    }
    /**
     * Set sipOptionsRetryCount value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipOptionsRetryCount
     * @return \StructType\LSipProfile
     */
    public function setSipOptionsRetryCount($sipOptionsRetryCount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sipOptionsRetryCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($sipOptionsRetryCount) ? implode(', ', $sipOptionsRetryCount) : var_export($sipOptionsRetryCount, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipOptionsRetryCount = $sipOptionsRetryCount;
        return $this;
    }
    /**
     * Get sipOptionsRetryTimer value
     * @return string|null
     */
    public function getSipOptionsRetryTimer()
    {
        return $this->sipOptionsRetryTimer;
    }
    /**
     * Set sipOptionsRetryTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipOptionsRetryTimer
     * @return \StructType\LSipProfile
     */
    public function setSipOptionsRetryTimer($sipOptionsRetryTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sipOptionsRetryTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($sipOptionsRetryTimer) ? implode(', ', $sipOptionsRetryTimer) : var_export($sipOptionsRetryTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipOptionsRetryTimer = $sipOptionsRetryTimer;
        return $this;
    }
    /**
     * Get sipBandwidthModifier value
     * @return string|null
     */
    public function getSipBandwidthModifier()
    {
        return $this->sipBandwidthModifier;
    }
    /**
     * Set sipBandwidthModifier value
     * @uses \EnumType\XSIPBandwidthModifier::valueIsValid()
     * @uses \EnumType\XSIPBandwidthModifier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipBandwidthModifier
     * @return \StructType\LSipProfile
     */
    public function setSipBandwidthModifier($sipBandwidthModifier = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPBandwidthModifier::valueIsValid($sipBandwidthModifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XSIPBandwidthModifier', is_array($sipBandwidthModifier) ? implode(', ', $sipBandwidthModifier) : var_export($sipBandwidthModifier, true), implode(', ', \EnumType\XSIPBandwidthModifier::getValidValues())), __LINE__);
        }
        $this->sipBandwidthModifier = $sipBandwidthModifier;
        return $this;
    }
    /**
     * Get enableUriOutdialSupport value
     * @return string|null
     */
    public function getEnableUriOutdialSupport()
    {
        return $this->enableUriOutdialSupport;
    }
    /**
     * Set enableUriOutdialSupport value
     * @param string $enableUriOutdialSupport
     * @return \StructType\LSipProfile
     */
    public function setEnableUriOutdialSupport($enableUriOutdialSupport = null)
    {
        // validation for constraint: string
        if (!is_null($enableUriOutdialSupport) && !is_string($enableUriOutdialSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableUriOutdialSupport, true), gettype($enableUriOutdialSupport)), __LINE__);
        }
        $this->enableUriOutdialSupport = $enableUriOutdialSupport;
        return $this;
    }
    /**
     * Get userAgentServerHeaderInfo value
     * @return string|null
     */
    public function getUserAgentServerHeaderInfo()
    {
        return $this->userAgentServerHeaderInfo;
    }
    /**
     * Set userAgentServerHeaderInfo value
     * @uses \EnumType\XUserAgentServerHeaderInfo::valueIsValid()
     * @uses \EnumType\XUserAgentServerHeaderInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userAgentServerHeaderInfo
     * @return \StructType\LSipProfile
     */
    public function setUserAgentServerHeaderInfo($userAgentServerHeaderInfo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUserAgentServerHeaderInfo::valueIsValid($userAgentServerHeaderInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XUserAgentServerHeaderInfo', is_array($userAgentServerHeaderInfo) ? implode(', ', $userAgentServerHeaderInfo) : var_export($userAgentServerHeaderInfo, true), implode(', ', \EnumType\XUserAgentServerHeaderInfo::getValidValues())), __LINE__);
        }
        $this->userAgentServerHeaderInfo = $userAgentServerHeaderInfo;
        return $this;
    }
    /**
     * Get allowPresentationSharingUsingBfcp value
     * @return string|null
     */
    public function getAllowPresentationSharingUsingBfcp()
    {
        return $this->allowPresentationSharingUsingBfcp;
    }
    /**
     * Set allowPresentationSharingUsingBfcp value
     * @param string $allowPresentationSharingUsingBfcp
     * @return \StructType\LSipProfile
     */
    public function setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp = null)
    {
        // validation for constraint: string
        if (!is_null($allowPresentationSharingUsingBfcp) && !is_string($allowPresentationSharingUsingBfcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowPresentationSharingUsingBfcp, true), gettype($allowPresentationSharingUsingBfcp)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowPresentationSharingUsingBfcp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowPresentationSharingUsingBfcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowPresentationSharingUsingBfcp, true)), __LINE__);
        }
        $this->allowPresentationSharingUsingBfcp = $allowPresentationSharingUsingBfcp;
        return $this;
    }
    /**
     * Get scriptParameters value
     * @return string|null
     */
    public function getScriptParameters()
    {
        return $this->scriptParameters;
    }
    /**
     * Set scriptParameters value
     * @param string $scriptParameters
     * @return \StructType\LSipProfile
     */
    public function setScriptParameters($scriptParameters = null)
    {
        // validation for constraint: string
        if (!is_null($scriptParameters) && !is_string($scriptParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptParameters, true), gettype($scriptParameters)), __LINE__);
        }
        $this->scriptParameters = $scriptParameters;
        return $this;
    }
    /**
     * Get isScriptTraceEnabled value
     * @return string|null
     */
    public function getIsScriptTraceEnabled()
    {
        return $this->isScriptTraceEnabled;
    }
    /**
     * Set isScriptTraceEnabled value
     * @param string $isScriptTraceEnabled
     * @return \StructType\LSipProfile
     */
    public function setIsScriptTraceEnabled($isScriptTraceEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($isScriptTraceEnabled) && !is_string($isScriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isScriptTraceEnabled, true), gettype($isScriptTraceEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isScriptTraceEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isScriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isScriptTraceEnabled, true)), __LINE__);
        }
        $this->isScriptTraceEnabled = $isScriptTraceEnabled;
        return $this;
    }
    /**
     * Get sipNormalizationScript value
     * @return \StructType\XFkType|null
     */
    public function getSipNormalizationScript()
    {
        return $this->sipNormalizationScript;
    }
    /**
     * Set sipNormalizationScript value
     * @param \StructType\XFkType $sipNormalizationScript
     * @return \StructType\LSipProfile
     */
    public function setSipNormalizationScript(\StructType\XFkType $sipNormalizationScript = null)
    {
        $this->sipNormalizationScript = $sipNormalizationScript;
        return $this;
    }
    /**
     * Get allowiXApplicationMedia value
     * @return string|null
     */
    public function getAllowiXApplicationMedia()
    {
        return $this->allowiXApplicationMedia;
    }
    /**
     * Set allowiXApplicationMedia value
     * @param string $allowiXApplicationMedia
     * @return \StructType\LSipProfile
     */
    public function setAllowiXApplicationMedia($allowiXApplicationMedia = null)
    {
        // validation for constraint: string
        if (!is_null($allowiXApplicationMedia) && !is_string($allowiXApplicationMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowiXApplicationMedia, true), gettype($allowiXApplicationMedia)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowiXApplicationMedia) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowiXApplicationMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowiXApplicationMedia, true)), __LINE__);
        }
        $this->allowiXApplicationMedia = $allowiXApplicationMedia;
        return $this;
    }
    /**
     * Get dialStringInterpretation value
     * @return string|null
     */
    public function getDialStringInterpretation()
    {
        return $this->dialStringInterpretation;
    }
    /**
     * Set dialStringInterpretation value
     * @uses \EnumType\XURIDisambiguationPolicy::valueIsValid()
     * @uses \EnumType\XURIDisambiguationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialStringInterpretation
     * @return \StructType\LSipProfile
     */
    public function setDialStringInterpretation($dialStringInterpretation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XURIDisambiguationPolicy::valueIsValid($dialStringInterpretation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XURIDisambiguationPolicy', is_array($dialStringInterpretation) ? implode(', ', $dialStringInterpretation) : var_export($dialStringInterpretation, true), implode(', ', \EnumType\XURIDisambiguationPolicy::getValidValues())), __LINE__);
        }
        $this->dialStringInterpretation = $dialStringInterpretation;
        return $this;
    }
    /**
     * Get acceptAudioCodecPreferences value
     * @return string|null
     */
    public function getAcceptAudioCodecPreferences()
    {
        return $this->acceptAudioCodecPreferences;
    }
    /**
     * Set acceptAudioCodecPreferences value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acceptAudioCodecPreferences
     * @return \StructType\LSipProfile
     */
    public function setAcceptAudioCodecPreferences($acceptAudioCodecPreferences = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($acceptAudioCodecPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($acceptAudioCodecPreferences) ? implode(', ', $acceptAudioCodecPreferences) : var_export($acceptAudioCodecPreferences, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->acceptAudioCodecPreferences = $acceptAudioCodecPreferences;
        return $this;
    }
    /**
     * Get mlppUserAuthorization value
     * @return string|null
     */
    public function getMlppUserAuthorization()
    {
        return $this->mlppUserAuthorization;
    }
    /**
     * Set mlppUserAuthorization value
     * @param string $mlppUserAuthorization
     * @return \StructType\LSipProfile
     */
    public function setMlppUserAuthorization($mlppUserAuthorization = null)
    {
        // validation for constraint: string
        if (!is_null($mlppUserAuthorization) && !is_string($mlppUserAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mlppUserAuthorization, true), gettype($mlppUserAuthorization)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($mlppUserAuthorization) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mlppUserAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($mlppUserAuthorization, true)), __LINE__);
        }
        $this->mlppUserAuthorization = $mlppUserAuthorization;
        return $this;
    }
    /**
     * Get isAssuredSipServiceEnabled value
     * @return string|null
     */
    public function getIsAssuredSipServiceEnabled()
    {
        return $this->isAssuredSipServiceEnabled;
    }
    /**
     * Set isAssuredSipServiceEnabled value
     * @param string $isAssuredSipServiceEnabled
     * @return \StructType\LSipProfile
     */
    public function setIsAssuredSipServiceEnabled($isAssuredSipServiceEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($isAssuredSipServiceEnabled) && !is_string($isAssuredSipServiceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isAssuredSipServiceEnabled, true), gettype($isAssuredSipServiceEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isAssuredSipServiceEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isAssuredSipServiceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isAssuredSipServiceEnabled, true)), __LINE__);
        }
        $this->isAssuredSipServiceEnabled = $isAssuredSipServiceEnabled;
        return $this;
    }
    /**
     * Get resourcePriorityNamespace value
     * @return \StructType\XFkType|null
     */
    public function getResourcePriorityNamespace()
    {
        return $this->resourcePriorityNamespace;
    }
    /**
     * Set resourcePriorityNamespace value
     * @param \StructType\XFkType $resourcePriorityNamespace
     * @return \StructType\LSipProfile
     */
    public function setResourcePriorityNamespace(\StructType\XFkType $resourcePriorityNamespace = null)
    {
        $this->resourcePriorityNamespace = $resourcePriorityNamespace;
        return $this;
    }
    /**
     * Get useCallerIdCallerNameinUriOutgoingRequest value
     * @return string|null
     */
    public function getUseCallerIdCallerNameinUriOutgoingRequest()
    {
        return $this->useCallerIdCallerNameinUriOutgoingRequest;
    }
    /**
     * Set useCallerIdCallerNameinUriOutgoingRequest value
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @return \StructType\LSipProfile
     */
    public function setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest = null)
    {
        // validation for constraint: string
        if (!is_null($useCallerIdCallerNameinUriOutgoingRequest) && !is_string($useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useCallerIdCallerNameinUriOutgoingRequest, true), gettype($useCallerIdCallerNameinUriOutgoingRequest)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useCallerIdCallerNameinUriOutgoingRequest) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useCallerIdCallerNameinUriOutgoingRequest, true)), __LINE__);
        }
        $this->useCallerIdCallerNameinUriOutgoingRequest = $useCallerIdCallerNameinUriOutgoingRequest;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \StructType\LSipProfile
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDn, true), gettype($callerIdDn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callerIdDn) && mb_strlen($callerIdDn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callerIdDn)), __LINE__);
        }
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->callerName;
    }
    /**
     * Set callerName value
     * @param string $callerName
     * @return \StructType\LSipProfile
     */
    public function setCallerName($callerName = null)
    {
        // validation for constraint: string
        if (!is_null($callerName) && !is_string($callerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerName, true), gettype($callerName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callerName) && mb_strlen($callerName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callerName)), __LINE__);
        }
        $this->callerName = $callerName;
        return $this;
    }
    /**
     * Get callingLineIdentification value
     * @return string|null
     */
    public function getCallingLineIdentification()
    {
        return $this->callingLineIdentification;
    }
    /**
     * Set callingLineIdentification value
     * @uses \EnumType\XCallingLineIdentification::valueIsValid()
     * @uses \EnumType\XCallingLineIdentification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdentification
     * @return \StructType\LSipProfile
     */
    public function setCallingLineIdentification($callingLineIdentification = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCallingLineIdentification::valueIsValid($callingLineIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCallingLineIdentification', is_array($callingLineIdentification) ? implode(', ', $callingLineIdentification) : var_export($callingLineIdentification, true), implode(', ', \EnumType\XCallingLineIdentification::getValidValues())), __LINE__);
        }
        $this->callingLineIdentification = $callingLineIdentification;
        return $this;
    }
    /**
     * Get rejectAnonymousIncomingCall value
     * @return string|null
     */
    public function getRejectAnonymousIncomingCall()
    {
        return $this->rejectAnonymousIncomingCall;
    }
    /**
     * Set rejectAnonymousIncomingCall value
     * @param string $rejectAnonymousIncomingCall
     * @return \StructType\LSipProfile
     */
    public function setRejectAnonymousIncomingCall($rejectAnonymousIncomingCall = null)
    {
        // validation for constraint: string
        if (!is_null($rejectAnonymousIncomingCall) && !is_string($rejectAnonymousIncomingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectAnonymousIncomingCall, true), gettype($rejectAnonymousIncomingCall)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($rejectAnonymousIncomingCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rejectAnonymousIncomingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($rejectAnonymousIncomingCall, true)), __LINE__);
        }
        $this->rejectAnonymousIncomingCall = $rejectAnonymousIncomingCall;
        return $this;
    }
    /**
     * Get callpickupUri value
     * @return string|null
     */
    public function getCallpickupUri()
    {
        return $this->callpickupUri;
    }
    /**
     * Set callpickupUri value
     * @param string $callpickupUri
     * @return \StructType\LSipProfile
     */
    public function setCallpickupUri($callpickupUri = null)
    {
        // validation for constraint: string
        if (!is_null($callpickupUri) && !is_string($callpickupUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callpickupUri, true), gettype($callpickupUri)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($callpickupUri) && mb_strlen($callpickupUri) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($callpickupUri)), __LINE__);
        }
        $this->callpickupUri = $callpickupUri;
        return $this;
    }
    /**
     * Get rejectAnonymousOutgoingCall value
     * @return string|null
     */
    public function getRejectAnonymousOutgoingCall()
    {
        return $this->rejectAnonymousOutgoingCall;
    }
    /**
     * Set rejectAnonymousOutgoingCall value
     * @param string $rejectAnonymousOutgoingCall
     * @return \StructType\LSipProfile
     */
    public function setRejectAnonymousOutgoingCall($rejectAnonymousOutgoingCall = null)
    {
        // validation for constraint: string
        if (!is_null($rejectAnonymousOutgoingCall) && !is_string($rejectAnonymousOutgoingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectAnonymousOutgoingCall, true), gettype($rejectAnonymousOutgoingCall)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($rejectAnonymousOutgoingCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rejectAnonymousOutgoingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($rejectAnonymousOutgoingCall, true)), __LINE__);
        }
        $this->rejectAnonymousOutgoingCall = $rejectAnonymousOutgoingCall;
        return $this;
    }
    /**
     * Get videoCallTrafficClass value
     * @return string|null
     */
    public function getVideoCallTrafficClass()
    {
        return $this->videoCallTrafficClass;
    }
    /**
     * Set videoCallTrafficClass value
     * @uses \EnumType\XVideoCallTrafficClass::valueIsValid()
     * @uses \EnumType\XVideoCallTrafficClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoCallTrafficClass
     * @return \StructType\LSipProfile
     */
    public function setVideoCallTrafficClass($videoCallTrafficClass = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XVideoCallTrafficClass::valueIsValid($videoCallTrafficClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XVideoCallTrafficClass', is_array($videoCallTrafficClass) ? implode(', ', $videoCallTrafficClass) : var_export($videoCallTrafficClass, true), implode(', ', \EnumType\XVideoCallTrafficClass::getValidValues())), __LINE__);
        }
        $this->videoCallTrafficClass = $videoCallTrafficClass;
        return $this;
    }
    /**
     * Get sdpTransparency value
     * @return \StructType\XFkType|null
     */
    public function getSdpTransparency()
    {
        return $this->sdpTransparency;
    }
    /**
     * Set sdpTransparency value
     * @param \StructType\XFkType $sdpTransparency
     * @return \StructType\LSipProfile
     */
    public function setSdpTransparency(\StructType\XFkType $sdpTransparency = null)
    {
        $this->sdpTransparency = $sdpTransparency;
        return $this;
    }
    /**
     * Get allowMultipleCodecs value
     * @return string|null
     */
    public function getAllowMultipleCodecs()
    {
        return $this->allowMultipleCodecs;
    }
    /**
     * Set allowMultipleCodecs value
     * @param string $allowMultipleCodecs
     * @return \StructType\LSipProfile
     */
    public function setAllowMultipleCodecs($allowMultipleCodecs = null)
    {
        // validation for constraint: string
        if (!is_null($allowMultipleCodecs) && !is_string($allowMultipleCodecs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowMultipleCodecs, true), gettype($allowMultipleCodecs)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowMultipleCodecs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowMultipleCodecs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowMultipleCodecs, true)), __LINE__);
        }
        $this->allowMultipleCodecs = $allowMultipleCodecs;
        return $this;
    }
    /**
     * Get sipSessionRefreshMethod value
     * @return string|null
     */
    public function getSipSessionRefreshMethod()
    {
        return $this->sipSessionRefreshMethod;
    }
    /**
     * Set sipSessionRefreshMethod value
     * @uses \EnumType\XSipSessionRefreshMethod::valueIsValid()
     * @uses \EnumType\XSipSessionRefreshMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipSessionRefreshMethod
     * @return \StructType\LSipProfile
     */
    public function setSipSessionRefreshMethod($sipSessionRefreshMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSipSessionRefreshMethod::valueIsValid($sipSessionRefreshMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XSipSessionRefreshMethod', is_array($sipSessionRefreshMethod) ? implode(', ', $sipSessionRefreshMethod) : var_export($sipSessionRefreshMethod, true), implode(', ', \EnumType\XSipSessionRefreshMethod::getValidValues())), __LINE__);
        }
        $this->sipSessionRefreshMethod = $sipSessionRefreshMethod;
        return $this;
    }
    /**
     * Get earlyOfferSuppVoiceCall value
     * @return string|null
     */
    public function getEarlyOfferSuppVoiceCall()
    {
        return $this->earlyOfferSuppVoiceCall;
    }
    /**
     * Set earlyOfferSuppVoiceCall value
     * @uses \EnumType\XEOSuppVoiceCall::valueIsValid()
     * @uses \EnumType\XEOSuppVoiceCall::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $earlyOfferSuppVoiceCall
     * @return \StructType\LSipProfile
     */
    public function setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XEOSuppVoiceCall::valueIsValid($earlyOfferSuppVoiceCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XEOSuppVoiceCall', is_array($earlyOfferSuppVoiceCall) ? implode(', ', $earlyOfferSuppVoiceCall) : var_export($earlyOfferSuppVoiceCall, true), implode(', ', \EnumType\XEOSuppVoiceCall::getValidValues())), __LINE__);
        }
        $this->earlyOfferSuppVoiceCall = $earlyOfferSuppVoiceCall;
        return $this;
    }
    /**
     * Get cucmVersionInSipHeader value
     * @return string|null
     */
    public function getCucmVersionInSipHeader()
    {
        return $this->cucmVersionInSipHeader;
    }
    /**
     * Set cucmVersionInSipHeader value
     * @uses \EnumType\XCUCMVersionInSipHeader::valueIsValid()
     * @uses \EnumType\XCUCMVersionInSipHeader::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cucmVersionInSipHeader
     * @return \StructType\LSipProfile
     */
    public function setCucmVersionInSipHeader($cucmVersionInSipHeader = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCUCMVersionInSipHeader::valueIsValid($cucmVersionInSipHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCUCMVersionInSipHeader', is_array($cucmVersionInSipHeader) ? implode(', ', $cucmVersionInSipHeader) : var_export($cucmVersionInSipHeader, true), implode(', ', \EnumType\XCUCMVersionInSipHeader::getValidValues())), __LINE__);
        }
        $this->cucmVersionInSipHeader = $cucmVersionInSipHeader;
        return $this;
    }
    /**
     * Get confidentialAccessLevelHeaders value
     * @return string|null
     */
    public function getConfidentialAccessLevelHeaders()
    {
        return $this->confidentialAccessLevelHeaders;
    }
    /**
     * Set confidentialAccessLevelHeaders value
     * @uses \EnumType\XCALHeaders::valueIsValid()
     * @uses \EnumType\XCALHeaders::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confidentialAccessLevelHeaders
     * @return \StructType\LSipProfile
     */
    public function setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCALHeaders::valueIsValid($confidentialAccessLevelHeaders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCALHeaders', is_array($confidentialAccessLevelHeaders) ? implode(', ', $confidentialAccessLevelHeaders) : var_export($confidentialAccessLevelHeaders, true), implode(', ', \EnumType\XCALHeaders::getValidValues())), __LINE__);
        }
        $this->confidentialAccessLevelHeaders = $confidentialAccessLevelHeaders;
        return $this;
    }
    /**
     * Get destRouteString value
     * @return string|null
     */
    public function getDestRouteString()
    {
        return $this->destRouteString;
    }
    /**
     * Set destRouteString value
     * @param string $destRouteString
     * @return \StructType\LSipProfile
     */
    public function setDestRouteString($destRouteString = null)
    {
        // validation for constraint: string
        if (!is_null($destRouteString) && !is_string($destRouteString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destRouteString, true), gettype($destRouteString)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($destRouteString) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $destRouteString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($destRouteString, true)), __LINE__);
        }
        $this->destRouteString = $destRouteString;
        return $this;
    }
    /**
     * Get inactiveSDPRequired value
     * @return string|null
     */
    public function getInactiveSDPRequired()
    {
        return $this->inactiveSDPRequired;
    }
    /**
     * Set inactiveSDPRequired value
     * @param string $inactiveSDPRequired
     * @return \StructType\LSipProfile
     */
    public function setInactiveSDPRequired($inactiveSDPRequired = null)
    {
        // validation for constraint: string
        if (!is_null($inactiveSDPRequired) && !is_string($inactiveSDPRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inactiveSDPRequired, true), gettype($inactiveSDPRequired)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($inactiveSDPRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $inactiveSDPRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($inactiveSDPRequired, true)), __LINE__);
        }
        $this->inactiveSDPRequired = $inactiveSDPRequired;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LSipProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
