<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LServiceProfileList StructType
 * @subpackage Structs
 */
class LServiceProfileList extends AbstractStructBase
{
    /**
     * The profileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $profileName;
    /**
     * The primary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primary;
    /**
     * The secondary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondary;
    /**
     * The tertiary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tertiary;
    /**
     * The serverCertificateVerification
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Conferencing Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serverCertificateVerification;
    /**
     * The serviceProfileXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XVendorConfig
     */
    public $serviceProfileXml;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LServiceProfileList
     * @uses LServiceProfileList::setProfileName()
     * @uses LServiceProfileList::setPrimary()
     * @uses LServiceProfileList::setSecondary()
     * @uses LServiceProfileList::setTertiary()
     * @uses LServiceProfileList::setServerCertificateVerification()
     * @uses LServiceProfileList::setServiceProfileXml()
     * @uses LServiceProfileList::setUuid()
     * @param string $profileName
     * @param string $primary
     * @param string $secondary
     * @param string $tertiary
     * @param string $serverCertificateVerification
     * @param \StructType\XVendorConfig $serviceProfileXml
     * @param string $uuid
     */
    public function __construct($profileName = null, $primary = null, $secondary = null, $tertiary = null, $serverCertificateVerification = null, \StructType\XVendorConfig $serviceProfileXml = null, $uuid = null)
    {
        $this
            ->setProfileName($profileName)
            ->setPrimary($primary)
            ->setSecondary($secondary)
            ->setTertiary($tertiary)
            ->setServerCertificateVerification($serverCertificateVerification)
            ->setServiceProfileXml($serviceProfileXml)
            ->setUuid($uuid);
    }
    /**
     * Get profileName value
     * @return string|null
     */
    public function getProfileName()
    {
        return $this->profileName;
    }
    /**
     * Set profileName value
     * @param string $profileName
     * @return \StructType\LServiceProfileList
     */
    public function setProfileName($profileName = null)
    {
        // validation for constraint: string
        if (!is_null($profileName) && !is_string($profileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileName, true), gettype($profileName)), __LINE__);
        }
        $this->profileName = $profileName;
        return $this;
    }
    /**
     * Get primary value
     * @return string|null
     */
    public function getPrimary()
    {
        return $this->primary;
    }
    /**
     * Set primary value
     * @param string $primary
     * @return \StructType\LServiceProfileList
     */
    public function setPrimary($primary = null)
    {
        // validation for constraint: string
        if (!is_null($primary) && !is_string($primary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primary, true), gettype($primary)), __LINE__);
        }
        $this->primary = $primary;
        return $this;
    }
    /**
     * Get secondary value
     * @return string|null
     */
    public function getSecondary()
    {
        return $this->secondary;
    }
    /**
     * Set secondary value
     * @param string $secondary
     * @return \StructType\LServiceProfileList
     */
    public function setSecondary($secondary = null)
    {
        // validation for constraint: string
        if (!is_null($secondary) && !is_string($secondary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondary, true), gettype($secondary)), __LINE__);
        }
        $this->secondary = $secondary;
        return $this;
    }
    /**
     * Get tertiary value
     * @return string|null
     */
    public function getTertiary()
    {
        return $this->tertiary;
    }
    /**
     * Set tertiary value
     * @param string $tertiary
     * @return \StructType\LServiceProfileList
     */
    public function setTertiary($tertiary = null)
    {
        // validation for constraint: string
        if (!is_null($tertiary) && !is_string($tertiary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tertiary, true), gettype($tertiary)), __LINE__);
        }
        $this->tertiary = $tertiary;
        return $this;
    }
    /**
     * Get serverCertificateVerification value
     * @return string|null
     */
    public function getServerCertificateVerification()
    {
        return $this->serverCertificateVerification;
    }
    /**
     * Set serverCertificateVerification value
     * @uses \EnumType\XCertificateVerificationLevel::valueIsValid()
     * @uses \EnumType\XCertificateVerificationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serverCertificateVerification
     * @return \StructType\LServiceProfileList
     */
    public function setServerCertificateVerification($serverCertificateVerification = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCertificateVerificationLevel::valueIsValid($serverCertificateVerification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCertificateVerificationLevel', is_array($serverCertificateVerification) ? implode(', ', $serverCertificateVerification) : var_export($serverCertificateVerification, true), implode(', ', \EnumType\XCertificateVerificationLevel::getValidValues())), __LINE__);
        }
        $this->serverCertificateVerification = $serverCertificateVerification;
        return $this;
    }
    /**
     * Get serviceProfileXml value
     * @return \StructType\XVendorConfig|null
     */
    public function getServiceProfileXml()
    {
        return $this->serviceProfileXml;
    }
    /**
     * Set serviceProfileXml value
     * @param \StructType\XVendorConfig $serviceProfileXml
     * @return \StructType\LServiceProfileList
     */
    public function setServiceProfileXml(\StructType\XVendorConfig $serviceProfileXml = null)
    {
        $this->serviceProfileXml = $serviceProfileXml;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LServiceProfileList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
