<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LExtensions StructType
 * @subpackage Structs
 */
class LExtensions extends AbstractStructBase
{
    /**
     * The extension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $extension;
    /**
     * The linePrimaryUri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $linePrimaryUri;
    /**
     * The partition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $partition;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LExtensions
     * @uses LExtensions::setExtension()
     * @uses LExtensions::setLinePrimaryUri()
     * @uses LExtensions::setPartition()
     * @uses LExtensions::setUuid()
     * @param \StructType\XFkType $extension
     * @param string $linePrimaryUri
     * @param \StructType\XFkType $partition
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $extension = null, $linePrimaryUri = null, \StructType\XFkType $partition = null, $uuid = null)
    {
        $this
            ->setExtension($extension)
            ->setLinePrimaryUri($linePrimaryUri)
            ->setPartition($partition)
            ->setUuid($uuid);
    }
    /**
     * Get extension value
     * @return \StructType\XFkType|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param \StructType\XFkType $extension
     * @return \StructType\LExtensions
     */
    public function setExtension(\StructType\XFkType $extension = null)
    {
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get linePrimaryUri value
     * @return string|null
     */
    public function getLinePrimaryUri()
    {
        return $this->linePrimaryUri;
    }
    /**
     * Set linePrimaryUri value
     * @param string $linePrimaryUri
     * @return \StructType\LExtensions
     */
    public function setLinePrimaryUri($linePrimaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($linePrimaryUri) && !is_string($linePrimaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linePrimaryUri, true), gettype($linePrimaryUri)), __LINE__);
        }
        $this->linePrimaryUri = $linePrimaryUri;
        return $this;
    }
    /**
     * Get partition value
     * @return \StructType\XFkType|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param \StructType\XFkType $partition
     * @return \StructType\LExtensions
     */
    public function setPartition(\StructType\XFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LExtensions
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
