<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCommonDeviceConfig StructType
 * @subpackage Structs
 */
class LCommonDeviceConfig extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The softkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - documentation: Nullable. The value accepted and retrieved from the database for this field will be of type XUserLocale in AXLEnums.xsd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affect devices that support MLPP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - documentation: Default is not applicable for CommonDeviceConfig API
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affect devices that support MLPP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The ipAddressingMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddressingMode;
    /**
     * The ipAddressingModePreferenceControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddressingModePreferenceControl;
    /**
     * The allowAutoConfigurationForPhones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $allowAutoConfigurationForPhones;
    /**
     * The useImeForOutboundCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useImeForOutboundCalls;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The allowDuplicateAddressDetection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $allowDuplicateAddressDetection;
    /**
     * The acceptRedirectMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $acceptRedirectMessages;
    /**
     * The replyMulticastEchoRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $replyMulticastEchoRequest;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCommonDeviceConfig
     * @uses LCommonDeviceConfig::setName()
     * @uses LCommonDeviceConfig::setSoftkeyTemplateName()
     * @uses LCommonDeviceConfig::setUserLocale()
     * @uses LCommonDeviceConfig::setNetworkHoldMohAudioSourceId()
     * @uses LCommonDeviceConfig::setUserHoldMohAudioSourceId()
     * @uses LCommonDeviceConfig::setMlppIndicationStatus()
     * @uses LCommonDeviceConfig::setUseTrustedRelayPoint()
     * @uses LCommonDeviceConfig::setPreemption()
     * @uses LCommonDeviceConfig::setIpAddressingMode()
     * @uses LCommonDeviceConfig::setIpAddressingModePreferenceControl()
     * @uses LCommonDeviceConfig::setAllowAutoConfigurationForPhones()
     * @uses LCommonDeviceConfig::setUseImeForOutboundCalls()
     * @uses LCommonDeviceConfig::setConfidentialAccess()
     * @uses LCommonDeviceConfig::setAllowDuplicateAddressDetection()
     * @uses LCommonDeviceConfig::setAcceptRedirectMessages()
     * @uses LCommonDeviceConfig::setReplyMulticastEchoRequest()
     * @uses LCommonDeviceConfig::setUuid()
     * @param string $name
     * @param \StructType\XFkType $softkeyTemplateName
     * @param string $userLocale
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param string $mlppIndicationStatus
     * @param string $useTrustedRelayPoint
     * @param string $preemption
     * @param string $ipAddressingMode
     * @param string $ipAddressingModePreferenceControl
     * @param string $allowAutoConfigurationForPhones
     * @param string $useImeForOutboundCalls
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param string $allowDuplicateAddressDetection
     * @param string $acceptRedirectMessages
     * @param string $replyMulticastEchoRequest
     * @param string $uuid
     */
    public function __construct($name = null, \StructType\XFkType $softkeyTemplateName = null, $userLocale = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, $mlppIndicationStatus = null, $useTrustedRelayPoint = null, $preemption = null, $ipAddressingMode = null, $ipAddressingModePreferenceControl = null, $allowAutoConfigurationForPhones = null, $useImeForOutboundCalls = null, \StructType\ConfidentialAccess $confidentialAccess = null, $allowDuplicateAddressDetection = null, $acceptRedirectMessages = null, $replyMulticastEchoRequest = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setUserLocale($userLocale)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setPreemption($preemption)
            ->setIpAddressingMode($ipAddressingMode)
            ->setIpAddressingModePreferenceControl($ipAddressingModePreferenceControl)
            ->setAllowAutoConfigurationForPhones($allowAutoConfigurationForPhones)
            ->setUseImeForOutboundCalls($useImeForOutboundCalls)
            ->setConfidentialAccess($confidentialAccess)
            ->setAllowDuplicateAddressDetection($allowDuplicateAddressDetection)
            ->setAcceptRedirectMessages($acceptRedirectMessages)
            ->setReplyMulticastEchoRequest($replyMulticastEchoRequest)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LCommonDeviceConfig
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \StructType\XFkType $softkeyTemplateName
     * @return \StructType\LCommonDeviceConfig
     */
    public function setSoftkeyTemplateName(\StructType\XFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses \EnumType\XUserLocale::valueIsValid()
     * @uses \EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \StructType\LCommonDeviceConfig
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XUserLocale', is_array($userLocale) ? implode(', ', $userLocale) : var_export($userLocale, true), implode(', ', \EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \StructType\LCommonDeviceConfig
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMOHAudioSourceId', is_array($networkHoldMohAudioSourceId) ? implode(', ', $networkHoldMohAudioSourceId) : var_export($networkHoldMohAudioSourceId, true), implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \StructType\LCommonDeviceConfig
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMOHAudioSourceId', is_array($userHoldMohAudioSourceId) ? implode(', ', $userHoldMohAudioSourceId) : var_export($userHoldMohAudioSourceId, true), implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \StructType\LCommonDeviceConfig
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($mlppIndicationStatus) ? implode(', ', $mlppIndicationStatus) : var_export($mlppIndicationStatus, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \StructType\LCommonDeviceConfig
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: string
        if (!is_null($useTrustedRelayPoint) && !is_string($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useTrustedRelayPoint, true), gettype($useTrustedRelayPoint)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useTrustedRelayPoint) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useTrustedRelayPoint, true)), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \EnumType\XPreemption::valueIsValid()
     * @uses \EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \StructType\LCommonDeviceConfig
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPreemption', is_array($preemption) ? implode(', ', $preemption) : var_export($preemption, true), implode(', ', \EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get ipAddressingMode value
     * @return string|null
     */
    public function getIpAddressingMode()
    {
        return $this->ipAddressingMode;
    }
    /**
     * Set ipAddressingMode value
     * @uses \EnumType\XIPAddressingMode::valueIsValid()
     * @uses \EnumType\XIPAddressingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressingMode
     * @return \StructType\LCommonDeviceConfig
     */
    public function setIpAddressingMode($ipAddressingMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XIPAddressingMode::valueIsValid($ipAddressingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XIPAddressingMode', is_array($ipAddressingMode) ? implode(', ', $ipAddressingMode) : var_export($ipAddressingMode, true), implode(', ', \EnumType\XIPAddressingMode::getValidValues())), __LINE__);
        }
        $this->ipAddressingMode = $ipAddressingMode;
        return $this;
    }
    /**
     * Get ipAddressingModePreferenceControl value
     * @return string|null
     */
    public function getIpAddressingModePreferenceControl()
    {
        return $this->ipAddressingModePreferenceControl;
    }
    /**
     * Set ipAddressingModePreferenceControl value
     * @uses \EnumType\XIPAddressingModePrefControl::valueIsValid()
     * @uses \EnumType\XIPAddressingModePrefControl::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressingModePreferenceControl
     * @return \StructType\LCommonDeviceConfig
     */
    public function setIpAddressingModePreferenceControl($ipAddressingModePreferenceControl = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XIPAddressingModePrefControl::valueIsValid($ipAddressingModePreferenceControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XIPAddressingModePrefControl', is_array($ipAddressingModePreferenceControl) ? implode(', ', $ipAddressingModePreferenceControl) : var_export($ipAddressingModePreferenceControl, true), implode(', ', \EnumType\XIPAddressingModePrefControl::getValidValues())), __LINE__);
        }
        $this->ipAddressingModePreferenceControl = $ipAddressingModePreferenceControl;
        return $this;
    }
    /**
     * Get allowAutoConfigurationForPhones value
     * @return string|null
     */
    public function getAllowAutoConfigurationForPhones()
    {
        return $this->allowAutoConfigurationForPhones;
    }
    /**
     * Set allowAutoConfigurationForPhones value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allowAutoConfigurationForPhones
     * @return \StructType\LCommonDeviceConfig
     */
    public function setAllowAutoConfigurationForPhones($allowAutoConfigurationForPhones = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($allowAutoConfigurationForPhones)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($allowAutoConfigurationForPhones) ? implode(', ', $allowAutoConfigurationForPhones) : var_export($allowAutoConfigurationForPhones, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->allowAutoConfigurationForPhones = $allowAutoConfigurationForPhones;
        return $this;
    }
    /**
     * Get useImeForOutboundCalls value
     * @return string|null
     */
    public function getUseImeForOutboundCalls()
    {
        return $this->useImeForOutboundCalls;
    }
    /**
     * Set useImeForOutboundCalls value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useImeForOutboundCalls
     * @return \StructType\LCommonDeviceConfig
     */
    public function setUseImeForOutboundCalls($useImeForOutboundCalls = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useImeForOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($useImeForOutboundCalls) ? implode(', ', $useImeForOutboundCalls) : var_export($useImeForOutboundCalls, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useImeForOutboundCalls = $useImeForOutboundCalls;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\LCommonDeviceConfig
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get allowDuplicateAddressDetection value
     * @return string|null
     */
    public function getAllowDuplicateAddressDetection()
    {
        return $this->allowDuplicateAddressDetection;
    }
    /**
     * Set allowDuplicateAddressDetection value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allowDuplicateAddressDetection
     * @return \StructType\LCommonDeviceConfig
     */
    public function setAllowDuplicateAddressDetection($allowDuplicateAddressDetection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($allowDuplicateAddressDetection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($allowDuplicateAddressDetection) ? implode(', ', $allowDuplicateAddressDetection) : var_export($allowDuplicateAddressDetection, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->allowDuplicateAddressDetection = $allowDuplicateAddressDetection;
        return $this;
    }
    /**
     * Get acceptRedirectMessages value
     * @return string|null
     */
    public function getAcceptRedirectMessages()
    {
        return $this->acceptRedirectMessages;
    }
    /**
     * Set acceptRedirectMessages value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acceptRedirectMessages
     * @return \StructType\LCommonDeviceConfig
     */
    public function setAcceptRedirectMessages($acceptRedirectMessages = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($acceptRedirectMessages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($acceptRedirectMessages) ? implode(', ', $acceptRedirectMessages) : var_export($acceptRedirectMessages, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->acceptRedirectMessages = $acceptRedirectMessages;
        return $this;
    }
    /**
     * Get replyMulticastEchoRequest value
     * @return string|null
     */
    public function getReplyMulticastEchoRequest()
    {
        return $this->replyMulticastEchoRequest;
    }
    /**
     * Set replyMulticastEchoRequest value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $replyMulticastEchoRequest
     * @return \StructType\LCommonDeviceConfig
     */
    public function setReplyMulticastEchoRequest($replyMulticastEchoRequest = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($replyMulticastEchoRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($replyMulticastEchoRequest) ? implode(', ', $replyMulticastEchoRequest) : var_export($replyMulticastEchoRequest, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->replyMulticastEchoRequest = $replyMulticastEchoRequest;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LCommonDeviceConfig
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
