<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCalledPartyTracing StructType
 * @subpackage Structs
 */
class LCalledPartyTracing extends AbstractStructBase
{
    /**
     * The directorynumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directorynumber;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCalledPartyTracing
     * @uses LCalledPartyTracing::setDirectorynumber()
     * @uses LCalledPartyTracing::setDescription()
     * @uses LCalledPartyTracing::setUuid()
     * @param string $directorynumber
     * @param string $description
     * @param string $uuid
     */
    public function __construct($directorynumber = null, $description = null, $uuid = null)
    {
        $this
            ->setDirectorynumber($directorynumber)
            ->setDescription($description)
            ->setUuid($uuid);
    }
    /**
     * Get directorynumber value
     * @return string|null
     */
    public function getDirectorynumber()
    {
        return $this->directorynumber;
    }
    /**
     * Set directorynumber value
     * @param string $directorynumber
     * @return \StructType\LCalledPartyTracing
     */
    public function setDirectorynumber($directorynumber = null)
    {
        // validation for constraint: string
        if (!is_null($directorynumber) && !is_string($directorynumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directorynumber, true), gettype($directorynumber)), __LINE__);
        }
        $this->directorynumber = $directorynumber;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LCalledPartyTracing
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LCalledPartyTracing
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
