<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCallPickupGroup StructType
 * @subpackage Structs
 */
class LCallPickupGroup extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The pickupNotification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickupNotification;
    /**
     * The pickupNotificationTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickupNotificationTimer;
    /**
     * The callInfoForPickupNotification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CallInfoForPickupNotification
     */
    public $callInfoForPickupNotification;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCallPickupGroup
     * @uses LCallPickupGroup::setPattern()
     * @uses LCallPickupGroup::setDescription()
     * @uses LCallPickupGroup::setUsage()
     * @uses LCallPickupGroup::setRoutePartitionName()
     * @uses LCallPickupGroup::setPickupNotification()
     * @uses LCallPickupGroup::setPickupNotificationTimer()
     * @uses LCallPickupGroup::setCallInfoForPickupNotification()
     * @uses LCallPickupGroup::setName()
     * @uses LCallPickupGroup::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \StructType\XFkType $routePartitionName
     * @param string $pickupNotification
     * @param string $pickupNotificationTimer
     * @param \StructType\CallInfoForPickupNotification $callInfoForPickupNotification
     * @param string $name
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \StructType\XFkType $routePartitionName = null, $pickupNotification = null, $pickupNotificationTimer = null, \StructType\CallInfoForPickupNotification $callInfoForPickupNotification = null, $name = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setPickupNotification($pickupNotification)
            ->setPickupNotificationTimer($pickupNotificationTimer)
            ->setCallInfoForPickupNotification($callInfoForPickupNotification)
            ->setName($name)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\LCallPickupGroup
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LCallPickupGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \EnumType\XPatternUsage::valueIsValid()
     * @uses \EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \StructType\LCallPickupGroup
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPatternUsage', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\LCallPickupGroup
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get pickupNotification value
     * @return string|null
     */
    public function getPickupNotification()
    {
        return $this->pickupNotification;
    }
    /**
     * Set pickupNotification value
     * @uses \EnumType\XPickupNotification::valueIsValid()
     * @uses \EnumType\XPickupNotification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupNotification
     * @return \StructType\LCallPickupGroup
     */
    public function setPickupNotification($pickupNotification = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPickupNotification::valueIsValid($pickupNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPickupNotification', is_array($pickupNotification) ? implode(', ', $pickupNotification) : var_export($pickupNotification, true), implode(', ', \EnumType\XPickupNotification::getValidValues())), __LINE__);
        }
        $this->pickupNotification = $pickupNotification;
        return $this;
    }
    /**
     * Get pickupNotificationTimer value
     * @return string|null
     */
    public function getPickupNotificationTimer()
    {
        return $this->pickupNotificationTimer;
    }
    /**
     * Set pickupNotificationTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupNotificationTimer
     * @return \StructType\LCallPickupGroup
     */
    public function setPickupNotificationTimer($pickupNotificationTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($pickupNotificationTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($pickupNotificationTimer) ? implode(', ', $pickupNotificationTimer) : var_export($pickupNotificationTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pickupNotificationTimer = $pickupNotificationTimer;
        return $this;
    }
    /**
     * Get callInfoForPickupNotification value
     * @return \StructType\CallInfoForPickupNotification|null
     */
    public function getCallInfoForPickupNotification()
    {
        return $this->callInfoForPickupNotification;
    }
    /**
     * Set callInfoForPickupNotification value
     * @param \StructType\CallInfoForPickupNotification $callInfoForPickupNotification
     * @return \StructType\LCallPickupGroup
     */
    public function setCallInfoForPickupNotification(\StructType\CallInfoForPickupNotification $callInfoForPickupNotification = null)
    {
        $this->callInfoForPickupNotification = $callInfoForPickupNotification;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LCallPickupGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LCallPickupGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
