<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LApplicationServer StructType
 * @subpackage Structs
 */
class LApplicationServer extends AbstractStructBase
{
    /**
     * The appServerType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appServerType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddress;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The endUserUrl
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server, CER Location Management
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endUserUrl;
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - documentation: Applicable Only for Cisco Web dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $processNodeName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LApplicationServer
     * @uses LApplicationServer::setAppServerType()
     * @uses LApplicationServer::setName()
     * @uses LApplicationServer::setIpAddress()
     * @uses LApplicationServer::setUrl()
     * @uses LApplicationServer::setEndUserUrl()
     * @uses LApplicationServer::setProcessNodeName()
     * @uses LApplicationServer::setUuid()
     * @param string $appServerType
     * @param string $name
     * @param string $ipAddress
     * @param string $url
     * @param string $endUserUrl
     * @param \StructType\XFkType $processNodeName
     * @param string $uuid
     */
    public function __construct($appServerType = null, $name = null, $ipAddress = null, $url = null, $endUserUrl = null, \StructType\XFkType $processNodeName = null, $uuid = null)
    {
        $this
            ->setAppServerType($appServerType)
            ->setName($name)
            ->setIpAddress($ipAddress)
            ->setUrl($url)
            ->setEndUserUrl($endUserUrl)
            ->setProcessNodeName($processNodeName)
            ->setUuid($uuid);
    }
    /**
     * Get appServerType value
     * @return string|null
     */
    public function getAppServerType()
    {
        return $this->appServerType;
    }
    /**
     * Set appServerType value
     * @uses \EnumType\XAppServer::valueIsValid()
     * @uses \EnumType\XAppServer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appServerType
     * @return \StructType\LApplicationServer
     */
    public function setAppServerType($appServerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAppServer::valueIsValid($appServerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XAppServer', is_array($appServerType) ? implode(', ', $appServerType) : var_export($appServerType, true), implode(', ', \EnumType\XAppServer::getValidValues())), __LINE__);
        }
        $this->appServerType = $appServerType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LApplicationServer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\LApplicationServer
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\LApplicationServer
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get endUserUrl value
     * @return string|null
     */
    public function getEndUserUrl()
    {
        return $this->endUserUrl;
    }
    /**
     * Set endUserUrl value
     * @param string $endUserUrl
     * @return \StructType\LApplicationServer
     */
    public function setEndUserUrl($endUserUrl = null)
    {
        // validation for constraint: string
        if (!is_null($endUserUrl) && !is_string($endUserUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endUserUrl, true), gettype($endUserUrl)), __LINE__);
        }
        $this->endUserUrl = $endUserUrl;
        return $this;
    }
    /**
     * Get processNodeName value
     * @return \StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \StructType\XFkType $processNodeName
     * @return \StructType\LApplicationServer
     */
    public function setProcessNodeName(\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LApplicationServer
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
