<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LAppUser StructType
 * @subpackage Structs
 */
class LAppUser extends AbstractStructBase
{
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The acceptPresenceSubscription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptPresenceSubscription;
    /**
     * The acceptOutOfDialogRefer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutOfDialogRefer;
    /**
     * The acceptUnsolicitedNotification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptUnsolicitedNotification;
    /**
     * The allowReplaceHeader
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowReplaceHeader;
    /**
     * The isStandard
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isStandard;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LAppUser
     * @uses LAppUser::setUserid()
     * @uses LAppUser::setPresenceGroupName()
     * @uses LAppUser::setAcceptPresenceSubscription()
     * @uses LAppUser::setAcceptOutOfDialogRefer()
     * @uses LAppUser::setAcceptUnsolicitedNotification()
     * @uses LAppUser::setAllowReplaceHeader()
     * @uses LAppUser::setIsStandard()
     * @uses LAppUser::setUuid()
     * @param string $userid
     * @param \StructType\XFkType $presenceGroupName
     * @param string $acceptPresenceSubscription
     * @param string $acceptOutOfDialogRefer
     * @param string $acceptUnsolicitedNotification
     * @param string $allowReplaceHeader
     * @param string $isStandard
     * @param string $uuid
     */
    public function __construct($userid = null, \StructType\XFkType $presenceGroupName = null, $acceptPresenceSubscription = null, $acceptOutOfDialogRefer = null, $acceptUnsolicitedNotification = null, $allowReplaceHeader = null, $isStandard = null, $uuid = null)
    {
        $this
            ->setUserid($userid)
            ->setPresenceGroupName($presenceGroupName)
            ->setAcceptPresenceSubscription($acceptPresenceSubscription)
            ->setAcceptOutOfDialogRefer($acceptOutOfDialogRefer)
            ->setAcceptUnsolicitedNotification($acceptUnsolicitedNotification)
            ->setAllowReplaceHeader($allowReplaceHeader)
            ->setIsStandard($isStandard)
            ->setUuid($uuid);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\LAppUser
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\XFkType $presenceGroupName
     * @return \StructType\LAppUser
     */
    public function setPresenceGroupName(\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get acceptPresenceSubscription value
     * @return string|null
     */
    public function getAcceptPresenceSubscription()
    {
        return $this->acceptPresenceSubscription;
    }
    /**
     * Set acceptPresenceSubscription value
     * @param string $acceptPresenceSubscription
     * @return \StructType\LAppUser
     */
    public function setAcceptPresenceSubscription($acceptPresenceSubscription = null)
    {
        // validation for constraint: string
        if (!is_null($acceptPresenceSubscription) && !is_string($acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptPresenceSubscription, true), gettype($acceptPresenceSubscription)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptPresenceSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptPresenceSubscription, true)), __LINE__);
        }
        $this->acceptPresenceSubscription = $acceptPresenceSubscription;
        return $this;
    }
    /**
     * Get acceptOutOfDialogRefer value
     * @return string|null
     */
    public function getAcceptOutOfDialogRefer()
    {
        return $this->acceptOutOfDialogRefer;
    }
    /**
     * Set acceptOutOfDialogRefer value
     * @param string $acceptOutOfDialogRefer
     * @return \StructType\LAppUser
     */
    public function setAcceptOutOfDialogRefer($acceptOutOfDialogRefer = null)
    {
        // validation for constraint: string
        if (!is_null($acceptOutOfDialogRefer) && !is_string($acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptOutOfDialogRefer, true), gettype($acceptOutOfDialogRefer)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptOutOfDialogRefer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptOutOfDialogRefer, true)), __LINE__);
        }
        $this->acceptOutOfDialogRefer = $acceptOutOfDialogRefer;
        return $this;
    }
    /**
     * Get acceptUnsolicitedNotification value
     * @return string|null
     */
    public function getAcceptUnsolicitedNotification()
    {
        return $this->acceptUnsolicitedNotification;
    }
    /**
     * Set acceptUnsolicitedNotification value
     * @param string $acceptUnsolicitedNotification
     * @return \StructType\LAppUser
     */
    public function setAcceptUnsolicitedNotification($acceptUnsolicitedNotification = null)
    {
        // validation for constraint: string
        if (!is_null($acceptUnsolicitedNotification) && !is_string($acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptUnsolicitedNotification, true), gettype($acceptUnsolicitedNotification)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptUnsolicitedNotification) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptUnsolicitedNotification, true)), __LINE__);
        }
        $this->acceptUnsolicitedNotification = $acceptUnsolicitedNotification;
        return $this;
    }
    /**
     * Get allowReplaceHeader value
     * @return string|null
     */
    public function getAllowReplaceHeader()
    {
        return $this->allowReplaceHeader;
    }
    /**
     * Set allowReplaceHeader value
     * @param string $allowReplaceHeader
     * @return \StructType\LAppUser
     */
    public function setAllowReplaceHeader($allowReplaceHeader = null)
    {
        // validation for constraint: string
        if (!is_null($allowReplaceHeader) && !is_string($allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowReplaceHeader, true), gettype($allowReplaceHeader)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowReplaceHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowReplaceHeader, true)), __LINE__);
        }
        $this->allowReplaceHeader = $allowReplaceHeader;
        return $this;
    }
    /**
     * Get isStandard value
     * @return string|null
     */
    public function getIsStandard()
    {
        return $this->isStandard;
    }
    /**
     * Set isStandard value
     * @param string $isStandard
     * @return \StructType\LAppUser
     */
    public function setIsStandard($isStandard = null)
    {
        // validation for constraint: string
        if (!is_null($isStandard) && !is_string($isStandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isStandard, true), gettype($isStandard)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isStandard) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isStandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isStandard, true)), __LINE__);
        }
        $this->isStandard = $isStandard;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LAppUser
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
