<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSyslogConfigurationReq StructType
 * @subpackage Structs
 */
class GetSyslogConfigurationReq extends AbstractStructBase
{
    /**
     * The serverName
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $serverName;
    /**
     * The serviceGroup
     * Meta information extracted from the WSDL
     * - default: CM Services
     * - nillable: false
     * @var string
     */
    public $serviceGroup;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $service;
    /**
     * The returnedTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RSyslogConfiguration
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetSyslogConfigurationReq
     * @uses GetSyslogConfigurationReq::setServerName()
     * @uses GetSyslogConfigurationReq::setServiceGroup()
     * @uses GetSyslogConfigurationReq::setService()
     * @uses GetSyslogConfigurationReq::setReturnedTags()
     * @uses GetSyslogConfigurationReq::setSequence()
     * @param string $serverName
     * @param string $serviceGroup
     * @param string $service
     * @param \StructType\RSyslogConfiguration $returnedTags
     * @param int $sequence
     */
    public function __construct($serverName = null, $serviceGroup = 'CM Services', $service = null, \StructType\RSyslogConfiguration $returnedTags = null, $sequence = null)
    {
        $this
            ->setServerName($serverName)
            ->setServiceGroup($serviceGroup)
            ->setService($service)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get serverName value
     * @return string|null
     */
    public function getServerName()
    {
        return $this->serverName;
    }
    /**
     * Set serverName value
     * @param string $serverName
     * @return \StructType\GetSyslogConfigurationReq
     */
    public function setServerName($serverName = null)
    {
        // validation for constraint: string
        if (!is_null($serverName) && !is_string($serverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverName, true), gettype($serverName)), __LINE__);
        }
        $this->serverName = $serverName;
        return $this;
    }
    /**
     * Get serviceGroup value
     * @return string|null
     */
    public function getServiceGroup()
    {
        return $this->serviceGroup;
    }
    /**
     * Set serviceGroup value
     * @uses \EnumType\XServiceGrouping::valueIsValid()
     * @uses \EnumType\XServiceGrouping::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceGroup
     * @return \StructType\GetSyslogConfigurationReq
     */
    public function setServiceGroup($serviceGroup = 'CM Services')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XServiceGrouping::valueIsValid($serviceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XServiceGrouping', is_array($serviceGroup) ? implode(', ', $serviceGroup) : var_export($serviceGroup, true), implode(', ', \EnumType\XServiceGrouping::getValidValues())), __LINE__);
        }
        $this->serviceGroup = $serviceGroup;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\GetSyslogConfigurationReq
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \StructType\RSyslogConfiguration|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \StructType\RSyslogConfiguration $returnedTags
     * @return \StructType\GetSyslogConfigurationReq
     */
    public function setReturnedTags(\StructType\RSyslogConfiguration $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\GetSyslogConfigurationReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
}
