<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSNMPCommunityStringReq StructType
 * @subpackage Structs
 */
class GetSNMPCommunityStringReq extends APIRequest
{
    /**
     * The communityName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * @var string
     */
    public $communityName;
    /**
     * Constructor method for GetSNMPCommunityStringReq
     * @uses GetSNMPCommunityStringReq::setCommunityName()
     * @param string $communityName
     */
    public function __construct($communityName = null)
    {
        $this
            ->setCommunityName($communityName);
    }
    /**
     * Get communityName value
     * @return string|null
     */
    public function getCommunityName()
    {
        return $this->communityName;
    }
    /**
     * Set communityName value
     * @param string $communityName
     * @return \StructType\GetSNMPCommunityStringReq
     */
    public function setCommunityName($communityName = null)
    {
        // validation for constraint: string
        if (!is_null($communityName) && !is_string($communityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communityName, true), gettype($communityName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($communityName) && mb_strlen($communityName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($communityName)), __LINE__);
        }
        $this->communityName = $communityName;
        return $this;
    }
}
