<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPageLayoutPreferencesReq StructType
 * @subpackage Structs
 */
class GetPageLayoutPreferencesReq extends APIRequest
{
    /**
     * The pageName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * @var string
     */
    public $pageName;
    /**
     * The returnedTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RPageLayoutPreferences
     */
    public $returnedTags;
    /**
     * Constructor method for GetPageLayoutPreferencesReq
     * @uses GetPageLayoutPreferencesReq::setPageName()
     * @uses GetPageLayoutPreferencesReq::setReturnedTags()
     * @param string $pageName
     * @param \StructType\RPageLayoutPreferences $returnedTags
     */
    public function __construct($pageName = null, \StructType\RPageLayoutPreferences $returnedTags = null)
    {
        $this
            ->setPageName($pageName)
            ->setReturnedTags($returnedTags);
    }
    /**
     * Get pageName value
     * @return string|null
     */
    public function getPageName()
    {
        return $this->pageName;
    }
    /**
     * Set pageName value
     * @param string $pageName
     * @return \StructType\GetPageLayoutPreferencesReq
     */
    public function setPageName($pageName = null)
    {
        // validation for constraint: string
        if (!is_null($pageName) && !is_string($pageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageName, true), gettype($pageName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($pageName) && mb_strlen($pageName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($pageName)), __LINE__);
        }
        $this->pageName = $pageName;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \StructType\RPageLayoutPreferences|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \StructType\RPageLayoutPreferences $returnedTags
     * @return \StructType\GetPageLayoutPreferencesReq
     */
    public function setReturnedTags(\StructType\RPageLayoutPreferences $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
}
