<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInterClusterServiceProfileReq StructType
 * @subpackage Structs
 */
class GetInterClusterServiceProfileReq extends AbstractStructBase
{
    /**
     * The interClusterService
     * Meta information extracted from the WSDL
     * - choice: interClusterService | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - default: EMCC
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $interClusterService;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: interClusterService | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RInterClusterServiceProfile
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetInterClusterServiceProfileReq
     * @uses GetInterClusterServiceProfileReq::setInterClusterService()
     * @uses GetInterClusterServiceProfileReq::setUuid()
     * @uses GetInterClusterServiceProfileReq::setReturnedTags()
     * @uses GetInterClusterServiceProfileReq::setSequence()
     * @param string $interClusterService
     * @param string $uuid
     * @param \StructType\RInterClusterServiceProfile $returnedTags
     * @param int $sequence
     */
    public function __construct($interClusterService = 'EMCC', $uuid = null, \StructType\RInterClusterServiceProfile $returnedTags = null, $sequence = null)
    {
        $this
            ->setInterClusterService($interClusterService)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get interClusterService value
     * @return string
     */
    public function getInterClusterService()
    {
        return isset($this->interClusterService) ? $this->interClusterService : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInterClusterService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterClusterService method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInterClusterServiceForChoiceConstraintsFromSetInterClusterService($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property interClusterService can\'t be set as the property %s is already set. Only one property must be set among these properties: interClusterService, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set interClusterService value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @uses \EnumType\XInterClusterService::valueIsValid()
     * @uses \EnumType\XInterClusterService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interClusterService
     * @return \StructType\GetInterClusterServiceProfileReq
     */
    public function setInterClusterService($interClusterService = 'EMCC')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInterClusterService::valueIsValid($interClusterService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInterClusterService', is_array($interClusterService) ? implode(', ', $interClusterService) : var_export($interClusterService, true), implode(', ', \EnumType\XInterClusterService::getValidValues())), __LINE__);
        }
        // validation for constraint: choice(interClusterService, uuid)
        if ('' !== ($interClusterServiceChoiceErrorMessage = self::validateInterClusterServiceForChoiceConstraintsFromSetInterClusterService($interClusterService))) {
            throw new \InvalidArgumentException($interClusterServiceChoiceErrorMessage, __LINE__);
        }
        if (is_null($interClusterService) || (is_array($interClusterService) && empty($interClusterService))) {
            unset($this->interClusterService);
        } else {
            $this->interClusterService = $interClusterService;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'interClusterService',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\GetInterClusterServiceProfileReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(interClusterService, uuid)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \StructType\RInterClusterServiceProfile|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \StructType\RInterClusterServiceProfile $returnedTags
     * @return \StructType\GetInterClusterServiceProfileReq
     */
    public function setReturnedTags(\StructType\RInterClusterServiceProfile $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\GetInterClusterServiceProfileReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
}
