<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEmccFeatureConfigReq StructType
 * @subpackage Structs
 */
class GetEmccFeatureConfigReq extends AbstractStructBase
{
    /**
     * The parameterName
     * Meta information extracted from the WSDL
     * - documentation: Name of the Emcc Parameter
     * - base: xsd:string
     * - choice: parameterName | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $parameterName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: parameterName | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REmccFeatureConfig
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetEmccFeatureConfigReq
     * @uses GetEmccFeatureConfigReq::setParameterName()
     * @uses GetEmccFeatureConfigReq::setUuid()
     * @uses GetEmccFeatureConfigReq::setReturnedTags()
     * @uses GetEmccFeatureConfigReq::setSequence()
     * @param string $parameterName
     * @param string $uuid
     * @param \StructType\REmccFeatureConfig $returnedTags
     * @param int $sequence
     */
    public function __construct($parameterName = null, $uuid = null, \StructType\REmccFeatureConfig $returnedTags = null, $sequence = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get parameterName value
     * @return string
     */
    public function getParameterName()
    {
        return isset($this->parameterName) ? $this->parameterName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setParameterName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameterName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateParameterNameForChoiceConstraintsFromSetParameterName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property parameterName can\'t be set as the property %s is already set. Only one property must be set among these properties: parameterName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set parameterName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $parameterName
     * @return \StructType\GetEmccFeatureConfigReq
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterName, true), gettype($parameterName)), __LINE__);
        }
        // validation for constraint: choice(parameterName, uuid)
        if ('' !== ($parameterNameChoiceErrorMessage = self::validateParameterNameForChoiceConstraintsFromSetParameterName($parameterName))) {
            throw new \InvalidArgumentException($parameterNameChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($parameterName) && mb_strlen($parameterName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($parameterName)), __LINE__);
        }
        if (is_null($parameterName) || (is_array($parameterName) && empty($parameterName))) {
            unset($this->parameterName);
        } else {
            $this->parameterName = $parameterName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'parameterName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\GetEmccFeatureConfigReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(parameterName, uuid)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \StructType\REmccFeatureConfig|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \StructType\REmccFeatureConfig $returnedTags
     * @return \StructType\GetEmccFeatureConfigReq
     */
    public function setReturnedTags(\StructType\REmccFeatureConfig $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\GetEmccFeatureConfigReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
}
