<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for forwardHuntNoAnswer StructType
 * @subpackage Structs
 */
class ForwardHuntNoAnswer extends AbstractStructBase
{
    /**
     * The usePersonalPreferences
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePersonalPreferences;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $destination;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * Constructor method for forwardHuntNoAnswer
     * @uses ForwardHuntNoAnswer::setUsePersonalPreferences()
     * @uses ForwardHuntNoAnswer::setDestination()
     * @uses ForwardHuntNoAnswer::setCallingSearchSpaceName()
     * @param string $usePersonalPreferences
     * @param string $destination
     * @param \StructType\XFkType $callingSearchSpaceName
     */
    public function __construct($usePersonalPreferences = 'false', $destination = null, \StructType\XFkType $callingSearchSpaceName = null)
    {
        $this
            ->setUsePersonalPreferences($usePersonalPreferences)
            ->setDestination($destination)
            ->setCallingSearchSpaceName($callingSearchSpaceName);
    }
    /**
     * Get usePersonalPreferences value
     * @return string|null
     */
    public function getUsePersonalPreferences()
    {
        return $this->usePersonalPreferences;
    }
    /**
     * Set usePersonalPreferences value
     * @param string $usePersonalPreferences
     * @return \StructType\ForwardHuntNoAnswer
     */
    public function setUsePersonalPreferences($usePersonalPreferences = 'false')
    {
        // validation for constraint: string
        if (!is_null($usePersonalPreferences) && !is_string($usePersonalPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usePersonalPreferences, true), gettype($usePersonalPreferences)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($usePersonalPreferences) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePersonalPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($usePersonalPreferences, true)), __LINE__);
        }
        $this->usePersonalPreferences = $usePersonalPreferences;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\ForwardHuntNoAnswer
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\ForwardHuntNoAnswer
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
}
