<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for features StructType
 * @subpackage Structs
 */
class Features extends AbstractStructBase
{
    /**
     * The feature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XFeatureControlConfig[]
     */
    public $feature;
    /**
     * Constructor method for features
     * @uses Features::setFeature()
     * @param \StructType\XFeatureControlConfig[] $feature
     */
    public function __construct(array $feature = array())
    {
        $this
            ->setFeature($feature);
    }
    /**
     * Get feature value
     * @return \StructType\XFeatureControlConfig[]|null
     */
    public function getFeature()
    {
        return $this->feature;
    }
    /**
     * This method is responsible for validating the values passed to the setFeature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeatureForArrayConstraintsFromSetFeature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $featuresFeatureItem) {
            // validation for constraint: itemType
            if (!$featuresFeatureItem instanceof \StructType\XFeatureControlConfig) {
                $invalidValues[] = is_object($featuresFeatureItem) ? get_class($featuresFeatureItem) : sprintf('%s(%s)', gettype($featuresFeatureItem), var_export($featuresFeatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The feature property can only contain items of type \StructType\XFeatureControlConfig, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set feature value
     * @throws \InvalidArgumentException
     * @param \StructType\XFeatureControlConfig[] $feature
     * @return \StructType\Features
     */
    public function setFeature(array $feature = array())
    {
        // validation for constraint: array
        if ('' !== ($featureArrayErrorMessage = self::validateFeatureForArrayConstraintsFromSetFeature($feature))) {
            throw new \InvalidArgumentException($featureArrayErrorMessage, __LINE__);
        }
        $this->feature = $feature;
        return $this;
    }
    /**
     * Add item to feature value
     * @throws \InvalidArgumentException
     * @param \StructType\XFeatureControlConfig $item
     * @return \StructType\Features
     */
    public function addToFeature(\StructType\XFeatureControlConfig $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XFeatureControlConfig) {
            throw new \InvalidArgumentException(sprintf('The feature property can only contain items of type \StructType\XFeatureControlConfig, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->feature[] = $item;
        return $this;
    }
}
