<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoAuthenticateUserReq StructType
 * Meta information extracted from the WSDL
 * - documentation: Authenticates the user on the basis of pin or password.
 * @subpackage Structs
 */
class DoAuthenticateUserReq extends APIRequest
{
    /**
     * The userid
     * @var string
     */
    public $userid;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - choice: password | pin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - documentation: Applicable for end users only.
     * - base: xsd:string
     * - choice: password | pin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \d\d\d\d+
     * @var string
     */
    public $pin;
    /**
     * Constructor method for DoAuthenticateUserReq
     * @uses DoAuthenticateUserReq::setUserid()
     * @uses DoAuthenticateUserReq::setPassword()
     * @uses DoAuthenticateUserReq::setPin()
     * @param string $userid
     * @param string $password
     * @param string $pin
     */
    public function __construct($userid = null, $password = null, $pin = null)
    {
        $this
            ->setUserid($userid)
            ->setPassword($password)
            ->setPin($pin);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\DoAuthenticateUserReq
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPassword method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassword method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePasswordForChoiceConstraintsFromSetPassword($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'pin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property password can\'t be set as the property %s is already set. Only one property must be set among these properties: password, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set password value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $password
     * @return \StructType\DoAuthenticateUserReq
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        // validation for constraint: choice(password, pin)
        if ('' !== ($passwordChoiceErrorMessage = self::validatePasswordForChoiceConstraintsFromSetPassword($password))) {
            throw new \InvalidArgumentException($passwordChoiceErrorMessage, __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return isset($this->pin) ? $this->pin : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPin method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePinForChoiceConstraintsFromSetPin($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'password',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property pin can\'t be set as the property %s is already set. Only one property must be set among these properties: pin, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set pin value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pin
     * @return \StructType\DoAuthenticateUserReq
     */
    public function setPin($pin = null)
    {
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin, true), gettype($pin)), __LINE__);
        }
        // validation for constraint: choice(password, pin)
        if ('' !== ($pinChoiceErrorMessage = self::validatePinForChoiceConstraintsFromSetPin($pin))) {
            throw new \InvalidArgumentException($pinChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\d\d\d\d+)
        if (!is_null($pin) && !preg_match('/\\d\\d\\d\\d+/', $pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d\d\d\d+', var_export($pin, true)), __LINE__);
        }
        if (is_null($pin) || (is_array($pin) && empty($pin))) {
            unset($this->pin);
        } else {
            $this->pin = $pin;
        }
        return $this;
    }
}
