<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for callInfoForPickupNotification StructType
 * Meta information extracted from the WSDL
 * - documentation: This tag is applicable when Pickup Notification Policy is "Visual Alert" or "Visual or Audio Alert".
 * @subpackage Structs
 */
class CallInfoForPickupNotification extends AbstractStructBase
{
    /**
     * The callingPartyInfo
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callingPartyInfo;
    /**
     * The calledPartyInfo
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $calledPartyInfo;
    /**
     * Constructor method for callInfoForPickupNotification
     * @uses CallInfoForPickupNotification::setCallingPartyInfo()
     * @uses CallInfoForPickupNotification::setCalledPartyInfo()
     * @param string $callingPartyInfo
     * @param string $calledPartyInfo
     */
    public function __construct($callingPartyInfo = 'false', $calledPartyInfo = 'false')
    {
        $this
            ->setCallingPartyInfo($callingPartyInfo)
            ->setCalledPartyInfo($calledPartyInfo);
    }
    /**
     * Get callingPartyInfo value
     * @return string|null
     */
    public function getCallingPartyInfo()
    {
        return $this->callingPartyInfo;
    }
    /**
     * Set callingPartyInfo value
     * @param string $callingPartyInfo
     * @return \StructType\CallInfoForPickupNotification
     */
    public function setCallingPartyInfo($callingPartyInfo = 'false')
    {
        // validation for constraint: string
        if (!is_null($callingPartyInfo) && !is_string($callingPartyInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyInfo, true), gettype($callingPartyInfo)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($callingPartyInfo) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callingPartyInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($callingPartyInfo, true)), __LINE__);
        }
        $this->callingPartyInfo = $callingPartyInfo;
        return $this;
    }
    /**
     * Get calledPartyInfo value
     * @return string|null
     */
    public function getCalledPartyInfo()
    {
        return $this->calledPartyInfo;
    }
    /**
     * Set calledPartyInfo value
     * @param string $calledPartyInfo
     * @return \StructType\CallInfoForPickupNotification
     */
    public function setCalledPartyInfo($calledPartyInfo = 'false')
    {
        // validation for constraint: string
        if (!is_null($calledPartyInfo) && !is_string($calledPartyInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyInfo, true), gettype($calledPartyInfo)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($calledPartyInfo) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $calledPartyInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($calledPartyInfo, true)), __LINE__);
        }
        $this->calledPartyInfo = $calledPartyInfo;
        return $this;
    }
}
