<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedCapfProfiles StructType
 * Meta information extracted from the WSDL
 * - documentation: Read Only.The Certification Authority Proxy Function Profiles to which the application user is associated with.
 * @subpackage Structs
 */
class AssociatedCapfProfiles extends AbstractStructBase
{
    /**
     * The capfProfileInstanceId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $capfProfileInstanceId;
    /**
     * Constructor method for associatedCapfProfiles
     * @uses AssociatedCapfProfiles::setCapfProfileInstanceId()
     * @param string[] $capfProfileInstanceId
     */
    public function __construct(array $capfProfileInstanceId = array())
    {
        $this
            ->setCapfProfileInstanceId($capfProfileInstanceId);
    }
    /**
     * Get capfProfileInstanceId value
     * @return string[]|null
     */
    public function getCapfProfileInstanceId()
    {
        return $this->capfProfileInstanceId;
    }
    /**
     * This method is responsible for validating the values passed to the setCapfProfileInstanceId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCapfProfileInstanceId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCapfProfileInstanceIdForArrayConstraintsFromSetCapfProfileInstanceId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associatedCapfProfilesCapfProfileInstanceIdItem) {
            // validation for constraint: itemType
            if (!is_string($associatedCapfProfilesCapfProfileInstanceIdItem)) {
                $invalidValues[] = is_object($associatedCapfProfilesCapfProfileInstanceIdItem) ? get_class($associatedCapfProfilesCapfProfileInstanceIdItem) : sprintf('%s(%s)', gettype($associatedCapfProfilesCapfProfileInstanceIdItem), var_export($associatedCapfProfilesCapfProfileInstanceIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The capfProfileInstanceId property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCapfProfileInstanceId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCapfProfileInstanceId method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCapfProfileInstanceIdForMaxLengthConstraintFromSetCapfProfileInstanceId($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associatedCapfProfilesCapfProfileInstanceIdItem) {
            // validation for constraint: maxLength(128)
            if (mb_strlen($associatedCapfProfilesCapfProfileInstanceIdItem) > 128) {
                $invalidValues[] = var_export($associatedCapfProfilesCapfProfileInstanceIdItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 128', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set capfProfileInstanceId value
     * @throws \InvalidArgumentException
     * @param string[] $capfProfileInstanceId
     * @return \StructType\AssociatedCapfProfiles
     */
    public function setCapfProfileInstanceId(array $capfProfileInstanceId = array())
    {
        // validation for constraint: array
        if ('' !== ($capfProfileInstanceIdArrayErrorMessage = self::validateCapfProfileInstanceIdForArrayConstraintsFromSetCapfProfileInstanceId($capfProfileInstanceId))) {
            throw new \InvalidArgumentException($capfProfileInstanceIdArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(128)
        if ('' !== ($capfProfileInstanceIdMaxLengthErrorMessage = self::validateCapfProfileInstanceIdForMaxLengthConstraintFromSetCapfProfileInstanceId($capfProfileInstanceId))) {
            throw new \InvalidArgumentException($capfProfileInstanceIdMaxLengthErrorMessage, __LINE__);
        }
        $this->capfProfileInstanceId = $capfProfileInstanceId;
        return $this;
    }
    /**
     * Add item to capfProfileInstanceId value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AssociatedCapfProfiles
     */
    public function addToCapfProfileInstanceId($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The capfProfileInstanceId property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (mb_strlen($item) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($item)), __LINE__);
        }
        $this->capfProfileInstanceId[] = $item;
        return $this;
    }
}
