<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Apply ServiceType
 * @subpackage Services
 */
class Apply extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named applySipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applySipProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applySipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applySipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applySipTrunkSecurityProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applySipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyRoutePartition(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyCallManager(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyRegion(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyDevicePool(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applySoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applySoftKeyTemplate(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applySoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyTranscoder(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyCommonDeviceConfig(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApplyResourcePriorityNamespaceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyResourcePriorityNamespace(\StructType\ApplyResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyResourcePriorityNamespaceList(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyHuntList(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyCallManagerGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApplyDirectedCallParkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyDirectedCallPark(\StructType\ApplyDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyRouteList(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyDateTimeGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applySrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applySrst(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applySrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyVoiceMailProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyVoiceMailPort(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyGatekeeper(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyPhoneButtonTemplate(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyCommonPhoneConfig(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyCtiRoutePoint(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyPhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyPhoneSecurityProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyPhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyConferenceBridge(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyMtp(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApplyLineReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyLine(\StructType\ApplyLineReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyH323Phone(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyPhone(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyH323Gateway(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApplyGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyGateway(\StructType\ApplyGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * applyCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyCiscoCatalyst600024PortFXSGateway(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * applyCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyCiscoCatalyst6000E1VoIPGateway(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * applyCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyCiscoCatalyst6000T1VoIPGatewayPri(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * applyCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function applyCiscoCatalyst6000T1VoIPGatewayT1(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
