<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XLdapServer EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XLdapServer extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Microsoft Active Directory'
     * @return string 'Microsoft Active Directory'
     */
    const VALUE_MICROSOFT_ACTIVE_DIRECTORY = 'Microsoft Active Directory';
    /**
     * Constant for value 'Sun or Oracle Directory Server'
     * @return string 'Sun or Oracle Directory Server'
     */
    const VALUE_SUN_OR_ORACLE_DIRECTORY_SERVER = 'Sun or Oracle Directory Server';
    /**
     * Constant for value 'OpenLDAP'
     * @return string 'OpenLDAP'
     */
    const VALUE_OPEN_LDAP = 'OpenLDAP';
    /**
     * Constant for value 'Microsoft ADAM or Lightweight Directory Services'
     * @return string 'Microsoft ADAM or Lightweight Directory Services'
     */
    const VALUE_MICROSOFT_ADAM_OR_LIGHTWEIGHT_DIRECTORY_SERVICES = 'Microsoft ADAM or Lightweight Directory Services';
    /**
     * Return allowed values
     * @uses self::VALUE_MICROSOFT_ACTIVE_DIRECTORY
     * @uses self::VALUE_SUN_OR_ORACLE_DIRECTORY_SERVER
     * @uses self::VALUE_OPEN_LDAP
     * @uses self::VALUE_MICROSOFT_ADAM_OR_LIGHTWEIGHT_DIRECTORY_SERVICES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MICROSOFT_ACTIVE_DIRECTORY,
            self::VALUE_SUN_OR_ORACLE_DIRECTORY_SERVER,
            self::VALUE_OPEN_LDAP,
            self::VALUE_MICROSOFT_ADAM_OR_LIGHTWEIGHT_DIRECTORY_SERVICES,
        );
    }
}
