<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRoutePartition StructType
 * @subpackage Structs
 */
class XRoutePartition extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The timeScheduleIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $timeScheduleIdName;
    /**
     * The useOriginatingDeviceTimeZone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useOriginatingDeviceTimeZone;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - documentation: Only Applicable if TimeSchedule is selected. If OriginatingDevice is selected then this tag is not applicable.
     * - default: Etc/GMT
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - default: General
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $partitionUsage;
    /**
     * Constructor method for XRoutePartition
     * @uses XRoutePartition::setName()
     * @uses XRoutePartition::setDescription()
     * @uses XRoutePartition::setTimeScheduleIdName()
     * @uses XRoutePartition::setUseOriginatingDeviceTimeZone()
     * @uses XRoutePartition::setTimeZone()
     * @uses XRoutePartition::setPartitionUsage()
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $timeScheduleIdName
     * @param string $useOriginatingDeviceTimeZone
     * @param string $timeZone
     * @param string $partitionUsage
     */
    public function __construct($name = null, $description = null, \StructType\XFkType $timeScheduleIdName = null, $useOriginatingDeviceTimeZone = 'true', $timeZone = 'Etc/GMT', $partitionUsage = 'General')
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setTimeScheduleIdName($timeScheduleIdName)
            ->setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone)
            ->setTimeZone($timeZone)
            ->setPartitionUsage($partitionUsage);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XRoutePartition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XRoutePartition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get timeScheduleIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getTimeScheduleIdName()
    {
        return isset($this->timeScheduleIdName) ? $this->timeScheduleIdName : null;
    }
    /**
     * Set timeScheduleIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $timeScheduleIdName
     * @return \StructType\XRoutePartition
     */
    public function setTimeScheduleIdName(\StructType\XFkType $timeScheduleIdName = null)
    {
        if (is_null($timeScheduleIdName) || (is_array($timeScheduleIdName) && empty($timeScheduleIdName))) {
            unset($this->timeScheduleIdName);
        } else {
            $this->timeScheduleIdName = $timeScheduleIdName;
        }
        return $this;
    }
    /**
     * Get useOriginatingDeviceTimeZone value
     * @return string|null
     */
    public function getUseOriginatingDeviceTimeZone()
    {
        return $this->useOriginatingDeviceTimeZone;
    }
    /**
     * Set useOriginatingDeviceTimeZone value
     * @param string $useOriginatingDeviceTimeZone
     * @return \StructType\XRoutePartition
     */
    public function setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone = 'true')
    {
        // validation for constraint: string
        if (!is_null($useOriginatingDeviceTimeZone) && !is_string($useOriginatingDeviceTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useOriginatingDeviceTimeZone, true), gettype($useOriginatingDeviceTimeZone)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useOriginatingDeviceTimeZone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useOriginatingDeviceTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useOriginatingDeviceTimeZone, true)), __LINE__);
        }
        $this->useOriginatingDeviceTimeZone = $useOriginatingDeviceTimeZone;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \EnumType\XTimeZone::valueIsValid()
     * @uses \EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \StructType\XRoutePartition
     */
    public function setTimeZone($timeZone = 'Etc/GMT')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTimeZone', is_array($timeZone) ? implode(', ', $timeZone) : var_export($timeZone, true), implode(', ', \EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses \EnumType\XPartitionUsage::valueIsValid()
     * @uses \EnumType\XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return \StructType\XRoutePartition
     */
    public function setPartitionUsage($partitionUsage = 'General')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPartitionUsage', is_array($partitionUsage) ? implode(', ', $partitionUsage) : var_export($partitionUsage, true), implode(', ', \EnumType\XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
}
