<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRouteGroupMember StructType
 * @subpackage Structs
 */
class XRouteGroupMember extends AbstractStructBase
{
    /**
     * The deviceSelectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $deviceSelectionOrder;
    /**
     * The deviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XFkType
     */
    public $deviceName;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $port;
    /**
     * Constructor method for XRouteGroupMember
     * @uses XRouteGroupMember::setDeviceSelectionOrder()
     * @uses XRouteGroupMember::setDeviceName()
     * @uses XRouteGroupMember::setPort()
     * @param string $deviceSelectionOrder
     * @param \StructType\XFkType $deviceName
     * @param string $port
     */
    public function __construct($deviceSelectionOrder = null, \StructType\XFkType $deviceName = null, $port = null)
    {
        $this
            ->setDeviceSelectionOrder($deviceSelectionOrder)
            ->setDeviceName($deviceName)
            ->setPort($port);
    }
    /**
     * Get deviceSelectionOrder value
     * @return string
     */
    public function getDeviceSelectionOrder()
    {
        return $this->deviceSelectionOrder;
    }
    /**
     * Set deviceSelectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSelectionOrder
     * @return \StructType\XRouteGroupMember
     */
    public function setDeviceSelectionOrder($deviceSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($deviceSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($deviceSelectionOrder) ? implode(', ', $deviceSelectionOrder) : var_export($deviceSelectionOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->deviceSelectionOrder = $deviceSelectionOrder;
        return $this;
    }
    /**
     * Get deviceName value
     * @return \StructType\XFkType
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param \StructType\XFkType $deviceName
     * @return \StructType\XRouteGroupMember
     */
    public function setDeviceName(\StructType\XFkType $deviceName = null)
    {
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get port value
     * @return string
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\XRouteGroupMember
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
}
