<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLineAppearanceAssociationForPresence StructType
 * @subpackage Structs
 */
class XLineAppearanceAssociationForPresence extends AbstractStructBase
{
    /**
     * The laapAssociate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $laapAssociate;
    /**
     * The laapProductType
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $laapProductType;
    /**
     * The laapDeviceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $laapDeviceName;
    /**
     * The laapDirectory
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $laapDirectory;
    /**
     * The laapPartition
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $laapPartition;
    /**
     * The laapDescription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $laapDescription;
    /**
     * Constructor method for XLineAppearanceAssociationForPresence
     * @uses XLineAppearanceAssociationForPresence::setLaapAssociate()
     * @uses XLineAppearanceAssociationForPresence::setLaapProductType()
     * @uses XLineAppearanceAssociationForPresence::setLaapDeviceName()
     * @uses XLineAppearanceAssociationForPresence::setLaapDirectory()
     * @uses XLineAppearanceAssociationForPresence::setLaapPartition()
     * @uses XLineAppearanceAssociationForPresence::setLaapDescription()
     * @param \StructType\XFkType $laapAssociate
     * @param string $laapProductType
     * @param string $laapDeviceName
     * @param string $laapDirectory
     * @param string $laapPartition
     * @param string $laapDescription
     */
    public function __construct(\StructType\XFkType $laapAssociate = null, $laapProductType = null, $laapDeviceName = null, $laapDirectory = null, $laapPartition = null, $laapDescription = null)
    {
        $this
            ->setLaapAssociate($laapAssociate)
            ->setLaapProductType($laapProductType)
            ->setLaapDeviceName($laapDeviceName)
            ->setLaapDirectory($laapDirectory)
            ->setLaapPartition($laapPartition)
            ->setLaapDescription($laapDescription);
    }
    /**
     * Get laapAssociate value
     * @return \StructType\XFkType|null
     */
    public function getLaapAssociate()
    {
        return $this->laapAssociate;
    }
    /**
     * Set laapAssociate value
     * @param \StructType\XFkType $laapAssociate
     * @return \StructType\XLineAppearanceAssociationForPresence
     */
    public function setLaapAssociate(\StructType\XFkType $laapAssociate = null)
    {
        $this->laapAssociate = $laapAssociate;
        return $this;
    }
    /**
     * Get laapProductType value
     * @return string|null
     */
    public function getLaapProductType()
    {
        return $this->laapProductType;
    }
    /**
     * Set laapProductType value
     * @param string $laapProductType
     * @return \StructType\XLineAppearanceAssociationForPresence
     */
    public function setLaapProductType($laapProductType = null)
    {
        // validation for constraint: string
        if (!is_null($laapProductType) && !is_string($laapProductType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($laapProductType, true), gettype($laapProductType)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($laapProductType) && mb_strlen($laapProductType) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($laapProductType)), __LINE__);
        }
        $this->laapProductType = $laapProductType;
        return $this;
    }
    /**
     * Get laapDeviceName value
     * @return string|null
     */
    public function getLaapDeviceName()
    {
        return $this->laapDeviceName;
    }
    /**
     * Set laapDeviceName value
     * @param string $laapDeviceName
     * @return \StructType\XLineAppearanceAssociationForPresence
     */
    public function setLaapDeviceName($laapDeviceName = null)
    {
        // validation for constraint: string
        if (!is_null($laapDeviceName) && !is_string($laapDeviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($laapDeviceName, true), gettype($laapDeviceName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($laapDeviceName) && mb_strlen($laapDeviceName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($laapDeviceName)), __LINE__);
        }
        $this->laapDeviceName = $laapDeviceName;
        return $this;
    }
    /**
     * Get laapDirectory value
     * @return string|null
     */
    public function getLaapDirectory()
    {
        return $this->laapDirectory;
    }
    /**
     * Set laapDirectory value
     * @param string $laapDirectory
     * @return \StructType\XLineAppearanceAssociationForPresence
     */
    public function setLaapDirectory($laapDirectory = null)
    {
        // validation for constraint: string
        if (!is_null($laapDirectory) && !is_string($laapDirectory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($laapDirectory, true), gettype($laapDirectory)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($laapDirectory) && mb_strlen($laapDirectory) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($laapDirectory)), __LINE__);
        }
        $this->laapDirectory = $laapDirectory;
        return $this;
    }
    /**
     * Get laapPartition value
     * @return string|null
     */
    public function getLaapPartition()
    {
        return $this->laapPartition;
    }
    /**
     * Set laapPartition value
     * @param string $laapPartition
     * @return \StructType\XLineAppearanceAssociationForPresence
     */
    public function setLaapPartition($laapPartition = null)
    {
        // validation for constraint: string
        if (!is_null($laapPartition) && !is_string($laapPartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($laapPartition, true), gettype($laapPartition)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($laapPartition) && mb_strlen($laapPartition) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($laapPartition)), __LINE__);
        }
        $this->laapPartition = $laapPartition;
        return $this;
    }
    /**
     * Get laapDescription value
     * @return string|null
     */
    public function getLaapDescription()
    {
        return $this->laapDescription;
    }
    /**
     * Set laapDescription value
     * @param string $laapDescription
     * @return \StructType\XLineAppearanceAssociationForPresence
     */
    public function setLaapDescription($laapDescription = null)
    {
        // validation for constraint: string
        if (!is_null($laapDescription) && !is_string($laapDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($laapDescription, true), gettype($laapDescription)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($laapDescription) && mb_strlen($laapDescription) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($laapDescription)), __LINE__);
        }
        $this->laapDescription = $laapDescription;
        return $this;
    }
}
