<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLdapSystem StructType
 * @subpackage Structs
 */
class XLdapSystem extends AbstractStructBase
{
    /**
     * The syncEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $syncEnabled;
    /**
     * The ldapServer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ldapServer;
    /**
     * The userIdAttribute
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userIdAttribute;
    /**
     * Constructor method for XLdapSystem
     * @uses XLdapSystem::setSyncEnabled()
     * @uses XLdapSystem::setLdapServer()
     * @uses XLdapSystem::setUserIdAttribute()
     * @param string $syncEnabled
     * @param string $ldapServer
     * @param string $userIdAttribute
     */
    public function __construct($syncEnabled = null, $ldapServer = null, $userIdAttribute = null)
    {
        $this
            ->setSyncEnabled($syncEnabled)
            ->setLdapServer($ldapServer)
            ->setUserIdAttribute($userIdAttribute);
    }
    /**
     * Get syncEnabled value
     * @return string|null
     */
    public function getSyncEnabled()
    {
        return $this->syncEnabled;
    }
    /**
     * Set syncEnabled value
     * @param string $syncEnabled
     * @return \StructType\XLdapSystem
     */
    public function setSyncEnabled($syncEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($syncEnabled) && !is_string($syncEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syncEnabled, true), gettype($syncEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($syncEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $syncEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($syncEnabled, true)), __LINE__);
        }
        $this->syncEnabled = $syncEnabled;
        return $this;
    }
    /**
     * Get ldapServer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLdapServer()
    {
        return isset($this->ldapServer) ? $this->ldapServer : null;
    }
    /**
     * Set ldapServer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XLdapServer::valueIsValid()
     * @uses \EnumType\XLdapServer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ldapServer
     * @return \StructType\XLdapSystem
     */
    public function setLdapServer($ldapServer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XLdapServer::valueIsValid($ldapServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XLdapServer', is_array($ldapServer) ? implode(', ', $ldapServer) : var_export($ldapServer, true), implode(', ', \EnumType\XLdapServer::getValidValues())), __LINE__);
        }
        if (is_null($ldapServer) || (is_array($ldapServer) && empty($ldapServer))) {
            unset($this->ldapServer);
        } else {
            $this->ldapServer = $ldapServer;
        }
        return $this;
    }
    /**
     * Get userIdAttribute value
     * @return string|null
     */
    public function getUserIdAttribute()
    {
        return $this->userIdAttribute;
    }
    /**
     * Set userIdAttribute value
     * @param string $userIdAttribute
     * @return \StructType\XLdapSystem
     */
    public function setUserIdAttribute($userIdAttribute = null)
    {
        // validation for constraint: string
        if (!is_null($userIdAttribute) && !is_string($userIdAttribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userIdAttribute, true), gettype($userIdAttribute)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($userIdAttribute) && mb_strlen($userIdAttribute) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($userIdAttribute)), __LINE__);
        }
        $this->userIdAttribute = $userIdAttribute;
        return $this;
    }
}
