<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XHuntList StructType
 * @subpackage Structs
 */
class XHuntList extends AbstractStructBase
{
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The routeListEnabled
     * Meta information extracted from the WSDL
     * - documentation: From Device table.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeListEnabled;
    /**
     * The voiceMailUsage
     * Meta information extracted from the WSDL
     * - documentation: From Device table.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $voiceMailUsage;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * Constructor method for XHuntList
     * @uses XHuntList::setCallManagerGroupName()
     * @uses XHuntList::setName()
     * @uses XHuntList::setDescription()
     * @uses XHuntList::setRouteListEnabled()
     * @uses XHuntList::setVoiceMailUsage()
     * @uses XHuntList::setMembers()
     * @param \StructType\XFkType $callManagerGroupName
     * @param string $name
     * @param string $description
     * @param string $routeListEnabled
     * @param string $voiceMailUsage
     * @param \StructType\Members $members
     */
    public function __construct(\StructType\XFkType $callManagerGroupName = null, $name = null, $description = null, $routeListEnabled = 'false', $voiceMailUsage = 'false', \StructType\Members $members = null)
    {
        $this
            ->setCallManagerGroupName($callManagerGroupName)
            ->setName($name)
            ->setDescription($description)
            ->setRouteListEnabled($routeListEnabled)
            ->setVoiceMailUsage($voiceMailUsage)
            ->setMembers($members);
    }
    /**
     * Get callManagerGroupName value
     * @return \StructType\XFkType
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \StructType\XFkType $callManagerGroupName
     * @return \StructType\XHuntList
     */
    public function setCallManagerGroupName(\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XHuntList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XHuntList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get routeListEnabled value
     * @return string|null
     */
    public function getRouteListEnabled()
    {
        return $this->routeListEnabled;
    }
    /**
     * Set routeListEnabled value
     * @param string $routeListEnabled
     * @return \StructType\XHuntList
     */
    public function setRouteListEnabled($routeListEnabled = 'false')
    {
        // validation for constraint: string
        if (!is_null($routeListEnabled) && !is_string($routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeListEnabled, true), gettype($routeListEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($routeListEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($routeListEnabled, true)), __LINE__);
        }
        $this->routeListEnabled = $routeListEnabled;
        return $this;
    }
    /**
     * Get voiceMailUsage value
     * @return string|null
     */
    public function getVoiceMailUsage()
    {
        return $this->voiceMailUsage;
    }
    /**
     * Set voiceMailUsage value
     * @param string $voiceMailUsage
     * @return \StructType\XHuntList
     */
    public function setVoiceMailUsage($voiceMailUsage = 'false')
    {
        // validation for constraint: string
        if (!is_null($voiceMailUsage) && !is_string($voiceMailUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voiceMailUsage, true), gettype($voiceMailUsage)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($voiceMailUsage) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $voiceMailUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($voiceMailUsage, true)), __LINE__);
        }
        $this->voiceMailUsage = $voiceMailUsage;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\XHuntList
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
}
