<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDateTimeGroupNtpReference StructType
 * @subpackage Structs
 */
class XDateTimeGroupNtpReference extends AbstractStructBase
{
    /**
     * The phoneNtpName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XFkType
     */
    public $phoneNtpName;
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $selectionOrder;
    /**
     * Constructor method for XDateTimeGroupNtpReference
     * @uses XDateTimeGroupNtpReference::setPhoneNtpName()
     * @uses XDateTimeGroupNtpReference::setSelectionOrder()
     * @param \StructType\XFkType $phoneNtpName
     * @param string $selectionOrder
     */
    public function __construct(\StructType\XFkType $phoneNtpName = null, $selectionOrder = '0')
    {
        $this
            ->setPhoneNtpName($phoneNtpName)
            ->setSelectionOrder($selectionOrder);
    }
    /**
     * Get phoneNtpName value
     * @return \StructType\XFkType
     */
    public function getPhoneNtpName()
    {
        return $this->phoneNtpName;
    }
    /**
     * Set phoneNtpName value
     * @param \StructType\XFkType $phoneNtpName
     * @return \StructType\XDateTimeGroupNtpReference
     */
    public function setPhoneNtpName(\StructType\XFkType $phoneNtpName = null)
    {
        $this->phoneNtpName = $phoneNtpName;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \StructType\XDateTimeGroupNtpReference
     */
    public function setSelectionOrder($selectionOrder = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($selectionOrder) ? implode(', ', $selectionOrder) : var_export($selectionOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
}
