<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XButton StructType
 * @subpackage Structs
 */
class XButton extends AbstractStructBase
{
    /**
     * The feature
     * Meta information extracted from the WSDL
     * - documentation: The feature invoked by this button.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $feature;
    /**
     * The buttonNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $buttonNumber;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - documentation: The label invoked by this button.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * Constructor method for XButton
     * @uses XButton::setFeature()
     * @uses XButton::setButtonNumber()
     * @uses XButton::setLabel()
     * @param string $feature
     * @param string $buttonNumber
     * @param string $label
     */
    public function __construct($feature = null, $buttonNumber = null, $label = null)
    {
        $this
            ->setFeature($feature)
            ->setButtonNumber($buttonNumber)
            ->setLabel($label);
    }
    /**
     * Get feature value
     * @return string
     */
    public function getFeature()
    {
        return $this->feature;
    }
    /**
     * Set feature value
     * @uses \EnumType\XFeature::valueIsValid()
     * @uses \EnumType\XFeature::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $feature
     * @return \StructType\XButton
     */
    public function setFeature($feature = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XFeature::valueIsValid($feature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XFeature', is_array($feature) ? implode(', ', $feature) : var_export($feature, true), implode(', ', \EnumType\XFeature::getValidValues())), __LINE__);
        }
        $this->feature = $feature;
        return $this;
    }
    /**
     * Get buttonNumber value
     * @return string
     */
    public function getButtonNumber()
    {
        return $this->buttonNumber;
    }
    /**
     * Set buttonNumber value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $buttonNumber
     * @return \StructType\XButton
     */
    public function setButtonNumber($buttonNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($buttonNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($buttonNumber) ? implode(', ', $buttonNumber) : var_export($buttonNumber, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->buttonNumber = $buttonNumber;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\XButton
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($label) && mb_strlen($label) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
}
