<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XBusyLampField StructType
 * @subpackage Structs
 */
class XBusyLampField extends AbstractStructBase
{
    /**
     * The blfDest
     * Meta information extracted from the WSDL
     * - documentation: Either blfDest or the combination of blfDirn and routePartition is to be mentioned in the add/update request, if both are mentioned AXL will read only the blfDest tag and ignore blfDirn and routePartition.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $blfDest;
    /**
     * The blfDirn
     * Meta information extracted from the WSDL
     * - documentation: Either blfDest or the combination of blfDirn and routePartition is to be mentioned in the add/update request, if both are mentioned AXL will read only the blfDest tag and ignore blfDirn and routePartition.
     * - base: xsd:string
     * - choice: blfDirn | routePartition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $blfDirn;
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $index;
    /**
     * The routePartition
     * Meta information extracted from the WSDL
     * - choice: blfDirn | routePartition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routePartition;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The associatedBlfSdFeatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedBlfSdFeatures
     */
    public $associatedBlfSdFeatures;
    /**
     * Constructor method for XBusyLampField
     * @uses XBusyLampField::setBlfDest()
     * @uses XBusyLampField::setBlfDirn()
     * @uses XBusyLampField::setIndex()
     * @uses XBusyLampField::setRoutePartition()
     * @uses XBusyLampField::setLabel()
     * @uses XBusyLampField::setAssociatedBlfSdFeatures()
     * @param string $blfDest
     * @param string $blfDirn
     * @param string $index
     * @param string $routePartition
     * @param string $label
     * @param \StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures
     */
    public function __construct($blfDest = null, $blfDirn = null, $index = null, $routePartition = null, $label = null, \StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures = null)
    {
        $this
            ->setBlfDest($blfDest)
            ->setBlfDirn($blfDirn)
            ->setIndex($index)
            ->setRoutePartition($routePartition)
            ->setLabel($label)
            ->setAssociatedBlfSdFeatures($associatedBlfSdFeatures);
    }
    /**
     * Get blfDest value
     * @return string
     */
    public function getBlfDest()
    {
        return $this->blfDest;
    }
    /**
     * Set blfDest value
     * @param string $blfDest
     * @return \StructType\XBusyLampField
     */
    public function setBlfDest($blfDest = null)
    {
        // validation for constraint: string
        if (!is_null($blfDest) && !is_string($blfDest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blfDest, true), gettype($blfDest)), __LINE__);
        }
        $this->blfDest = $blfDest;
        return $this;
    }
    /**
     * Get blfDirn value
     * @return string
     */
    public function getBlfDirn()
    {
        return isset($this->blfDirn) ? $this->blfDirn : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBlfDirn method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBlfDirn method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBlfDirnForChoiceConstraintsFromSetBlfDirn($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'routePartition',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property blfDirn can\'t be set as the property %s is already set. Only one property must be set among these properties: blfDirn, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set blfDirn value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $blfDirn
     * @return \StructType\XBusyLampField
     */
    public function setBlfDirn($blfDirn = null)
    {
        // validation for constraint: string
        if (!is_null($blfDirn) && !is_string($blfDirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blfDirn, true), gettype($blfDirn)), __LINE__);
        }
        // validation for constraint: choice(blfDirn, routePartition)
        if ('' !== ($blfDirnChoiceErrorMessage = self::validateBlfDirnForChoiceConstraintsFromSetBlfDirn($blfDirn))) {
            throw new \InvalidArgumentException($blfDirnChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($blfDirn) && mb_strlen($blfDirn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($blfDirn)), __LINE__);
        }
        if (is_null($blfDirn) || (is_array($blfDirn) && empty($blfDirn))) {
            unset($this->blfDirn);
        } else {
            $this->blfDirn = $blfDirn;
        }
        return $this;
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\XBusyLampField
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($index) ? implode(', ', $index) : var_export($index, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get routePartition value
     * @return string|null
     */
    public function getRoutePartition()
    {
        return isset($this->routePartition) ? $this->routePartition : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRoutePartition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoutePartition method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRoutePartitionForChoiceConstraintsFromSetRoutePartition($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'blfDirn',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property routePartition can\'t be set as the property %s is already set. Only one property must be set among these properties: routePartition, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set routePartition value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $routePartition
     * @return \StructType\XBusyLampField
     */
    public function setRoutePartition($routePartition = null)
    {
        // validation for constraint: string
        if (!is_null($routePartition) && !is_string($routePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routePartition, true), gettype($routePartition)), __LINE__);
        }
        // validation for constraint: choice(blfDirn, routePartition)
        if ('' !== ($routePartitionChoiceErrorMessage = self::validateRoutePartitionForChoiceConstraintsFromSetRoutePartition($routePartition))) {
            throw new \InvalidArgumentException($routePartitionChoiceErrorMessage, __LINE__);
        }
        if (is_null($routePartition) || (is_array($routePartition) && empty($routePartition))) {
            unset($this->routePartition);
        } else {
            $this->routePartition = $routePartition;
        }
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\XBusyLampField
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get associatedBlfSdFeatures value
     * @return \StructType\AssociatedBlfSdFeatures|null
     */
    public function getAssociatedBlfSdFeatures()
    {
        return $this->associatedBlfSdFeatures;
    }
    /**
     * Set associatedBlfSdFeatures value
     * @param \StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures
     * @return \StructType\XBusyLampField
     */
    public function setAssociatedBlfSdFeatures(\StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures = null)
    {
        $this->associatedBlfSdFeatures = $associatedBlfSdFeatures;
        return $this;
    }
}
