<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVpnProfileReq StructType
 * @subpackage Structs
 */
class UpdateVpnProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The autoNetworkDetection
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $autoNetworkDetection;
    /**
     * The mtu
     * Meta information extracted from the WSDL
     * - default: 1290
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mtu;
    /**
     * The failToConnect
     * Meta information extracted from the WSDL
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $failToConnect;
    /**
     * The clientAuthentication
     * Meta information extracted from the WSDL
     * - default: User and Password
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $clientAuthentication;
    /**
     * The pwdPersistant
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdPersistant;
    /**
     * The enableHostIdCheck
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableHostIdCheck;
    /**
     * Constructor method for UpdateVpnProfileReq
     * @uses UpdateVpnProfileReq::setNewName()
     * @uses UpdateVpnProfileReq::setDescription()
     * @uses UpdateVpnProfileReq::setAutoNetworkDetection()
     * @uses UpdateVpnProfileReq::setMtu()
     * @uses UpdateVpnProfileReq::setFailToConnect()
     * @uses UpdateVpnProfileReq::setClientAuthentication()
     * @uses UpdateVpnProfileReq::setPwdPersistant()
     * @uses UpdateVpnProfileReq::setEnableHostIdCheck()
     * @param string $newName
     * @param string $description
     * @param string $autoNetworkDetection
     * @param string $mtu
     * @param string $failToConnect
     * @param string $clientAuthentication
     * @param string $pwdPersistant
     * @param string $enableHostIdCheck
     */
    public function __construct($newName = null, $description = null, $autoNetworkDetection = null, $mtu = '1290', $failToConnect = '30', $clientAuthentication = 'User and Password', $pwdPersistant = null, $enableHostIdCheck = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setAutoNetworkDetection($autoNetworkDetection)
            ->setMtu($mtu)
            ->setFailToConnect($failToConnect)
            ->setClientAuthentication($clientAuthentication)
            ->setPwdPersistant($pwdPersistant)
            ->setEnableHostIdCheck($enableHostIdCheck);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get autoNetworkDetection value
     * @return string|null
     */
    public function getAutoNetworkDetection()
    {
        return $this->autoNetworkDetection;
    }
    /**
     * Set autoNetworkDetection value
     * @param string $autoNetworkDetection
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setAutoNetworkDetection($autoNetworkDetection = null)
    {
        // validation for constraint: string
        if (!is_null($autoNetworkDetection) && !is_string($autoNetworkDetection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoNetworkDetection, true), gettype($autoNetworkDetection)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($autoNetworkDetection) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $autoNetworkDetection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($autoNetworkDetection, true)), __LINE__);
        }
        $this->autoNetworkDetection = $autoNetworkDetection;
        return $this;
    }
    /**
     * Get mtu value
     * @return string|null
     */
    public function getMtu()
    {
        return $this->mtu;
    }
    /**
     * Set mtu value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtu
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setMtu($mtu = '1290')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($mtu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($mtu) ? implode(', ', $mtu) : var_export($mtu, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->mtu = $mtu;
        return $this;
    }
    /**
     * Get failToConnect value
     * @return string|null
     */
    public function getFailToConnect()
    {
        return $this->failToConnect;
    }
    /**
     * Set failToConnect value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failToConnect
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setFailToConnect($failToConnect = '30')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($failToConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($failToConnect) ? implode(', ', $failToConnect) : var_export($failToConnect, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->failToConnect = $failToConnect;
        return $this;
    }
    /**
     * Get clientAuthentication value
     * @return string|null
     */
    public function getClientAuthentication()
    {
        return $this->clientAuthentication;
    }
    /**
     * Set clientAuthentication value
     * @uses \EnumType\XVPNClientAuthentication::valueIsValid()
     * @uses \EnumType\XVPNClientAuthentication::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientAuthentication
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setClientAuthentication($clientAuthentication = 'User and Password')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XVPNClientAuthentication::valueIsValid($clientAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XVPNClientAuthentication', is_array($clientAuthentication) ? implode(', ', $clientAuthentication) : var_export($clientAuthentication, true), implode(', ', \EnumType\XVPNClientAuthentication::getValidValues())), __LINE__);
        }
        $this->clientAuthentication = $clientAuthentication;
        return $this;
    }
    /**
     * Get pwdPersistant value
     * @return string|null
     */
    public function getPwdPersistant()
    {
        return $this->pwdPersistant;
    }
    /**
     * Set pwdPersistant value
     * @param string $pwdPersistant
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setPwdPersistant($pwdPersistant = null)
    {
        // validation for constraint: string
        if (!is_null($pwdPersistant) && !is_string($pwdPersistant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwdPersistant, true), gettype($pwdPersistant)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pwdPersistant) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdPersistant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pwdPersistant, true)), __LINE__);
        }
        $this->pwdPersistant = $pwdPersistant;
        return $this;
    }
    /**
     * Get enableHostIdCheck value
     * @return string|null
     */
    public function getEnableHostIdCheck()
    {
        return $this->enableHostIdCheck;
    }
    /**
     * Set enableHostIdCheck value
     * @param string $enableHostIdCheck
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setEnableHostIdCheck($enableHostIdCheck = null)
    {
        // validation for constraint: string
        if (!is_null($enableHostIdCheck) && !is_string($enableHostIdCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableHostIdCheck, true), gettype($enableHostIdCheck)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableHostIdCheck) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableHostIdCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableHostIdCheck, true)), __LINE__);
        }
        $this->enableHostIdCheck = $enableHostIdCheck;
        return $this;
    }
}
