<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVpnGroupReq StructType
 * @subpackage Structs
 */
class UpdateVpnGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The vpnGateways
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VpnGateways
     */
    public $vpnGateways;
    /**
     * Constructor method for UpdateVpnGroupReq
     * @uses UpdateVpnGroupReq::setNewName()
     * @uses UpdateVpnGroupReq::setDescription()
     * @uses UpdateVpnGroupReq::setVpnGateways()
     * @param string $newName
     * @param string $description
     * @param \StructType\VpnGateways $vpnGateways
     */
    public function __construct($newName = null, $description = null, \StructType\VpnGateways $vpnGateways = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setVpnGateways($vpnGateways);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateVpnGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateVpnGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get vpnGateways value
     * @return \StructType\VpnGateways|null
     */
    public function getVpnGateways()
    {
        return $this->vpnGateways;
    }
    /**
     * Set vpnGateways value
     * @param \StructType\VpnGateways $vpnGateways
     * @return \StructType\UpdateVpnGroupReq
     */
    public function setVpnGateways(\StructType\VpnGateways $vpnGateways = null)
    {
        $this->vpnGateways = $vpnGateways;
        return $this;
    }
}
