<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVoiceMailPilotReq StructType
 * @subpackage Structs
 */
class UpdateVoiceMailPilotReq extends APIRequest
{
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | dirn | cssName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $dirn;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | dirn | cssName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The cssName
     * Meta information extracted from the WSDL
     * - choice: uuid | dirn | cssName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cssName;
    /**
     * The newDirn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $newDirn;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $newCssName;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - documentation: In Update setting isDefault tag as false would not disable this VoiceMailPilot as Default. Instead, the corresponding tag of another VoiceMailPilot should be set to true.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * Constructor method for UpdateVoiceMailPilotReq
     * @uses UpdateVoiceMailPilotReq::setDirn()
     * @uses UpdateVoiceMailPilotReq::setUuid()
     * @uses UpdateVoiceMailPilotReq::setCssName()
     * @uses UpdateVoiceMailPilotReq::setNewDirn()
     * @uses UpdateVoiceMailPilotReq::setDescription()
     * @uses UpdateVoiceMailPilotReq::setNewCssName()
     * @uses UpdateVoiceMailPilotReq::setIsDefault()
     * @param string $dirn
     * @param string $uuid
     * @param \StructType\XFkType $cssName
     * @param string $newDirn
     * @param string $description
     * @param \StructType\XFkType $newCssName
     * @param string $isDefault
     */
    public function __construct($dirn = null, $uuid = null, \StructType\XFkType $cssName = null, $newDirn = null, $description = null, \StructType\XFkType $newCssName = null, $isDefault = null)
    {
        $this
            ->setDirn($dirn)
            ->setUuid($uuid)
            ->setCssName($cssName)
            ->setNewDirn($newDirn)
            ->setDescription($description)
            ->setNewCssName($newCssName)
            ->setIsDefault($isDefault);
    }
    /**
     * Get dirn value
     * @return string
     */
    public function getDirn()
    {
        return isset($this->dirn) ? $this->dirn : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDirn method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirn method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDirnForChoiceConstraintsFromSetDirn($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'cssName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property dirn can\'t be set as the property %s is already set. Only one property must be set among these properties: dirn, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set dirn value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $dirn
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dirn, true), gettype($dirn)), __LINE__);
        }
        // validation for constraint: choice(uuid, dirn, cssName)
        if ('' !== ($dirnChoiceErrorMessage = self::validateDirnForChoiceConstraintsFromSetDirn($dirn))) {
            throw new \InvalidArgumentException($dirnChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($dirn) && mb_strlen($dirn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($dirn)), __LINE__);
        }
        if (is_null($dirn) || (is_array($dirn) && empty($dirn))) {
            unset($this->dirn);
        } else {
            $this->dirn = $dirn;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'dirn',
            'cssName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, dirn, cssName)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get cssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCssName()
    {
        return isset($this->cssName) ? $this->cssName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCssName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCssName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCssNameForChoiceConstraintsFromSetCssName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'dirn',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property cssName can\'t be set as the property %s is already set. Only one property must be set among these properties: cssName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set cssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\XFkType $cssName
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setCssName(\StructType\XFkType $cssName = null)
    {
        // validation for constraint: choice(uuid, dirn, cssName)
        if ('' !== ($cssNameChoiceErrorMessage = self::validateCssNameForChoiceConstraintsFromSetCssName($cssName))) {
            throw new \InvalidArgumentException($cssNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($cssName) || (is_array($cssName) && empty($cssName))) {
            unset($this->cssName);
        } else {
            $this->cssName = $cssName;
        }
        return $this;
    }
    /**
     * Get newDirn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewDirn()
    {
        return isset($this->newDirn) ? $this->newDirn : null;
    }
    /**
     * Set newDirn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newDirn
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setNewDirn($newDirn = null)
    {
        // validation for constraint: string
        if (!is_null($newDirn) && !is_string($newDirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newDirn, true), gettype($newDirn)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($newDirn) && mb_strlen($newDirn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($newDirn)), __LINE__);
        }
        if (is_null($newDirn) || (is_array($newDirn) && empty($newDirn))) {
            unset($this->newDirn);
        } else {
            $this->newDirn = $newDirn;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getNewCssName()
    {
        return isset($this->newCssName) ? $this->newCssName : null;
    }
    /**
     * Set newCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $newCssName
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setNewCssName(\StructType\XFkType $newCssName = null)
    {
        if (is_null($newCssName) || (is_array($newCssName) && empty($newCssName))) {
            unset($this->newCssName);
        } else {
            $this->newCssName = $newCssName;
        }
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isDefault, true)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
}
