<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUserGroupReq StructType
 * @subpackage Structs
 */
class UpdateUserGroupReq extends NameAndGUIDRequest
{
    /**
     * The removeMembers
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The removeUserRoles
     * Meta information extracted from the WSDL
     * - choice: removeUserRoles | addUserRoles | userRoles
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveUserRoles
     */
    public $removeUserRoles;
    /**
     * The addUserRoles
     * Meta information extracted from the WSDL
     * - choice: removeUserRoles | addUserRoles | userRoles
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddUserRoles
     */
    public $addUserRoles;
    /**
     * The userRoles
     * Meta information extracted from the WSDL
     * - choice: removeUserRoles | addUserRoles | userRoles
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UserRoles
     */
    public $userRoles;
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * Constructor method for UpdateUserGroupReq
     * @uses UpdateUserGroupReq::setRemoveMembers()
     * @uses UpdateUserGroupReq::setAddMembers()
     * @uses UpdateUserGroupReq::setMembers()
     * @uses UpdateUserGroupReq::setRemoveUserRoles()
     * @uses UpdateUserGroupReq::setAddUserRoles()
     * @uses UpdateUserGroupReq::setUserRoles()
     * @uses UpdateUserGroupReq::setNewName()
     * @param \StructType\RemoveMembers $removeMembers
     * @param \StructType\AddMembers $addMembers
     * @param \StructType\Members $members
     * @param \StructType\RemoveUserRoles $removeUserRoles
     * @param \StructType\AddUserRoles $addUserRoles
     * @param \StructType\UserRoles $userRoles
     * @param string $newName
     */
    public function __construct(\StructType\RemoveMembers $removeMembers = null, \StructType\AddMembers $addMembers = null, \StructType\Members $members = null, \StructType\RemoveUserRoles $removeUserRoles = null, \StructType\AddUserRoles $addUserRoles = null, \StructType\UserRoles $userRoles = null, $newName = null)
    {
        $this
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setRemoveUserRoles($removeUserRoles)
            ->setAddUserRoles($addUserRoles)
            ->setUserRoles($userRoles)
            ->setNewName($newName);
    }
    /**
     * Get removeMembers value
     * @return \StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return isset($this->removeMembers) ? $this->removeMembers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveMembersForChoiceConstraintsFromSetRemoveMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addMembers',
            'members',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeMembers can\'t be set as the property %s is already set. Only one property must be set among these properties: removeMembers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeMembers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RemoveMembers $removeMembers
     * @return \StructType\UpdateUserGroupReq
     */
    public function setRemoveMembers(\StructType\RemoveMembers $removeMembers = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($removeMembersChoiceErrorMessage = self::validateRemoveMembersForChoiceConstraintsFromSetRemoveMembers($removeMembers))) {
            throw new \InvalidArgumentException($removeMembersChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeMembers) || (is_array($removeMembers) && empty($removeMembers))) {
            unset($this->removeMembers);
        } else {
            $this->removeMembers = $removeMembers;
        }
        return $this;
    }
    /**
     * Get addMembers value
     * @return \StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return isset($this->addMembers) ? $this->addMembers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddMembersForChoiceConstraintsFromSetAddMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeMembers',
            'members',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addMembers can\'t be set as the property %s is already set. Only one property must be set among these properties: addMembers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addMembers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AddMembers $addMembers
     * @return \StructType\UpdateUserGroupReq
     */
    public function setAddMembers(\StructType\AddMembers $addMembers = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($addMembersChoiceErrorMessage = self::validateAddMembersForChoiceConstraintsFromSetAddMembers($addMembers))) {
            throw new \InvalidArgumentException($addMembersChoiceErrorMessage, __LINE__);
        }
        if (is_null($addMembers) || (is_array($addMembers) && empty($addMembers))) {
            unset($this->addMembers);
        } else {
            $this->addMembers = $addMembers;
        }
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return isset($this->members) ? $this->members : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMembersForChoiceConstraintsFromSetMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeMembers',
            'addMembers',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property members can\'t be set as the property %s is already set. Only one property must be set among these properties: members, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set members value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Members $members
     * @return \StructType\UpdateUserGroupReq
     */
    public function setMembers(\StructType\Members $members = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($membersChoiceErrorMessage = self::validateMembersForChoiceConstraintsFromSetMembers($members))) {
            throw new \InvalidArgumentException($membersChoiceErrorMessage, __LINE__);
        }
        if (is_null($members) || (is_array($members) && empty($members))) {
            unset($this->members);
        } else {
            $this->members = $members;
        }
        return $this;
    }
    /**
     * Get removeUserRoles value
     * @return \StructType\RemoveUserRoles|null
     */
    public function getRemoveUserRoles()
    {
        return isset($this->removeUserRoles) ? $this->removeUserRoles : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveUserRoles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveUserRoles method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveUserRolesForChoiceConstraintsFromSetRemoveUserRoles($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addUserRoles',
            'userRoles',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeUserRoles can\'t be set as the property %s is already set. Only one property must be set among these properties: removeUserRoles, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeUserRoles value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RemoveUserRoles $removeUserRoles
     * @return \StructType\UpdateUserGroupReq
     */
    public function setRemoveUserRoles(\StructType\RemoveUserRoles $removeUserRoles = null)
    {
        // validation for constraint: choice(removeUserRoles, addUserRoles, userRoles)
        if ('' !== ($removeUserRolesChoiceErrorMessage = self::validateRemoveUserRolesForChoiceConstraintsFromSetRemoveUserRoles($removeUserRoles))) {
            throw new \InvalidArgumentException($removeUserRolesChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeUserRoles) || (is_array($removeUserRoles) && empty($removeUserRoles))) {
            unset($this->removeUserRoles);
        } else {
            $this->removeUserRoles = $removeUserRoles;
        }
        return $this;
    }
    /**
     * Get addUserRoles value
     * @return \StructType\AddUserRoles|null
     */
    public function getAddUserRoles()
    {
        return isset($this->addUserRoles) ? $this->addUserRoles : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddUserRoles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddUserRoles method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddUserRolesForChoiceConstraintsFromSetAddUserRoles($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeUserRoles',
            'userRoles',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addUserRoles can\'t be set as the property %s is already set. Only one property must be set among these properties: addUserRoles, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addUserRoles value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AddUserRoles $addUserRoles
     * @return \StructType\UpdateUserGroupReq
     */
    public function setAddUserRoles(\StructType\AddUserRoles $addUserRoles = null)
    {
        // validation for constraint: choice(removeUserRoles, addUserRoles, userRoles)
        if ('' !== ($addUserRolesChoiceErrorMessage = self::validateAddUserRolesForChoiceConstraintsFromSetAddUserRoles($addUserRoles))) {
            throw new \InvalidArgumentException($addUserRolesChoiceErrorMessage, __LINE__);
        }
        if (is_null($addUserRoles) || (is_array($addUserRoles) && empty($addUserRoles))) {
            unset($this->addUserRoles);
        } else {
            $this->addUserRoles = $addUserRoles;
        }
        return $this;
    }
    /**
     * Get userRoles value
     * @return \StructType\UserRoles|null
     */
    public function getUserRoles()
    {
        return isset($this->userRoles) ? $this->userRoles : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUserRoles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserRoles method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUserRolesForChoiceConstraintsFromSetUserRoles($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeUserRoles',
            'addUserRoles',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property userRoles can\'t be set as the property %s is already set. Only one property must be set among these properties: userRoles, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set userRoles value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UserRoles $userRoles
     * @return \StructType\UpdateUserGroupReq
     */
    public function setUserRoles(\StructType\UserRoles $userRoles = null)
    {
        // validation for constraint: choice(removeUserRoles, addUserRoles, userRoles)
        if ('' !== ($userRolesChoiceErrorMessage = self::validateUserRolesForChoiceConstraintsFromSetUserRoles($userRoles))) {
            throw new \InvalidArgumentException($userRolesChoiceErrorMessage, __LINE__);
        }
        if (is_null($userRoles) || (is_array($userRoles) && empty($userRoles))) {
            unset($this->userRoles);
        } else {
            $this->userRoles = $userRoles;
        }
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateUserGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($newName) && mb_strlen($newName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
}
