<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePresenceRedundancyGroupReq StructType
 * @subpackage Structs
 */
class UpdatePresenceRedundancyGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The server1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $server1;
    /**
     * The server2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $server2;
    /**
     * The haEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $haEnabled;
    /**
     * Constructor method for UpdatePresenceRedundancyGroupReq
     * @uses UpdatePresenceRedundancyGroupReq::setNewName()
     * @uses UpdatePresenceRedundancyGroupReq::setDescription()
     * @uses UpdatePresenceRedundancyGroupReq::setServer1()
     * @uses UpdatePresenceRedundancyGroupReq::setServer2()
     * @uses UpdatePresenceRedundancyGroupReq::setHaEnabled()
     * @param string $newName
     * @param string $description
     * @param \StructType\XFkType $server1
     * @param \StructType\XFkType $server2
     * @param string $haEnabled
     */
    public function __construct($newName = null, $description = null, \StructType\XFkType $server1 = null, \StructType\XFkType $server2 = null, $haEnabled = 'false')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setServer1($server1)
            ->setServer2($server2)
            ->setHaEnabled($haEnabled);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdatePresenceRedundancyGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($newName) && mb_strlen($newName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdatePresenceRedundancyGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get server1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getServer1()
    {
        return isset($this->server1) ? $this->server1 : null;
    }
    /**
     * Set server1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $server1
     * @return \StructType\UpdatePresenceRedundancyGroupReq
     */
    public function setServer1(\StructType\XFkType $server1 = null)
    {
        if (is_null($server1) || (is_array($server1) && empty($server1))) {
            unset($this->server1);
        } else {
            $this->server1 = $server1;
        }
        return $this;
    }
    /**
     * Get server2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getServer2()
    {
        return isset($this->server2) ? $this->server2 : null;
    }
    /**
     * Set server2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $server2
     * @return \StructType\UpdatePresenceRedundancyGroupReq
     */
    public function setServer2(\StructType\XFkType $server2 = null)
    {
        if (is_null($server2) || (is_array($server2) && empty($server2))) {
            unset($this->server2);
        } else {
            $this->server2 = $server2;
        }
        return $this;
    }
    /**
     * Get haEnabled value
     * @return string|null
     */
    public function getHaEnabled()
    {
        return $this->haEnabled;
    }
    /**
     * Set haEnabled value
     * @param string $haEnabled
     * @return \StructType\UpdatePresenceRedundancyGroupReq
     */
    public function setHaEnabled($haEnabled = 'false')
    {
        // validation for constraint: string
        if (!is_null($haEnabled) && !is_string($haEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($haEnabled, true), gettype($haEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($haEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $haEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($haEnabled, true)), __LINE__);
        }
        $this->haEnabled = $haEnabled;
        return $this;
    }
}
