<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePresenceGroupReq StructType
 * @subpackage Structs
 */
class UpdatePresenceGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The presenceGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PresenceGroups
     */
    public $presenceGroups;
    /**
     * Constructor method for UpdatePresenceGroupReq
     * @uses UpdatePresenceGroupReq::setNewName()
     * @uses UpdatePresenceGroupReq::setDescription()
     * @uses UpdatePresenceGroupReq::setPresenceGroups()
     * @param string $newName
     * @param string $description
     * @param \StructType\PresenceGroups $presenceGroups
     */
    public function __construct($newName = null, $description = null, \StructType\PresenceGroups $presenceGroups = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setPresenceGroups($presenceGroups);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdatePresenceGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\UpdatePresenceGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get presenceGroups value
     * @return \StructType\PresenceGroups|null
     */
    public function getPresenceGroups()
    {
        return $this->presenceGroups;
    }
    /**
     * Set presenceGroups value
     * @param \StructType\PresenceGroups $presenceGroups
     * @return \StructType\UpdatePresenceGroupReq
     */
    public function setPresenceGroups(\StructType\PresenceGroups $presenceGroups = null)
    {
        $this->presenceGroups = $presenceGroups;
        return $this;
    }
}
