<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePhoneSecurityProfileReq StructType
 * @subpackage Structs
 */
class UpdatePhoneSecurityProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The deviceSecurityMode
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: By Null String
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: 1024
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The tftpEncryptedConfig
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpEncryptedConfig;
    /**
     * The nonceValidityTime
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nonceValidityTime;
    /**
     * The transportType
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: TCP+UDP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $transportType;
    /**
     * The sipPhonePort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPhonePort;
    /**
     * The enableDigestAuthentication
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDigestAuthentication;
    /**
     * The excludeDigestCredentials
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $excludeDigestCredentials;
    /**
     * Constructor method for UpdatePhoneSecurityProfileReq
     * @uses UpdatePhoneSecurityProfileReq::setNewName()
     * @uses UpdatePhoneSecurityProfileReq::setDescription()
     * @uses UpdatePhoneSecurityProfileReq::setDeviceSecurityMode()
     * @uses UpdatePhoneSecurityProfileReq::setAuthenticationMode()
     * @uses UpdatePhoneSecurityProfileReq::setKeySize()
     * @uses UpdatePhoneSecurityProfileReq::setTftpEncryptedConfig()
     * @uses UpdatePhoneSecurityProfileReq::setNonceValidityTime()
     * @uses UpdatePhoneSecurityProfileReq::setTransportType()
     * @uses UpdatePhoneSecurityProfileReq::setSipPhonePort()
     * @uses UpdatePhoneSecurityProfileReq::setEnableDigestAuthentication()
     * @uses UpdatePhoneSecurityProfileReq::setExcludeDigestCredentials()
     * @param string $newName
     * @param string $description
     * @param string $deviceSecurityMode
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $tftpEncryptedConfig
     * @param string $nonceValidityTime
     * @param string $transportType
     * @param string $sipPhonePort
     * @param string $enableDigestAuthentication
     * @param string $excludeDigestCredentials
     */
    public function __construct($newName = null, $description = null, $deviceSecurityMode = null, $authenticationMode = 'By Null String', $keySize = '1024', $tftpEncryptedConfig = 'false', $nonceValidityTime = '600', $transportType = 'TCP+UDP', $sipPhonePort = '5060', $enableDigestAuthentication = 'false', $excludeDigestCredentials = 'false')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setTftpEncryptedConfig($tftpEncryptedConfig)
            ->setNonceValidityTime($nonceValidityTime)
            ->setTransportType($transportType)
            ->setSipPhonePort($sipPhonePort)
            ->setEnableDigestAuthentication($enableDigestAuthentication)
            ->setExcludeDigestCredentials($excludeDigestCredentials);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return isset($this->deviceSecurityMode) ? $this->deviceSecurityMode : null;
    }
    /**
     * Set deviceSecurityMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XDeviceSecurityMode::valueIsValid()
     * @uses \EnumType\XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSecurityMode
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setDeviceSecurityMode($deviceSecurityMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceSecurityMode::valueIsValid($deviceSecurityMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDeviceSecurityMode', is_array($deviceSecurityMode) ? implode(', ', $deviceSecurityMode) : var_export($deviceSecurityMode, true), implode(', ', \EnumType\XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        if (is_null($deviceSecurityMode) || (is_array($deviceSecurityMode) && empty($deviceSecurityMode))) {
            unset($this->deviceSecurityMode);
        } else {
            $this->deviceSecurityMode = $deviceSecurityMode;
        }
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \EnumType\XAuthenticationMode::valueIsValid()
     * @uses \EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XAuthenticationMode', is_array($authenticationMode) ? implode(', ', $authenticationMode) : var_export($authenticationMode, true), implode(', ', \EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \EnumType\XKeySize::valueIsValid()
     * @uses \EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setKeySize($keySize = '1024')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XKeySize', is_array($keySize) ? implode(', ', $keySize) : var_export($keySize, true), implode(', ', \EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get tftpEncryptedConfig value
     * @return string|null
     */
    public function getTftpEncryptedConfig()
    {
        return $this->tftpEncryptedConfig;
    }
    /**
     * Set tftpEncryptedConfig value
     * @param string $tftpEncryptedConfig
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setTftpEncryptedConfig($tftpEncryptedConfig = 'false')
    {
        // validation for constraint: string
        if (!is_null($tftpEncryptedConfig) && !is_string($tftpEncryptedConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tftpEncryptedConfig, true), gettype($tftpEncryptedConfig)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($tftpEncryptedConfig) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $tftpEncryptedConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($tftpEncryptedConfig, true)), __LINE__);
        }
        $this->tftpEncryptedConfig = $tftpEncryptedConfig;
        return $this;
    }
    /**
     * Get nonceValidityTime value
     * @return string|null
     */
    public function getNonceValidityTime()
    {
        return $this->nonceValidityTime;
    }
    /**
     * Set nonceValidityTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nonceValidityTime
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setNonceValidityTime($nonceValidityTime = '600')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($nonceValidityTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($nonceValidityTime) ? implode(', ', $nonceValidityTime) : var_export($nonceValidityTime, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->nonceValidityTime = $nonceValidityTime;
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @uses \EnumType\XTransport::valueIsValid()
     * @uses \EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportType
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setTransportType($transportType = 'TCP+UDP')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTransport::valueIsValid($transportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTransport', is_array($transportType) ? implode(', ', $transportType) : var_export($transportType, true), implode(', ', \EnumType\XTransport::getValidValues())), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get sipPhonePort value
     * @return string|null
     */
    public function getSipPhonePort()
    {
        return $this->sipPhonePort;
    }
    /**
     * Set sipPhonePort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPhonePort
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setSipPhonePort($sipPhonePort = '5060')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sipPhonePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($sipPhonePort) ? implode(', ', $sipPhonePort) : var_export($sipPhonePort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipPhonePort = $sipPhonePort;
        return $this;
    }
    /**
     * Get enableDigestAuthentication value
     * @return string|null
     */
    public function getEnableDigestAuthentication()
    {
        return $this->enableDigestAuthentication;
    }
    /**
     * Set enableDigestAuthentication value
     * @param string $enableDigestAuthentication
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setEnableDigestAuthentication($enableDigestAuthentication = 'false')
    {
        // validation for constraint: string
        if (!is_null($enableDigestAuthentication) && !is_string($enableDigestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableDigestAuthentication, true), gettype($enableDigestAuthentication)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableDigestAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDigestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableDigestAuthentication, true)), __LINE__);
        }
        $this->enableDigestAuthentication = $enableDigestAuthentication;
        return $this;
    }
    /**
     * Get excludeDigestCredentials value
     * @return string|null
     */
    public function getExcludeDigestCredentials()
    {
        return $this->excludeDigestCredentials;
    }
    /**
     * Set excludeDigestCredentials value
     * @param string $excludeDigestCredentials
     * @return \StructType\UpdatePhoneSecurityProfileReq
     */
    public function setExcludeDigestCredentials($excludeDigestCredentials = 'false')
    {
        // validation for constraint: string
        if (!is_null($excludeDigestCredentials) && !is_string($excludeDigestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($excludeDigestCredentials, true), gettype($excludeDigestCredentials)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($excludeDigestCredentials) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $excludeDigestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($excludeDigestCredentials, true)), __LINE__);
        }
        $this->excludeDigestCredentials = $excludeDigestCredentials;
        return $this;
    }
}
