<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateInterClusterServiceProfileReq StructType
 * @subpackage Structs
 */
class UpdateInterClusterServiceProfileReq extends APIRequest
{
    /**
     * The interClusterService
     * Meta information extracted from the WSDL
     * - choice: uuid | interClusterService
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - default: EMCC
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $interClusterService;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | interClusterService
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The isActivated
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for PSTN Access and RSVP Agent
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * Constructor method for UpdateInterClusterServiceProfileReq
     * @uses UpdateInterClusterServiceProfileReq::setInterClusterService()
     * @uses UpdateInterClusterServiceProfileReq::setUuid()
     * @uses UpdateInterClusterServiceProfileReq::setIsActivated()
     * @uses UpdateInterClusterServiceProfileReq::setSipTrunkName()
     * @param string $interClusterService
     * @param string $uuid
     * @param string $isActivated
     * @param \StructType\XFkType $sipTrunkName
     */
    public function __construct($interClusterService = 'EMCC', $uuid = null, $isActivated = 'false', \StructType\XFkType $sipTrunkName = null)
    {
        $this
            ->setInterClusterService($interClusterService)
            ->setUuid($uuid)
            ->setIsActivated($isActivated)
            ->setSipTrunkName($sipTrunkName);
    }
    /**
     * Get interClusterService value
     * @return string
     */
    public function getInterClusterService()
    {
        return isset($this->interClusterService) ? $this->interClusterService : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInterClusterService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterClusterService method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInterClusterServiceForChoiceConstraintsFromSetInterClusterService($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property interClusterService can\'t be set as the property %s is already set. Only one property must be set among these properties: interClusterService, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set interClusterService value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @uses \EnumType\XInterClusterService::valueIsValid()
     * @uses \EnumType\XInterClusterService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interClusterService
     * @return \StructType\UpdateInterClusterServiceProfileReq
     */
    public function setInterClusterService($interClusterService = 'EMCC')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInterClusterService::valueIsValid($interClusterService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInterClusterService', is_array($interClusterService) ? implode(', ', $interClusterService) : var_export($interClusterService, true), implode(', ', \EnumType\XInterClusterService::getValidValues())), __LINE__);
        }
        // validation for constraint: choice(uuid, interClusterService)
        if ('' !== ($interClusterServiceChoiceErrorMessage = self::validateInterClusterServiceForChoiceConstraintsFromSetInterClusterService($interClusterService))) {
            throw new \InvalidArgumentException($interClusterServiceChoiceErrorMessage, __LINE__);
        }
        if (is_null($interClusterService) || (is_array($interClusterService) && empty($interClusterService))) {
            unset($this->interClusterService);
        } else {
            $this->interClusterService = $interClusterService;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'interClusterService',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateInterClusterServiceProfileReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, interClusterService)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \StructType\UpdateInterClusterServiceProfileReq
     */
    public function setIsActivated($isActivated = 'false')
    {
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isActivated, true), gettype($isActivated)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isActivated, true)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \StructType\XFkType $sipTrunkName
     * @return \StructType\UpdateInterClusterServiceProfileReq
     */
    public function setSipTrunkName(\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
}
