<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeRouteFilterGroupReq StructType
 * @subpackage Structs
 */
class UpdateImeRouteFilterGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The groupTrustSetting
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $groupTrustSetting;
    /**
     * Constructor method for UpdateImeRouteFilterGroupReq
     * @uses UpdateImeRouteFilterGroupReq::setNewName()
     * @uses UpdateImeRouteFilterGroupReq::setDescription()
     * @uses UpdateImeRouteFilterGroupReq::setGroupTrustSetting()
     * @param string $newName
     * @param string $description
     * @param string $groupTrustSetting
     */
    public function __construct($newName = null, $description = null, $groupTrustSetting = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setGroupTrustSetting($groupTrustSetting);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateImeRouteFilterGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateImeRouteFilterGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get groupTrustSetting value
     * @return string|null
     */
    public function getGroupTrustSetting()
    {
        return $this->groupTrustSetting;
    }
    /**
     * Set groupTrustSetting value
     * @param string $groupTrustSetting
     * @return \StructType\UpdateImeRouteFilterGroupReq
     */
    public function setGroupTrustSetting($groupTrustSetting = null)
    {
        // validation for constraint: string
        if (!is_null($groupTrustSetting) && !is_string($groupTrustSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupTrustSetting, true), gettype($groupTrustSetting)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($groupTrustSetting) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $groupTrustSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($groupTrustSetting, true)), __LINE__);
        }
        $this->groupTrustSetting = $groupTrustSetting;
        return $this;
    }
}
