<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeRouteFilterElementReq StructType
 * @subpackage Structs
 */
class UpdateImeRouteFilterElementReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The elementType
     * Meta information extracted from the WSDL
     * - default: Domain
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $elementType;
    /**
     * The imeRouteFilterGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $imeRouteFilterGroupName;
    /**
     * Constructor method for UpdateImeRouteFilterElementReq
     * @uses UpdateImeRouteFilterElementReq::setNewName()
     * @uses UpdateImeRouteFilterElementReq::setDescription()
     * @uses UpdateImeRouteFilterElementReq::setElementType()
     * @uses UpdateImeRouteFilterElementReq::setImeRouteFilterGroupName()
     * @param string $newName
     * @param string $description
     * @param string $elementType
     * @param \StructType\XFkType $imeRouteFilterGroupName
     */
    public function __construct($newName = null, $description = null, $elementType = 'Domain', \StructType\XFkType $imeRouteFilterGroupName = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setElementType($elementType)
            ->setImeRouteFilterGroupName($imeRouteFilterGroupName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateImeRouteFilterElementReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateImeRouteFilterElementReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get elementType value
     * @return string|null
     */
    public function getElementType()
    {
        return $this->elementType;
    }
    /**
     * Set elementType value
     * @uses \EnumType\XViprFilterElement::valueIsValid()
     * @uses \EnumType\XViprFilterElement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $elementType
     * @return \StructType\UpdateImeRouteFilterElementReq
     */
    public function setElementType($elementType = 'Domain')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XViprFilterElement::valueIsValid($elementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XViprFilterElement', is_array($elementType) ? implode(', ', $elementType) : var_export($elementType, true), implode(', ', \EnumType\XViprFilterElement::getValidValues())), __LINE__);
        }
        $this->elementType = $elementType;
        return $this;
    }
    /**
     * Get imeRouteFilterGroupName value
     * @return \StructType\XFkType|null
     */
    public function getImeRouteFilterGroupName()
    {
        return $this->imeRouteFilterGroupName;
    }
    /**
     * Set imeRouteFilterGroupName value
     * @param \StructType\XFkType $imeRouteFilterGroupName
     * @return \StructType\UpdateImeRouteFilterElementReq
     */
    public function setImeRouteFilterGroupName(\StructType\XFkType $imeRouteFilterGroupName = null)
    {
        $this->imeRouteFilterGroupName = $imeRouteFilterGroupName;
        return $this;
    }
}
