<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeFeatureConfigReq StructType
 * @subpackage Structs
 */
class UpdateImeFeatureConfigReq extends AbstractStructBase
{
    /**
     * The preventImeCallsFromAnalogGateways
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $preventImeCallsFromAnalogGateways;
    /**
     * The enableIntraDomain
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableIntraDomain;
    /**
     * The allowMwiNotification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowMwiNotification;
    /**
     * The trunkConnectionTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $trunkConnectionTimer;
    /**
     * The firewallConnectionTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $firewallConnectionTimer;
    /**
     * The firewallTranscationTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $firewallTranscationTimer;
    /**
     * The firewallIdleTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firewallIdleTimer;
    /**
     * The failedCallAttemptThreshold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $failedCallAttemptThreshold;
    /**
     * The callFallbackAttemptThreshold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callFallbackAttemptThreshold;
    /**
     * The qualityTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $qualityTimer;
    /**
     * The useImeForOutboundCalls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useImeForOutboundCalls;
    /**
     * Constructor method for UpdateImeFeatureConfigReq
     * @uses UpdateImeFeatureConfigReq::setPreventImeCallsFromAnalogGateways()
     * @uses UpdateImeFeatureConfigReq::setEnableIntraDomain()
     * @uses UpdateImeFeatureConfigReq::setAllowMwiNotification()
     * @uses UpdateImeFeatureConfigReq::setTrunkConnectionTimer()
     * @uses UpdateImeFeatureConfigReq::setFirewallConnectionTimer()
     * @uses UpdateImeFeatureConfigReq::setFirewallTranscationTimer()
     * @uses UpdateImeFeatureConfigReq::setFirewallIdleTimer()
     * @uses UpdateImeFeatureConfigReq::setFailedCallAttemptThreshold()
     * @uses UpdateImeFeatureConfigReq::setCallFallbackAttemptThreshold()
     * @uses UpdateImeFeatureConfigReq::setQualityTimer()
     * @uses UpdateImeFeatureConfigReq::setUseImeForOutboundCalls()
     * @param string $preventImeCallsFromAnalogGateways
     * @param string $enableIntraDomain
     * @param string $allowMwiNotification
     * @param string $trunkConnectionTimer
     * @param string $firewallConnectionTimer
     * @param string $firewallTranscationTimer
     * @param string $firewallIdleTimer
     * @param string $failedCallAttemptThreshold
     * @param string $callFallbackAttemptThreshold
     * @param string $qualityTimer
     * @param string $useImeForOutboundCalls
     */
    public function __construct($preventImeCallsFromAnalogGateways = null, $enableIntraDomain = null, $allowMwiNotification = null, $trunkConnectionTimer = null, $firewallConnectionTimer = null, $firewallTranscationTimer = null, $firewallIdleTimer = null, $failedCallAttemptThreshold = null, $callFallbackAttemptThreshold = null, $qualityTimer = null, $useImeForOutboundCalls = null)
    {
        $this
            ->setPreventImeCallsFromAnalogGateways($preventImeCallsFromAnalogGateways)
            ->setEnableIntraDomain($enableIntraDomain)
            ->setAllowMwiNotification($allowMwiNotification)
            ->setTrunkConnectionTimer($trunkConnectionTimer)
            ->setFirewallConnectionTimer($firewallConnectionTimer)
            ->setFirewallTranscationTimer($firewallTranscationTimer)
            ->setFirewallIdleTimer($firewallIdleTimer)
            ->setFailedCallAttemptThreshold($failedCallAttemptThreshold)
            ->setCallFallbackAttemptThreshold($callFallbackAttemptThreshold)
            ->setQualityTimer($qualityTimer)
            ->setUseImeForOutboundCalls($useImeForOutboundCalls);
    }
    /**
     * Get preventImeCallsFromAnalogGateways value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreventImeCallsFromAnalogGateways()
    {
        return isset($this->preventImeCallsFromAnalogGateways) ? $this->preventImeCallsFromAnalogGateways : null;
    }
    /**
     * Set preventImeCallsFromAnalogGateways value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preventImeCallsFromAnalogGateways
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setPreventImeCallsFromAnalogGateways($preventImeCallsFromAnalogGateways = null)
    {
        // validation for constraint: string
        if (!is_null($preventImeCallsFromAnalogGateways) && !is_string($preventImeCallsFromAnalogGateways)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preventImeCallsFromAnalogGateways, true), gettype($preventImeCallsFromAnalogGateways)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($preventImeCallsFromAnalogGateways) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $preventImeCallsFromAnalogGateways)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($preventImeCallsFromAnalogGateways, true)), __LINE__);
        }
        if (is_null($preventImeCallsFromAnalogGateways) || (is_array($preventImeCallsFromAnalogGateways) && empty($preventImeCallsFromAnalogGateways))) {
            unset($this->preventImeCallsFromAnalogGateways);
        } else {
            $this->preventImeCallsFromAnalogGateways = $preventImeCallsFromAnalogGateways;
        }
        return $this;
    }
    /**
     * Get enableIntraDomain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnableIntraDomain()
    {
        return isset($this->enableIntraDomain) ? $this->enableIntraDomain : null;
    }
    /**
     * Set enableIntraDomain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enableIntraDomain
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setEnableIntraDomain($enableIntraDomain = null)
    {
        // validation for constraint: string
        if (!is_null($enableIntraDomain) && !is_string($enableIntraDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableIntraDomain, true), gettype($enableIntraDomain)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableIntraDomain) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableIntraDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableIntraDomain, true)), __LINE__);
        }
        if (is_null($enableIntraDomain) || (is_array($enableIntraDomain) && empty($enableIntraDomain))) {
            unset($this->enableIntraDomain);
        } else {
            $this->enableIntraDomain = $enableIntraDomain;
        }
        return $this;
    }
    /**
     * Get allowMwiNotification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllowMwiNotification()
    {
        return isset($this->allowMwiNotification) ? $this->allowMwiNotification : null;
    }
    /**
     * Set allowMwiNotification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allowMwiNotification
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setAllowMwiNotification($allowMwiNotification = null)
    {
        // validation for constraint: string
        if (!is_null($allowMwiNotification) && !is_string($allowMwiNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowMwiNotification, true), gettype($allowMwiNotification)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowMwiNotification) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowMwiNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowMwiNotification, true)), __LINE__);
        }
        if (is_null($allowMwiNotification) || (is_array($allowMwiNotification) && empty($allowMwiNotification))) {
            unset($this->allowMwiNotification);
        } else {
            $this->allowMwiNotification = $allowMwiNotification;
        }
        return $this;
    }
    /**
     * Get trunkConnectionTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrunkConnectionTimer()
    {
        return isset($this->trunkConnectionTimer) ? $this->trunkConnectionTimer : null;
    }
    /**
     * Set trunkConnectionTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkConnectionTimer
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setTrunkConnectionTimer($trunkConnectionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($trunkConnectionTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($trunkConnectionTimer) ? implode(', ', $trunkConnectionTimer) : var_export($trunkConnectionTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($trunkConnectionTimer) || (is_array($trunkConnectionTimer) && empty($trunkConnectionTimer))) {
            unset($this->trunkConnectionTimer);
        } else {
            $this->trunkConnectionTimer = $trunkConnectionTimer;
        }
        return $this;
    }
    /**
     * Get firewallConnectionTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirewallConnectionTimer()
    {
        return isset($this->firewallConnectionTimer) ? $this->firewallConnectionTimer : null;
    }
    /**
     * Set firewallConnectionTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firewallConnectionTimer
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setFirewallConnectionTimer($firewallConnectionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($firewallConnectionTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($firewallConnectionTimer) ? implode(', ', $firewallConnectionTimer) : var_export($firewallConnectionTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($firewallConnectionTimer) || (is_array($firewallConnectionTimer) && empty($firewallConnectionTimer))) {
            unset($this->firewallConnectionTimer);
        } else {
            $this->firewallConnectionTimer = $firewallConnectionTimer;
        }
        return $this;
    }
    /**
     * Get firewallTranscationTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirewallTranscationTimer()
    {
        return isset($this->firewallTranscationTimer) ? $this->firewallTranscationTimer : null;
    }
    /**
     * Set firewallTranscationTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firewallTranscationTimer
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setFirewallTranscationTimer($firewallTranscationTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($firewallTranscationTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($firewallTranscationTimer) ? implode(', ', $firewallTranscationTimer) : var_export($firewallTranscationTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($firewallTranscationTimer) || (is_array($firewallTranscationTimer) && empty($firewallTranscationTimer))) {
            unset($this->firewallTranscationTimer);
        } else {
            $this->firewallTranscationTimer = $firewallTranscationTimer;
        }
        return $this;
    }
    /**
     * Get firewallIdleTimer value
     * @return string|null
     */
    public function getFirewallIdleTimer()
    {
        return $this->firewallIdleTimer;
    }
    /**
     * Set firewallIdleTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firewallIdleTimer
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setFirewallIdleTimer($firewallIdleTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($firewallIdleTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($firewallIdleTimer) ? implode(', ', $firewallIdleTimer) : var_export($firewallIdleTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->firewallIdleTimer = $firewallIdleTimer;
        return $this;
    }
    /**
     * Get failedCallAttemptThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailedCallAttemptThreshold()
    {
        return isset($this->failedCallAttemptThreshold) ? $this->failedCallAttemptThreshold : null;
    }
    /**
     * Set failedCallAttemptThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failedCallAttemptThreshold
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setFailedCallAttemptThreshold($failedCallAttemptThreshold = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($failedCallAttemptThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($failedCallAttemptThreshold) ? implode(', ', $failedCallAttemptThreshold) : var_export($failedCallAttemptThreshold, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($failedCallAttemptThreshold) || (is_array($failedCallAttemptThreshold) && empty($failedCallAttemptThreshold))) {
            unset($this->failedCallAttemptThreshold);
        } else {
            $this->failedCallAttemptThreshold = $failedCallAttemptThreshold;
        }
        return $this;
    }
    /**
     * Get callFallbackAttemptThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallFallbackAttemptThreshold()
    {
        return isset($this->callFallbackAttemptThreshold) ? $this->callFallbackAttemptThreshold : null;
    }
    /**
     * Set callFallbackAttemptThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callFallbackAttemptThreshold
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setCallFallbackAttemptThreshold($callFallbackAttemptThreshold = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callFallbackAttemptThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callFallbackAttemptThreshold) ? implode(', ', $callFallbackAttemptThreshold) : var_export($callFallbackAttemptThreshold, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callFallbackAttemptThreshold) || (is_array($callFallbackAttemptThreshold) && empty($callFallbackAttemptThreshold))) {
            unset($this->callFallbackAttemptThreshold);
        } else {
            $this->callFallbackAttemptThreshold = $callFallbackAttemptThreshold;
        }
        return $this;
    }
    /**
     * Get qualityTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQualityTimer()
    {
        return isset($this->qualityTimer) ? $this->qualityTimer : null;
    }
    /**
     * Set qualityTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qualityTimer
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setQualityTimer($qualityTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($qualityTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($qualityTimer) ? implode(', ', $qualityTimer) : var_export($qualityTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($qualityTimer) || (is_array($qualityTimer) && empty($qualityTimer))) {
            unset($this->qualityTimer);
        } else {
            $this->qualityTimer = $qualityTimer;
        }
        return $this;
    }
    /**
     * Get useImeForOutboundCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUseImeForOutboundCalls()
    {
        return isset($this->useImeForOutboundCalls) ? $this->useImeForOutboundCalls : null;
    }
    /**
     * Set useImeForOutboundCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $useImeForOutboundCalls
     * @return \StructType\UpdateImeFeatureConfigReq
     */
    public function setUseImeForOutboundCalls($useImeForOutboundCalls = null)
    {
        // validation for constraint: string
        if (!is_null($useImeForOutboundCalls) && !is_string($useImeForOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useImeForOutboundCalls, true), gettype($useImeForOutboundCalls)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useImeForOutboundCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useImeForOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useImeForOutboundCalls, true)), __LINE__);
        }
        if (is_null($useImeForOutboundCalls) || (is_array($useImeForOutboundCalls) && empty($useImeForOutboundCalls))) {
            unset($this->useImeForOutboundCalls);
        } else {
            $this->useImeForOutboundCalls = $useImeForOutboundCalls;
        }
        return $this;
    }
}
