<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateGeoLocationFilterReq StructType
 * @subpackage Structs
 */
class UpdateGeoLocationFilterReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The useCountry
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCountry;
    /**
     * The useNationalSubDivision
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useNationalSubDivision;
    /**
     * The useDistrict
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDistrict;
    /**
     * The useCommunityName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCommunityName;
    /**
     * The useCityDivision
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCityDivision;
    /**
     * The useNeighbourhood
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useNeighbourhood;
    /**
     * The useStreet
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useStreet;
    /**
     * The useLeadingStreetDirection
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useLeadingStreetDirection;
    /**
     * The useTrailingStreetSuffix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useTrailingStreetSuffix;
    /**
     * The useStreetSuffix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useStreetSuffix;
    /**
     * The useHouseNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useHouseNumber;
    /**
     * The useHouseNumberSuffix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useHouseNumberSuffix;
    /**
     * The useLandmark
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useLandmark;
    /**
     * The useLocation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useLocation;
    /**
     * The useFloor
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useFloor;
    /**
     * The useOccupantName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useOccupantName;
    /**
     * The usePostalCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePostalCode;
    /**
     * Constructor method for UpdateGeoLocationFilterReq
     * @uses UpdateGeoLocationFilterReq::setNewName()
     * @uses UpdateGeoLocationFilterReq::setDescription()
     * @uses UpdateGeoLocationFilterReq::setUseCountry()
     * @uses UpdateGeoLocationFilterReq::setUseNationalSubDivision()
     * @uses UpdateGeoLocationFilterReq::setUseDistrict()
     * @uses UpdateGeoLocationFilterReq::setUseCommunityName()
     * @uses UpdateGeoLocationFilterReq::setUseCityDivision()
     * @uses UpdateGeoLocationFilterReq::setUseNeighbourhood()
     * @uses UpdateGeoLocationFilterReq::setUseStreet()
     * @uses UpdateGeoLocationFilterReq::setUseLeadingStreetDirection()
     * @uses UpdateGeoLocationFilterReq::setUseTrailingStreetSuffix()
     * @uses UpdateGeoLocationFilterReq::setUseStreetSuffix()
     * @uses UpdateGeoLocationFilterReq::setUseHouseNumber()
     * @uses UpdateGeoLocationFilterReq::setUseHouseNumberSuffix()
     * @uses UpdateGeoLocationFilterReq::setUseLandmark()
     * @uses UpdateGeoLocationFilterReq::setUseLocation()
     * @uses UpdateGeoLocationFilterReq::setUseFloor()
     * @uses UpdateGeoLocationFilterReq::setUseOccupantName()
     * @uses UpdateGeoLocationFilterReq::setUsePostalCode()
     * @param string $newName
     * @param string $description
     * @param string $useCountry
     * @param string $useNationalSubDivision
     * @param string $useDistrict
     * @param string $useCommunityName
     * @param string $useCityDivision
     * @param string $useNeighbourhood
     * @param string $useStreet
     * @param string $useLeadingStreetDirection
     * @param string $useTrailingStreetSuffix
     * @param string $useStreetSuffix
     * @param string $useHouseNumber
     * @param string $useHouseNumberSuffix
     * @param string $useLandmark
     * @param string $useLocation
     * @param string $useFloor
     * @param string $useOccupantName
     * @param string $usePostalCode
     */
    public function __construct($newName = null, $description = null, $useCountry = null, $useNationalSubDivision = null, $useDistrict = null, $useCommunityName = null, $useCityDivision = null, $useNeighbourhood = null, $useStreet = null, $useLeadingStreetDirection = null, $useTrailingStreetSuffix = null, $useStreetSuffix = null, $useHouseNumber = null, $useHouseNumberSuffix = null, $useLandmark = null, $useLocation = null, $useFloor = null, $useOccupantName = null, $usePostalCode = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setUseCountry($useCountry)
            ->setUseNationalSubDivision($useNationalSubDivision)
            ->setUseDistrict($useDistrict)
            ->setUseCommunityName($useCommunityName)
            ->setUseCityDivision($useCityDivision)
            ->setUseNeighbourhood($useNeighbourhood)
            ->setUseStreet($useStreet)
            ->setUseLeadingStreetDirection($useLeadingStreetDirection)
            ->setUseTrailingStreetSuffix($useTrailingStreetSuffix)
            ->setUseStreetSuffix($useStreetSuffix)
            ->setUseHouseNumber($useHouseNumber)
            ->setUseHouseNumberSuffix($useHouseNumberSuffix)
            ->setUseLandmark($useLandmark)
            ->setUseLocation($useLocation)
            ->setUseFloor($useFloor)
            ->setUseOccupantName($useOccupantName)
            ->setUsePostalCode($usePostalCode);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get useCountry value
     * @return string|null
     */
    public function getUseCountry()
    {
        return $this->useCountry;
    }
    /**
     * Set useCountry value
     * @param string $useCountry
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseCountry($useCountry = null)
    {
        // validation for constraint: string
        if (!is_null($useCountry) && !is_string($useCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useCountry, true), gettype($useCountry)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useCountry) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useCountry, true)), __LINE__);
        }
        $this->useCountry = $useCountry;
        return $this;
    }
    /**
     * Get useNationalSubDivision value
     * @return string|null
     */
    public function getUseNationalSubDivision()
    {
        return $this->useNationalSubDivision;
    }
    /**
     * Set useNationalSubDivision value
     * @param string $useNationalSubDivision
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseNationalSubDivision($useNationalSubDivision = null)
    {
        // validation for constraint: string
        if (!is_null($useNationalSubDivision) && !is_string($useNationalSubDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useNationalSubDivision, true), gettype($useNationalSubDivision)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useNationalSubDivision) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useNationalSubDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useNationalSubDivision, true)), __LINE__);
        }
        $this->useNationalSubDivision = $useNationalSubDivision;
        return $this;
    }
    /**
     * Get useDistrict value
     * @return string|null
     */
    public function getUseDistrict()
    {
        return $this->useDistrict;
    }
    /**
     * Set useDistrict value
     * @param string $useDistrict
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseDistrict($useDistrict = null)
    {
        // validation for constraint: string
        if (!is_null($useDistrict) && !is_string($useDistrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDistrict, true), gettype($useDistrict)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDistrict) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDistrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDistrict, true)), __LINE__);
        }
        $this->useDistrict = $useDistrict;
        return $this;
    }
    /**
     * Get useCommunityName value
     * @return string|null
     */
    public function getUseCommunityName()
    {
        return $this->useCommunityName;
    }
    /**
     * Set useCommunityName value
     * @param string $useCommunityName
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseCommunityName($useCommunityName = null)
    {
        // validation for constraint: string
        if (!is_null($useCommunityName) && !is_string($useCommunityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useCommunityName, true), gettype($useCommunityName)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useCommunityName) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCommunityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useCommunityName, true)), __LINE__);
        }
        $this->useCommunityName = $useCommunityName;
        return $this;
    }
    /**
     * Get useCityDivision value
     * @return string|null
     */
    public function getUseCityDivision()
    {
        return $this->useCityDivision;
    }
    /**
     * Set useCityDivision value
     * @param string $useCityDivision
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseCityDivision($useCityDivision = null)
    {
        // validation for constraint: string
        if (!is_null($useCityDivision) && !is_string($useCityDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useCityDivision, true), gettype($useCityDivision)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useCityDivision) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCityDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useCityDivision, true)), __LINE__);
        }
        $this->useCityDivision = $useCityDivision;
        return $this;
    }
    /**
     * Get useNeighbourhood value
     * @return string|null
     */
    public function getUseNeighbourhood()
    {
        return $this->useNeighbourhood;
    }
    /**
     * Set useNeighbourhood value
     * @param string $useNeighbourhood
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseNeighbourhood($useNeighbourhood = null)
    {
        // validation for constraint: string
        if (!is_null($useNeighbourhood) && !is_string($useNeighbourhood)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useNeighbourhood, true), gettype($useNeighbourhood)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useNeighbourhood) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useNeighbourhood)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useNeighbourhood, true)), __LINE__);
        }
        $this->useNeighbourhood = $useNeighbourhood;
        return $this;
    }
    /**
     * Get useStreet value
     * @return string|null
     */
    public function getUseStreet()
    {
        return $this->useStreet;
    }
    /**
     * Set useStreet value
     * @param string $useStreet
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseStreet($useStreet = null)
    {
        // validation for constraint: string
        if (!is_null($useStreet) && !is_string($useStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useStreet, true), gettype($useStreet)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useStreet) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useStreet, true)), __LINE__);
        }
        $this->useStreet = $useStreet;
        return $this;
    }
    /**
     * Get useLeadingStreetDirection value
     * @return string|null
     */
    public function getUseLeadingStreetDirection()
    {
        return $this->useLeadingStreetDirection;
    }
    /**
     * Set useLeadingStreetDirection value
     * @param string $useLeadingStreetDirection
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseLeadingStreetDirection($useLeadingStreetDirection = null)
    {
        // validation for constraint: string
        if (!is_null($useLeadingStreetDirection) && !is_string($useLeadingStreetDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useLeadingStreetDirection, true), gettype($useLeadingStreetDirection)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useLeadingStreetDirection) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useLeadingStreetDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useLeadingStreetDirection, true)), __LINE__);
        }
        $this->useLeadingStreetDirection = $useLeadingStreetDirection;
        return $this;
    }
    /**
     * Get useTrailingStreetSuffix value
     * @return string|null
     */
    public function getUseTrailingStreetSuffix()
    {
        return $this->useTrailingStreetSuffix;
    }
    /**
     * Set useTrailingStreetSuffix value
     * @param string $useTrailingStreetSuffix
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseTrailingStreetSuffix($useTrailingStreetSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($useTrailingStreetSuffix) && !is_string($useTrailingStreetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useTrailingStreetSuffix, true), gettype($useTrailingStreetSuffix)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useTrailingStreetSuffix) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useTrailingStreetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useTrailingStreetSuffix, true)), __LINE__);
        }
        $this->useTrailingStreetSuffix = $useTrailingStreetSuffix;
        return $this;
    }
    /**
     * Get useStreetSuffix value
     * @return string|null
     */
    public function getUseStreetSuffix()
    {
        return $this->useStreetSuffix;
    }
    /**
     * Set useStreetSuffix value
     * @param string $useStreetSuffix
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseStreetSuffix($useStreetSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($useStreetSuffix) && !is_string($useStreetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useStreetSuffix, true), gettype($useStreetSuffix)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useStreetSuffix) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useStreetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useStreetSuffix, true)), __LINE__);
        }
        $this->useStreetSuffix = $useStreetSuffix;
        return $this;
    }
    /**
     * Get useHouseNumber value
     * @return string|null
     */
    public function getUseHouseNumber()
    {
        return $this->useHouseNumber;
    }
    /**
     * Set useHouseNumber value
     * @param string $useHouseNumber
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseHouseNumber($useHouseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($useHouseNumber) && !is_string($useHouseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useHouseNumber, true), gettype($useHouseNumber)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useHouseNumber) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useHouseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useHouseNumber, true)), __LINE__);
        }
        $this->useHouseNumber = $useHouseNumber;
        return $this;
    }
    /**
     * Get useHouseNumberSuffix value
     * @return string|null
     */
    public function getUseHouseNumberSuffix()
    {
        return $this->useHouseNumberSuffix;
    }
    /**
     * Set useHouseNumberSuffix value
     * @param string $useHouseNumberSuffix
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseHouseNumberSuffix($useHouseNumberSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($useHouseNumberSuffix) && !is_string($useHouseNumberSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useHouseNumberSuffix, true), gettype($useHouseNumberSuffix)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useHouseNumberSuffix) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useHouseNumberSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useHouseNumberSuffix, true)), __LINE__);
        }
        $this->useHouseNumberSuffix = $useHouseNumberSuffix;
        return $this;
    }
    /**
     * Get useLandmark value
     * @return string|null
     */
    public function getUseLandmark()
    {
        return $this->useLandmark;
    }
    /**
     * Set useLandmark value
     * @param string $useLandmark
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseLandmark($useLandmark = null)
    {
        // validation for constraint: string
        if (!is_null($useLandmark) && !is_string($useLandmark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useLandmark, true), gettype($useLandmark)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useLandmark) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useLandmark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useLandmark, true)), __LINE__);
        }
        $this->useLandmark = $useLandmark;
        return $this;
    }
    /**
     * Get useLocation value
     * @return string|null
     */
    public function getUseLocation()
    {
        return $this->useLocation;
    }
    /**
     * Set useLocation value
     * @param string $useLocation
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseLocation($useLocation = null)
    {
        // validation for constraint: string
        if (!is_null($useLocation) && !is_string($useLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useLocation, true), gettype($useLocation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useLocation, true)), __LINE__);
        }
        $this->useLocation = $useLocation;
        return $this;
    }
    /**
     * Get useFloor value
     * @return string|null
     */
    public function getUseFloor()
    {
        return $this->useFloor;
    }
    /**
     * Set useFloor value
     * @param string $useFloor
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseFloor($useFloor = null)
    {
        // validation for constraint: string
        if (!is_null($useFloor) && !is_string($useFloor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useFloor, true), gettype($useFloor)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useFloor) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useFloor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useFloor, true)), __LINE__);
        }
        $this->useFloor = $useFloor;
        return $this;
    }
    /**
     * Get useOccupantName value
     * @return string|null
     */
    public function getUseOccupantName()
    {
        return $this->useOccupantName;
    }
    /**
     * Set useOccupantName value
     * @param string $useOccupantName
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUseOccupantName($useOccupantName = null)
    {
        // validation for constraint: string
        if (!is_null($useOccupantName) && !is_string($useOccupantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useOccupantName, true), gettype($useOccupantName)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useOccupantName) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useOccupantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useOccupantName, true)), __LINE__);
        }
        $this->useOccupantName = $useOccupantName;
        return $this;
    }
    /**
     * Get usePostalCode value
     * @return string|null
     */
    public function getUsePostalCode()
    {
        return $this->usePostalCode;
    }
    /**
     * Set usePostalCode value
     * @param string $usePostalCode
     * @return \StructType\UpdateGeoLocationFilterReq
     */
    public function setUsePostalCode($usePostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($usePostalCode) && !is_string($usePostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usePostalCode, true), gettype($usePostalCode)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($usePostalCode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($usePostalCode, true)), __LINE__);
        }
        $this->usePostalCode = $usePostalCode;
        return $this;
    }
}
