<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEmccFeatureConfigReq StructType
 * @subpackage Structs
 */
class UpdateEmccFeatureConfigReq extends APIRequest
{
    /**
     * The parameterName
     * Meta information extracted from the WSDL
     * - documentation: Name of the Emcc Parameter
     * - base: xsd:string
     * - choice: uuid | parameterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $parameterName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | parameterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $value;
    /**
     * Constructor method for UpdateEmccFeatureConfigReq
     * @uses UpdateEmccFeatureConfigReq::setParameterName()
     * @uses UpdateEmccFeatureConfigReq::setUuid()
     * @uses UpdateEmccFeatureConfigReq::setValue()
     * @param string $parameterName
     * @param string $uuid
     * @param string $value
     */
    public function __construct($parameterName = null, $uuid = null, $value = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setUuid($uuid)
            ->setValue($value);
    }
    /**
     * Get parameterName value
     * @return string
     */
    public function getParameterName()
    {
        return isset($this->parameterName) ? $this->parameterName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setParameterName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameterName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateParameterNameForChoiceConstraintsFromSetParameterName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property parameterName can\'t be set as the property %s is already set. Only one property must be set among these properties: parameterName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set parameterName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $parameterName
     * @return \StructType\UpdateEmccFeatureConfigReq
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterName, true), gettype($parameterName)), __LINE__);
        }
        // validation for constraint: choice(uuid, parameterName)
        if ('' !== ($parameterNameChoiceErrorMessage = self::validateParameterNameForChoiceConstraintsFromSetParameterName($parameterName))) {
            throw new \InvalidArgumentException($parameterNameChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($parameterName) && mb_strlen($parameterName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($parameterName)), __LINE__);
        }
        if (is_null($parameterName) || (is_array($parameterName) && empty($parameterName))) {
            unset($this->parameterName);
        } else {
            $this->parameterName = $parameterName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'parameterName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateEmccFeatureConfigReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, parameterName)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->value) ? $this->value : null;
    }
    /**
     * Set value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \StructType\UpdateEmccFeatureConfigReq
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($value) && mb_strlen($value) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->value);
        } else {
            $this->value = $value;
        }
        return $this;
    }
}
