<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDhcpSubnetReq StructType
 * @subpackage Structs
 */
class UpdateDhcpSubnetReq extends APIRequest
{
    /**
     * The dhcpServerName
     * Meta information extracted from the WSDL
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $dhcpServerName;
    /**
     * The subnetIpAddress
     * Meta information extracted from the WSDL
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $subnetIpAddress;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newDhcpServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $newDhcpServerName;
    /**
     * The newSubnetIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newSubnetIpAddress;
    /**
     * The primaryStartIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryStartIpAddress;
    /**
     * The primaryEndIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryEndIpAddress;
    /**
     * The secondaryStartIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryStartIpAddress;
    /**
     * The secondaryEndIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryEndIpAddress;
    /**
     * The primaryRouterIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryRouterIpAddress;
    /**
     * The secondaryRouterIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryRouterIpAddress;
    /**
     * The subnetMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subnetMask;
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The primaryDnsIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryDnsIpAddress;
    /**
     * The secondaryDnsIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryDnsIpAddress;
    /**
     * The tftpServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tftpServerName;
    /**
     * The primaryTftpServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryTftpServerIpAddress;
    /**
     * The secondaryTftpServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryTftpServerIpAddress;
    /**
     * The bootstrapServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bootstrapServerIpAddress;
    /**
     * The arpCacheTimeout
     * Meta information extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $arpCacheTimeout;
    /**
     * The ipAddressLeaseTime
     * Meta information extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddressLeaseTime;
    /**
     * The renewalTime
     * Meta information extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $renewalTime;
    /**
     * The rebindingTime
     * Meta information extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rebindingTime;
    /**
     * Constructor method for UpdateDhcpSubnetReq
     * @uses UpdateDhcpSubnetReq::setDhcpServerName()
     * @uses UpdateDhcpSubnetReq::setSubnetIpAddress()
     * @uses UpdateDhcpSubnetReq::setUuid()
     * @uses UpdateDhcpSubnetReq::setNewDhcpServerName()
     * @uses UpdateDhcpSubnetReq::setNewSubnetIpAddress()
     * @uses UpdateDhcpSubnetReq::setPrimaryStartIpAddress()
     * @uses UpdateDhcpSubnetReq::setPrimaryEndIpAddress()
     * @uses UpdateDhcpSubnetReq::setSecondaryStartIpAddress()
     * @uses UpdateDhcpSubnetReq::setSecondaryEndIpAddress()
     * @uses UpdateDhcpSubnetReq::setPrimaryRouterIpAddress()
     * @uses UpdateDhcpSubnetReq::setSecondaryRouterIpAddress()
     * @uses UpdateDhcpSubnetReq::setSubnetMask()
     * @uses UpdateDhcpSubnetReq::setDomainName()
     * @uses UpdateDhcpSubnetReq::setPrimaryDnsIpAddress()
     * @uses UpdateDhcpSubnetReq::setSecondaryDnsIpAddress()
     * @uses UpdateDhcpSubnetReq::setTftpServerName()
     * @uses UpdateDhcpSubnetReq::setPrimaryTftpServerIpAddress()
     * @uses UpdateDhcpSubnetReq::setSecondaryTftpServerIpAddress()
     * @uses UpdateDhcpSubnetReq::setBootstrapServerIpAddress()
     * @uses UpdateDhcpSubnetReq::setArpCacheTimeout()
     * @uses UpdateDhcpSubnetReq::setIpAddressLeaseTime()
     * @uses UpdateDhcpSubnetReq::setRenewalTime()
     * @uses UpdateDhcpSubnetReq::setRebindingTime()
     * @param \StructType\XFkType $dhcpServerName
     * @param string $subnetIpAddress
     * @param string $uuid
     * @param \StructType\XFkType $newDhcpServerName
     * @param string $newSubnetIpAddress
     * @param string $primaryStartIpAddress
     * @param string $primaryEndIpAddress
     * @param string $secondaryStartIpAddress
     * @param string $secondaryEndIpAddress
     * @param string $primaryRouterIpAddress
     * @param string $secondaryRouterIpAddress
     * @param string $subnetMask
     * @param string $domainName
     * @param string $primaryDnsIpAddress
     * @param string $secondaryDnsIpAddress
     * @param string $tftpServerName
     * @param string $primaryTftpServerIpAddress
     * @param string $secondaryTftpServerIpAddress
     * @param string $bootstrapServerIpAddress
     * @param string $arpCacheTimeout
     * @param string $ipAddressLeaseTime
     * @param string $renewalTime
     * @param string $rebindingTime
     */
    public function __construct(\StructType\XFkType $dhcpServerName = null, $subnetIpAddress = null, $uuid = null, \StructType\XFkType $newDhcpServerName = null, $newSubnetIpAddress = null, $primaryStartIpAddress = null, $primaryEndIpAddress = null, $secondaryStartIpAddress = null, $secondaryEndIpAddress = null, $primaryRouterIpAddress = null, $secondaryRouterIpAddress = null, $subnetMask = null, $domainName = null, $primaryDnsIpAddress = null, $secondaryDnsIpAddress = null, $tftpServerName = null, $primaryTftpServerIpAddress = null, $secondaryTftpServerIpAddress = null, $bootstrapServerIpAddress = null, $arpCacheTimeout = '0', $ipAddressLeaseTime = '0', $renewalTime = '0', $rebindingTime = '0')
    {
        $this
            ->setDhcpServerName($dhcpServerName)
            ->setSubnetIpAddress($subnetIpAddress)
            ->setUuid($uuid)
            ->setNewDhcpServerName($newDhcpServerName)
            ->setNewSubnetIpAddress($newSubnetIpAddress)
            ->setPrimaryStartIpAddress($primaryStartIpAddress)
            ->setPrimaryEndIpAddress($primaryEndIpAddress)
            ->setSecondaryStartIpAddress($secondaryStartIpAddress)
            ->setSecondaryEndIpAddress($secondaryEndIpAddress)
            ->setPrimaryRouterIpAddress($primaryRouterIpAddress)
            ->setSecondaryRouterIpAddress($secondaryRouterIpAddress)
            ->setSubnetMask($subnetMask)
            ->setDomainName($domainName)
            ->setPrimaryDnsIpAddress($primaryDnsIpAddress)
            ->setSecondaryDnsIpAddress($secondaryDnsIpAddress)
            ->setTftpServerName($tftpServerName)
            ->setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress)
            ->setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress)
            ->setBootstrapServerIpAddress($bootstrapServerIpAddress)
            ->setArpCacheTimeout($arpCacheTimeout)
            ->setIpAddressLeaseTime($ipAddressLeaseTime)
            ->setRenewalTime($renewalTime)
            ->setRebindingTime($rebindingTime);
    }
    /**
     * Get dhcpServerName value
     * @return \StructType\XFkType
     */
    public function getDhcpServerName()
    {
        return isset($this->dhcpServerName) ? $this->dhcpServerName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDhcpServerName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDhcpServerName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDhcpServerNameForChoiceConstraintsFromSetDhcpServerName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'subnetIpAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property dhcpServerName can\'t be set as the property %s is already set. Only one property must be set among these properties: dhcpServerName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set dhcpServerName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\XFkType $dhcpServerName
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setDhcpServerName(\StructType\XFkType $dhcpServerName = null)
    {
        // validation for constraint: choice(uuid, dhcpServerName, subnetIpAddress)
        if ('' !== ($dhcpServerNameChoiceErrorMessage = self::validateDhcpServerNameForChoiceConstraintsFromSetDhcpServerName($dhcpServerName))) {
            throw new \InvalidArgumentException($dhcpServerNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($dhcpServerName) || (is_array($dhcpServerName) && empty($dhcpServerName))) {
            unset($this->dhcpServerName);
        } else {
            $this->dhcpServerName = $dhcpServerName;
        }
        return $this;
    }
    /**
     * Get subnetIpAddress value
     * @return string
     */
    public function getSubnetIpAddress()
    {
        return isset($this->subnetIpAddress) ? $this->subnetIpAddress : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSubnetIpAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubnetIpAddress method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSubnetIpAddressForChoiceConstraintsFromSetSubnetIpAddress($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'dhcpServerName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property subnetIpAddress can\'t be set as the property %s is already set. Only one property must be set among these properties: subnetIpAddress, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set subnetIpAddress value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $subnetIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setSubnetIpAddress($subnetIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($subnetIpAddress) && !is_string($subnetIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subnetIpAddress, true), gettype($subnetIpAddress)), __LINE__);
        }
        // validation for constraint: choice(uuid, dhcpServerName, subnetIpAddress)
        if ('' !== ($subnetIpAddressChoiceErrorMessage = self::validateSubnetIpAddressForChoiceConstraintsFromSetSubnetIpAddress($subnetIpAddress))) {
            throw new \InvalidArgumentException($subnetIpAddressChoiceErrorMessage, __LINE__);
        }
        if (is_null($subnetIpAddress) || (is_array($subnetIpAddress) && empty($subnetIpAddress))) {
            unset($this->subnetIpAddress);
        } else {
            $this->subnetIpAddress = $subnetIpAddress;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'dhcpServerName',
            'subnetIpAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, dhcpServerName, subnetIpAddress)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newDhcpServerName value
     * @return \StructType\XFkType|null
     */
    public function getNewDhcpServerName()
    {
        return $this->newDhcpServerName;
    }
    /**
     * Set newDhcpServerName value
     * @param \StructType\XFkType $newDhcpServerName
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setNewDhcpServerName(\StructType\XFkType $newDhcpServerName = null)
    {
        $this->newDhcpServerName = $newDhcpServerName;
        return $this;
    }
    /**
     * Get newSubnetIpAddress value
     * @return string|null
     */
    public function getNewSubnetIpAddress()
    {
        return $this->newSubnetIpAddress;
    }
    /**
     * Set newSubnetIpAddress value
     * @param string $newSubnetIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setNewSubnetIpAddress($newSubnetIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($newSubnetIpAddress) && !is_string($newSubnetIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSubnetIpAddress, true), gettype($newSubnetIpAddress)), __LINE__);
        }
        $this->newSubnetIpAddress = $newSubnetIpAddress;
        return $this;
    }
    /**
     * Get primaryStartIpAddress value
     * @return string|null
     */
    public function getPrimaryStartIpAddress()
    {
        return $this->primaryStartIpAddress;
    }
    /**
     * Set primaryStartIpAddress value
     * @param string $primaryStartIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setPrimaryStartIpAddress($primaryStartIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryStartIpAddress) && !is_string($primaryStartIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryStartIpAddress, true), gettype($primaryStartIpAddress)), __LINE__);
        }
        $this->primaryStartIpAddress = $primaryStartIpAddress;
        return $this;
    }
    /**
     * Get primaryEndIpAddress value
     * @return string|null
     */
    public function getPrimaryEndIpAddress()
    {
        return $this->primaryEndIpAddress;
    }
    /**
     * Set primaryEndIpAddress value
     * @param string $primaryEndIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setPrimaryEndIpAddress($primaryEndIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryEndIpAddress) && !is_string($primaryEndIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryEndIpAddress, true), gettype($primaryEndIpAddress)), __LINE__);
        }
        $this->primaryEndIpAddress = $primaryEndIpAddress;
        return $this;
    }
    /**
     * Get secondaryStartIpAddress value
     * @return string|null
     */
    public function getSecondaryStartIpAddress()
    {
        return $this->secondaryStartIpAddress;
    }
    /**
     * Set secondaryStartIpAddress value
     * @param string $secondaryStartIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setSecondaryStartIpAddress($secondaryStartIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryStartIpAddress) && !is_string($secondaryStartIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryStartIpAddress, true), gettype($secondaryStartIpAddress)), __LINE__);
        }
        $this->secondaryStartIpAddress = $secondaryStartIpAddress;
        return $this;
    }
    /**
     * Get secondaryEndIpAddress value
     * @return string|null
     */
    public function getSecondaryEndIpAddress()
    {
        return $this->secondaryEndIpAddress;
    }
    /**
     * Set secondaryEndIpAddress value
     * @param string $secondaryEndIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setSecondaryEndIpAddress($secondaryEndIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryEndIpAddress) && !is_string($secondaryEndIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryEndIpAddress, true), gettype($secondaryEndIpAddress)), __LINE__);
        }
        $this->secondaryEndIpAddress = $secondaryEndIpAddress;
        return $this;
    }
    /**
     * Get primaryRouterIpAddress value
     * @return string|null
     */
    public function getPrimaryRouterIpAddress()
    {
        return $this->primaryRouterIpAddress;
    }
    /**
     * Set primaryRouterIpAddress value
     * @param string $primaryRouterIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setPrimaryRouterIpAddress($primaryRouterIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryRouterIpAddress) && !is_string($primaryRouterIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryRouterIpAddress, true), gettype($primaryRouterIpAddress)), __LINE__);
        }
        $this->primaryRouterIpAddress = $primaryRouterIpAddress;
        return $this;
    }
    /**
     * Get secondaryRouterIpAddress value
     * @return string|null
     */
    public function getSecondaryRouterIpAddress()
    {
        return $this->secondaryRouterIpAddress;
    }
    /**
     * Set secondaryRouterIpAddress value
     * @param string $secondaryRouterIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setSecondaryRouterIpAddress($secondaryRouterIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryRouterIpAddress) && !is_string($secondaryRouterIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryRouterIpAddress, true), gettype($secondaryRouterIpAddress)), __LINE__);
        }
        $this->secondaryRouterIpAddress = $secondaryRouterIpAddress;
        return $this;
    }
    /**
     * Get subnetMask value
     * @return string|null
     */
    public function getSubnetMask()
    {
        return $this->subnetMask;
    }
    /**
     * Set subnetMask value
     * @param string $subnetMask
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setSubnetMask($subnetMask = null)
    {
        // validation for constraint: string
        if (!is_null($subnetMask) && !is_string($subnetMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subnetMask, true), gettype($subnetMask)), __LINE__);
        }
        $this->subnetMask = $subnetMask;
        return $this;
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainName, true), gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get primaryDnsIpAddress value
     * @return string|null
     */
    public function getPrimaryDnsIpAddress()
    {
        return $this->primaryDnsIpAddress;
    }
    /**
     * Set primaryDnsIpAddress value
     * @param string $primaryDnsIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setPrimaryDnsIpAddress($primaryDnsIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryDnsIpAddress) && !is_string($primaryDnsIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryDnsIpAddress, true), gettype($primaryDnsIpAddress)), __LINE__);
        }
        $this->primaryDnsIpAddress = $primaryDnsIpAddress;
        return $this;
    }
    /**
     * Get secondaryDnsIpAddress value
     * @return string|null
     */
    public function getSecondaryDnsIpAddress()
    {
        return $this->secondaryDnsIpAddress;
    }
    /**
     * Set secondaryDnsIpAddress value
     * @param string $secondaryDnsIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setSecondaryDnsIpAddress($secondaryDnsIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryDnsIpAddress) && !is_string($secondaryDnsIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryDnsIpAddress, true), gettype($secondaryDnsIpAddress)), __LINE__);
        }
        $this->secondaryDnsIpAddress = $secondaryDnsIpAddress;
        return $this;
    }
    /**
     * Get tftpServerName value
     * @return string|null
     */
    public function getTftpServerName()
    {
        return $this->tftpServerName;
    }
    /**
     * Set tftpServerName value
     * @param string $tftpServerName
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setTftpServerName($tftpServerName = null)
    {
        // validation for constraint: string
        if (!is_null($tftpServerName) && !is_string($tftpServerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tftpServerName, true), gettype($tftpServerName)), __LINE__);
        }
        $this->tftpServerName = $tftpServerName;
        return $this;
    }
    /**
     * Get primaryTftpServerIpAddress value
     * @return string|null
     */
    public function getPrimaryTftpServerIpAddress()
    {
        return $this->primaryTftpServerIpAddress;
    }
    /**
     * Set primaryTftpServerIpAddress value
     * @param string $primaryTftpServerIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryTftpServerIpAddress) && !is_string($primaryTftpServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryTftpServerIpAddress, true), gettype($primaryTftpServerIpAddress)), __LINE__);
        }
        $this->primaryTftpServerIpAddress = $primaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get secondaryTftpServerIpAddress value
     * @return string|null
     */
    public function getSecondaryTftpServerIpAddress()
    {
        return $this->secondaryTftpServerIpAddress;
    }
    /**
     * Set secondaryTftpServerIpAddress value
     * @param string $secondaryTftpServerIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryTftpServerIpAddress) && !is_string($secondaryTftpServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryTftpServerIpAddress, true), gettype($secondaryTftpServerIpAddress)), __LINE__);
        }
        $this->secondaryTftpServerIpAddress = $secondaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get bootstrapServerIpAddress value
     * @return string|null
     */
    public function getBootstrapServerIpAddress()
    {
        return $this->bootstrapServerIpAddress;
    }
    /**
     * Set bootstrapServerIpAddress value
     * @param string $bootstrapServerIpAddress
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setBootstrapServerIpAddress($bootstrapServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bootstrapServerIpAddress) && !is_string($bootstrapServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bootstrapServerIpAddress, true), gettype($bootstrapServerIpAddress)), __LINE__);
        }
        $this->bootstrapServerIpAddress = $bootstrapServerIpAddress;
        return $this;
    }
    /**
     * Get arpCacheTimeout value
     * @return string|null
     */
    public function getArpCacheTimeout()
    {
        return $this->arpCacheTimeout;
    }
    /**
     * Set arpCacheTimeout value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arpCacheTimeout
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setArpCacheTimeout($arpCacheTimeout = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($arpCacheTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($arpCacheTimeout) ? implode(', ', $arpCacheTimeout) : var_export($arpCacheTimeout, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->arpCacheTimeout = $arpCacheTimeout;
        return $this;
    }
    /**
     * Get ipAddressLeaseTime value
     * @return string|null
     */
    public function getIpAddressLeaseTime()
    {
        return $this->ipAddressLeaseTime;
    }
    /**
     * Set ipAddressLeaseTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressLeaseTime
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setIpAddressLeaseTime($ipAddressLeaseTime = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($ipAddressLeaseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($ipAddressLeaseTime) ? implode(', ', $ipAddressLeaseTime) : var_export($ipAddressLeaseTime, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->ipAddressLeaseTime = $ipAddressLeaseTime;
        return $this;
    }
    /**
     * Get renewalTime value
     * @return string|null
     */
    public function getRenewalTime()
    {
        return $this->renewalTime;
    }
    /**
     * Set renewalTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewalTime
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setRenewalTime($renewalTime = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($renewalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($renewalTime) ? implode(', ', $renewalTime) : var_export($renewalTime, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->renewalTime = $renewalTime;
        return $this;
    }
    /**
     * Get rebindingTime value
     * @return string|null
     */
    public function getRebindingTime()
    {
        return $this->rebindingTime;
    }
    /**
     * Set rebindingTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rebindingTime
     * @return \StructType\UpdateDhcpSubnetReq
     */
    public function setRebindingTime($rebindingTime = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($rebindingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($rebindingTime) ? implode(', ', $rebindingTime) : var_export($rebindingTime, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rebindingTime = $rebindingTime;
        return $this;
    }
}
