<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomUserFieldReq StructType
 * @subpackage Structs
 */
class UpdateCustomUserFieldReq extends APIRequest
{
    /**
     * The field
     * Meta information extracted from the WSDL
     * - choice: uuid | field
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $field;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | field
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newField
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newField;
    /**
     * Constructor method for UpdateCustomUserFieldReq
     * @uses UpdateCustomUserFieldReq::setField()
     * @uses UpdateCustomUserFieldReq::setUuid()
     * @uses UpdateCustomUserFieldReq::setNewField()
     * @param string $field
     * @param string $uuid
     * @param string $newField
     */
    public function __construct($field = null, $uuid = null, $newField = null)
    {
        $this
            ->setField($field)
            ->setUuid($uuid)
            ->setNewField($newField);
    }
    /**
     * Get field value
     * @return string
     */
    public function getField()
    {
        return isset($this->field) ? $this->field : null;
    }
    /**
     * This method is responsible for validating the value passed to the setField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setField method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFieldForChoiceConstraintsFromSetField($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property field can\'t be set as the property %s is already set. Only one property must be set among these properties: field, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set field value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $field
     * @return \StructType\UpdateCustomUserFieldReq
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field, true), gettype($field)), __LINE__);
        }
        // validation for constraint: choice(uuid, field)
        if ('' !== ($fieldChoiceErrorMessage = self::validateFieldForChoiceConstraintsFromSetField($field))) {
            throw new \InvalidArgumentException($fieldChoiceErrorMessage, __LINE__);
        }
        if (is_null($field) || (is_array($field) && empty($field))) {
            unset($this->field);
        } else {
            $this->field = $field;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'field',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateCustomUserFieldReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, field)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newField value
     * @return string|null
     */
    public function getNewField()
    {
        return $this->newField;
    }
    /**
     * Set newField value
     * @param string $newField
     * @return \StructType\UpdateCustomUserFieldReq
     */
    public function setNewField($newField = null)
    {
        // validation for constraint: string
        if (!is_null($newField) && !is_string($newField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newField, true), gettype($newField)), __LINE__);
        }
        $this->newField = $newField;
        return $this;
    }
}
