<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateBlockedLearnedPatternsReq StructType
 * @subpackage Structs
 */
class UpdateBlockedLearnedPatternsReq extends APIRequest
{
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The prefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $prefix;
    /**
     * The clusterId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $clusterId;
    /**
     * The patternType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $patternType;
    /**
     * Constructor method for UpdateBlockedLearnedPatternsReq
     * @uses UpdateBlockedLearnedPatternsReq::setUuid()
     * @uses UpdateBlockedLearnedPatternsReq::setPattern()
     * @uses UpdateBlockedLearnedPatternsReq::setDescription()
     * @uses UpdateBlockedLearnedPatternsReq::setNewPattern()
     * @uses UpdateBlockedLearnedPatternsReq::setPrefix()
     * @uses UpdateBlockedLearnedPatternsReq::setClusterId()
     * @uses UpdateBlockedLearnedPatternsReq::setPatternType()
     * @param string $uuid
     * @param string $pattern
     * @param string $description
     * @param string $newPattern
     * @param string $prefix
     * @param string $clusterId
     * @param string $patternType
     */
    public function __construct($uuid = null, $pattern = null, $description = null, $newPattern = null, $prefix = null, $clusterId = null, $patternType = null)
    {
        $this
            ->setUuid($uuid)
            ->setPattern($pattern)
            ->setDescription($description)
            ->setNewPattern($newPattern)
            ->setPrefix($prefix)
            ->setClusterId($clusterId)
            ->setPatternType($patternType);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'pattern',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateBlockedLearnedPatternsReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, pattern)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPattern method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPattern method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePatternForChoiceConstraintsFromSetPattern($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property pattern can\'t be set as the property %s is already set. Only one property must be set among these properties: pattern, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pattern
     * @return \StructType\UpdateBlockedLearnedPatternsReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        // validation for constraint: choice(uuid, pattern)
        if ('' !== ($patternChoiceErrorMessage = self::validatePatternForChoiceConstraintsFromSetPattern($pattern))) {
            throw new \InvalidArgumentException($patternChoiceErrorMessage, __LINE__);
        }
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateBlockedLearnedPatternsReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \StructType\UpdateBlockedLearnedPatternsReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPattern, true), gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \StructType\UpdateBlockedLearnedPatternsReq
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get clusterId value
     * @return string|null
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \StructType\UpdateBlockedLearnedPatternsReq
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clusterId, true), gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get patternType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPatternType()
    {
        return isset($this->patternType) ? $this->patternType : null;
    }
    /**
     * Set patternType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XGlobalNumber::valueIsValid()
     * @uses \EnumType\XGlobalNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternType
     * @return \StructType\UpdateBlockedLearnedPatternsReq
     */
    public function setPatternType($patternType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XGlobalNumber::valueIsValid($patternType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XGlobalNumber', is_array($patternType) ? implode(', ', $patternType) : var_export($patternType, true), implode(', ', \EnumType\XGlobalNumber::getValidValues())), __LINE__);
        }
        if (is_null($patternType) || (is_array($patternType) && empty($patternType))) {
            unset($this->patternType);
        } else {
            $this->patternType = $patternType;
        }
        return $this;
    }
}
